/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.web.internal.portlet;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sync.exception.OAuthPortletUndeployedException;
import com.liferay.sync.oauth.helper.SyncOAuthHelperUtil;
import com.liferay.sync.util.SyncHelper;
import com.liferay.sync.web.internal.portlet.BaseSyncPortlet;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-sync-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Sync Connector Admin", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_sync_web_portlet_SyncAdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class SyncAdminPortlet
extends BaseSyncPortlet {
    private GroupLocalService _groupLocalService;
    @Reference
    private SyncHelper _syncHelper;
    private SyncOAuthHelperUtil _syncOAuthHelperUtil;

    public void updatePreferences(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        try {
            this.doUpdatePreferences(actionRequest, actionResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void updateSites(ActionRequest actionRequest, ActionResponse actionResponse) {
        long[] groupIds;
        String enabled = ParamUtil.getString((PortletRequest)actionRequest, (String)"enabled");
        String permissions = ParamUtil.getString((PortletRequest)actionRequest, (String)"permissions");
        for (long groupId : groupIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"groupIds")) {
            Group group = this._groupLocalService.fetchGroup(groupId);
            UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
            if (Validator.isNotNull((String)enabled)) {
                typeSettingsProperties.setProperty("syncEnabled", enabled);
            }
            if (Validator.isNotNull((String)permissions)) {
                typeSettingsProperties.setProperty("syncSiteMemberFilePermissions", permissions);
            }
            group.setTypeSettingsProperties(typeSettingsProperties);
            this._groupLocalService.updateGroup(group);
        }
    }

    protected void doUpdatePreferences(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences((long)CompanyThreadLocal.getCompanyId());
        boolean allowUserPersonalSites = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowUserPersonalSites");
        portletPreferences.setValue("sync.allow.user.personal.sites", String.valueOf(allowUserPersonalSites));
        boolean enabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"enabled");
        portletPreferences.setValue("sync.services.enabled", String.valueOf(enabled));
        boolean forceSecurityMode = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"forceSecurityMode");
        portletPreferences.setValue("sync.client.force.security.mode", String.valueOf(forceSecurityMode));
        boolean lanEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"lanEnabled");
        if (lanEnabled) {
            this._syncHelper.enableLanSync(CompanyThreadLocal.getCompanyId().longValue());
        }
        portletPreferences.setValue("sync.lan.enabled", String.valueOf(lanEnabled));
        int maxConnections = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxConnections");
        portletPreferences.setValue("sync.client.max.connections", String.valueOf(maxConnections));
        int maxDownloadRate = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxDownloadRate");
        portletPreferences.setValue("sync.client.max.download.rate", String.valueOf(maxDownloadRate));
        int maxUploadRate = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"maxUploadRate");
        portletPreferences.setValue("sync.client.max.upload.rate", String.valueOf(maxUploadRate));
        boolean oAuthEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"oAuthEnabled");
        portletPreferences.setValue("sync.oauth.enabled", String.valueOf(oAuthEnabled));
        int pollInterval = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"pollInterval");
        portletPreferences.setValue("sync.client.poll.interval", String.valueOf(pollInterval));
        portletPreferences.setValue("sync.context.modified.time", String.valueOf(System.currentTimeMillis()));
        portletPreferences.store();
        if (oAuthEnabled) {
            SyncAdminPortlet syncAdminPortlet = this;
            if (!syncAdminPortlet._syncOAuthHelperUtil.isDeployed()) {
                SessionErrors.add((PortletRequest)actionRequest, OAuthPortletUndeployedException.class);
                return;
            }
            ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
            SyncOAuthHelperUtil.enableOAuth((long)CompanyThreadLocal.getCompanyId(), (ServiceContext)serviceContext);
        }
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.sync.web)(&(release.schema.version>=1.0.0)(!(release.schema.version>=1.1.0))))", unbind="-")
    protected void setRelease(Release release) {
    }

    @Reference(unbind="-")
    protected void setSyncOAuthHelperUtil(SyncOAuthHelperUtil syncOAuthHelperUtil) {
        this._syncOAuthHelperUtil = syncOAuthHelperUtil;
    }
}

