/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.web.internal.messaging;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.web.internal.configuration.SubscriptionConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.subscription.web.internal.configuration.SubscriptionConfiguration"}, immediate=true, service={})
public class DeleteExpiredTicketsMessageListener
extends BaseMessageListener {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    private volatile SubscriptionConfiguration _subscriptionConfiguration;
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._subscriptionConfiguration = (SubscriptionConfiguration)ConfigurableUtil.createConfigurable(SubscriptionConfiguration.class, properties);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._subscriptionConfiguration.deleteExpiredTicketsInterval(), TimeUnit.HOUR);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        long subscriptionClassNameId = this._classNameLocalService.getClassNameId(Subscription.class);
        ActionableDynamicQuery actionableDynamicQuery = this._ticketLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.and((Criterion)RestrictionsFactoryUtil.eq((String)"type", (Object)0), (Criterion)RestrictionsFactoryUtil.eq((String)"classNameId", (Object)subscriptionClassNameId))));
        actionableDynamicQuery.setPerformActionMethod(ticket -> {
            if (ticket.isExpired()) {
                this._ticketLocalService.deleteTicket(ticket);
            }
        });
        actionableDynamicQuery.performActions();
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

