/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.subscription.test.util;

import com.liferay.layout.test.util.LayoutTestUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.test.mail.MailServiceTestUtil;
import com.liferay.portal.test.rule.Inject;
import com.liferay.subscription.test.util.BaseSubscriptionTestCase;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseSubscriptionLocalizedContentTestCase
extends BaseSubscriptionTestCase {
    protected static final String GERMAN_BODY = "Hallo Welt";
    protected static final String SPANISH_BODY = "Hola Mundo";
    protected Locale defaultLocale;
    protected Layout layout;
    protected Map<Locale, String> localizedContents = new HashMap<Locale, String>();
    @Inject
    private SettingsFactory _settingsFactory;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.defaultLocale = LocaleThreadLocal.getDefaultLocale();
        this.layout = LayoutTestUtil.addLayout((Group)this.group);
    }

    @After
    public void tearDown() throws Exception {
        LocaleThreadLocal.setDefaultLocale((Locale)this.defaultLocale);
    }

    @Test
    public void testSubscriptionLocalizedContentWhenAddingBaseModel() throws Exception {
        HashMap previousLocalizedContents = HashMapBuilder.putAll(this.localizedContents).build();
        this.localizedContents.put(LocaleUtil.GERMANY, GERMAN_BODY);
        this.setBaseModelSubscriptionBodyPreferences(this.getSubscriptionAddedBodyPreferenceName());
        this.addSubscriptionContainerModel(this.getDefaultContainerModelId());
        LocaleThreadLocal.setDefaultLocale((Locale)LocaleUtil.GERMANY);
        this.addBaseModel(this.creatorUser.getUserId(), this.getDefaultContainerModelId());
        List messages = MailServiceTestUtil.getMailMessages((String)"Body", (String)GERMAN_BODY);
        Assert.assertEquals((String)messages.toString(), (long)1L, (long)messages.size());
        this.localizedContents = previousLocalizedContents;
    }

    @Test
    public void testSubscriptionLocalizedContentWhenUpdatingBaseModel() throws Exception {
        HashMap previousLocalizedContents = HashMapBuilder.putAll(this.localizedContents).build();
        this.localizedContents.put(LocaleUtil.SPAIN, SPANISH_BODY);
        this.setBaseModelSubscriptionBodyPreferences(this.getSubscriptionUpdatedBodyPreferenceName());
        LocaleThreadLocal.setDefaultLocale((Locale)LocaleUtil.SPAIN);
        long baseModelId = this.addBaseModel(this.creatorUser.getUserId(), this.getDefaultContainerModelId());
        this.addSubscriptionContainerModel(this.getDefaultContainerModelId());
        this.updateBaseModel(this.creatorUser.getUserId(), baseModelId);
        List messages = MailServiceTestUtil.getMailMessages((String)"Body", (String)SPANISH_BODY);
        Assert.assertEquals((String)messages.toString(), (long)1L, (long)messages.size());
        this.localizedContents = previousLocalizedContents;
    }

    protected abstract void addSubscriptionContainerModel(long var1) throws Exception;

    protected long getDefaultContainerModelId() {
        return 0L;
    }

    protected abstract String getPortletId();

    protected String getServiceName() {
        return "";
    }

    protected abstract String getSubscriptionAddedBodyPreferenceName();

    protected abstract String getSubscriptionUpdatedBodyPreferenceName();

    protected void setBaseModelSubscriptionBodyPreferences(String bodyPreferenceName) throws Exception {
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(this.group.getGroupId(), this.getServiceName()));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        for (Map.Entry<Locale, String> localizedContent : this.localizedContents.entrySet()) {
            modifiableSettings.setValue(LocalizationUtil.getLocalizedName((String)bodyPreferenceName, (String)LocaleUtil.toLanguageId((Locale)localizedContent.getKey())), localizedContent.getValue());
        }
        modifiableSettings.store();
    }
}

