/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.architect.resource;

import com.liferay.aggregate.rating.apio.architect.identifier.AggregateRatingIdentifier;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetTagModel;
import com.liferay.asset.kernel.model.DDMFormValuesReader;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.comment.apio.architect.identifier.CommentIdentifier;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleModel;
import com.liferay.journal.model.JournalArticleWrapper;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.JournalContent;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.structure.apio.architect.identifier.ContentStructureIdentifier;
import com.liferay.structured.content.apio.architect.identifier.StructuredContentIdentifier;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentCreatorForm;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentUpdaterForm;
import com.liferay.structured.content.apio.internal.model.RenderedJournalArticle;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class StructuredContentNestedCollectionResource
implements NestedCollectionResource<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long, StructuredContentIdentifier, Long, ContentSpaceIdentifier> {
    private static final Log _log = LogFactoryUtil.getLog(StructuredContentNestedCollectionResource.class);
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private HasPermission<Long> _hasPermission;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;

    public NestedCollectionRoutes<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems, ThemeDisplay.class).addCreator(this::_addJournalArticle, ThemeDisplay.class, this._hasPermission.forAddingIn(ContentSpaceIdentifier.class), StructuredContentCreatorForm::buildForm).build();
    }

    public String getName() {
        return "structured-contents";
    }

    public ItemRoutes<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long> itemRoutes(ItemRoutes.Builder<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long> builder) {
        return builder.addGetter(this::_getJournalArticleWrapper, ThemeDisplay.class).addRemover(Idempotent.idempotent(this::_deleteJournalArticle), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).addUpdater(this::_updateJournalArticle, ThemeDisplay.class, (arg_0, arg_1) -> this._hasPermission.forUpdating(arg_0, arg_1), StructuredContentUpdaterForm::buildForm).build();
    }

    public Representor<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper> representor(Representor.Builder<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("StructuredContent", new String[0]).identifier(JournalArticleModel::getId).addBidirectionalModel("contentSpace", "structuredContents", ContentSpaceIdentifier.class, JournalArticleModel::getGroupId).addDate("dateCreated", JournalArticleModel::getCreateDate)).addDate("dateModified", JournalArticleModel::getModifiedDate)).addDate("datePublished", JournalArticleModel::getDisplayDate)).addDate("lastReviewed", JournalArticleModel::getReviewDate)).addLinkedModel("aggregateRating", AggregateRatingIdentifier.class, this::_createClassNameClassPK)).addLinkedModel("contentStructure", ContentStructureIdentifier.class, this::_getJournalArticleStructureId)).addLinkedModel("creator", PersonIdentifier.class, JournalArticleModel::getUserId)).addLocalizedStringByLocale("description", JournalArticleWrapper::getDescription)).addLocalizedStringByLocale("title", JournalArticle::getTitle)).addNestedList("renderedContentsByTemplate", this::_getRenderedJournalArticles, nestedBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)nestedBuilder.types("templates", new String[0]).addLocalizedStringByLocale("template", RenderedJournalArticle::getTemplateName)).addLocalizedStringByLocale("renderedContent", RenderedJournalArticle::getRenderedContent)).build())).addNestedList("values", this::_getJournalArticleDDMFormFieldValues, fieldValuesBuilder -> (NestedRepresentor)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)((NestedRepresentor.FirstStep)fieldValuesBuilder.types("ContentFieldValue", new String[0]).addLinkedModel("file", MediaObjectIdentifier.class, this::_getFileEntryId)).addLocalizedStringByLocale("value", this::_getLocalizedString)).addString("name", DDMFormFieldValue::getName)).build())).addRelatedCollection("categories", CategoryIdentifier.class).addRelatedCollection("comments", CommentIdentifier.class).addStringList("keywords", this::_getJournalArticleAssetTags)).build();
    }

    private com.liferay.structured.content.apio.internal.model.JournalArticleWrapper _addJournalArticle(long contentSpaceId, StructuredContentCreatorForm structuredContentCreatorForm, ThemeDisplay themeDisplay) throws PortalException {
        Locale locale = themeDisplay.getLocale();
        ServiceContext serviceContext = structuredContentCreatorForm.getServiceContext(contentSpaceId);
        JournalArticle journalArticle = this._journalArticleService.addArticle(contentSpaceId, 0L, 0L, 0L, null, true, structuredContentCreatorForm.getTitleMap(locale), structuredContentCreatorForm.getDescriptionMap(locale), structuredContentCreatorForm.getText(), structuredContentCreatorForm.getStructure(), structuredContentCreatorForm.getTemplate(), null, structuredContentCreatorForm.getDisplayDateMonth(), structuredContentCreatorForm.getDisplayDateDay(), structuredContentCreatorForm.getDisplayDateYear(), structuredContentCreatorForm.getDisplayDateHour(), structuredContentCreatorForm.getDisplayDateMinute(), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, null, serviceContext);
        return new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper(journalArticle, themeDisplay);
    }

    private ClassNameClassPK _createClassNameClassPK(JournalArticle journalArticle) {
        return ClassNameClassPK.create((String)JournalArticle.class.getName(), (long)journalArticle.getResourcePrimKey());
    }

    private void _deleteJournalArticle(long journalArticleId) throws PortalException {
        JournalArticle journalArticle = this._journalArticleService.getArticle(journalArticleId);
        this._journalArticleService.deleteArticle(journalArticle.getGroupId(), journalArticle.getArticleId(), journalArticle.getArticleResourceUuid(), new ServiceContext());
    }

    private Long _getFileEntryId(DDMFormFieldValue ddmFormFieldValue) {
        block3: {
            Value value = ddmFormFieldValue.getValue();
            String valueString = value.getString(LocaleUtil.getDefault());
            try {
                if (this._isJSONObject(valueString)) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
                    String uuid = jsonObject.getString("uuid");
                    long groupId = jsonObject.getLong("groupId");
                    FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
                    return fileEntry.getFileEntryId();
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return null;
    }

    private List<DDMFormFieldValue> _getFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues) {
        Stream ddmFormFieldValueStream = ddmFormFieldValues.stream();
        List<DDMFormFieldValue> nestedDDMFormFieldValues = ddmFormFieldValueStream.flatMap(ddmFormFieldValue -> this._getFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues()).stream()).collect(Collectors.toList());
        nestedDDMFormFieldValues.addAll(ddmFormFieldValues);
        return nestedDDMFormFieldValues;
    }

    private List<String> _getJournalArticleAssetTags(JournalArticle journalArticle) {
        List assetTags = this._assetTagLocalService.getTags(JournalArticle.class.getName(), journalArticle.getResourcePrimKey());
        return ListUtil.toList((List)assetTags, AssetTagModel::getName);
    }

    private List<DDMFormFieldValue> _getJournalArticleDDMFormFieldValues(com.liferay.structured.content.apio.internal.model.JournalArticleWrapper journalArticleWrapper) {
        return (List)Try.fromFallible(() -> AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class)).map(assetRendererFactory -> assetRendererFactory.getAssetRenderer((Object)journalArticleWrapper, 1)).map(AssetRenderer::getDDMFormValuesReader).map(DDMFormValuesReader::getDDMFormValues).map(DDMFormValues::getDDMFormFieldValues).map(this::_getFormFieldValues).orElse(null);
    }

    private Long _getJournalArticleStructureId(com.liferay.structured.content.apio.internal.model.JournalArticleWrapper journalArticleWrapper) {
        DDMStructure ddmStructure = journalArticleWrapper.getDDMStructure();
        return ddmStructure.getStructureId();
    }

    private com.liferay.structured.content.apio.internal.model.JournalArticleWrapper _getJournalArticleWrapper(long journalArticleId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle journalArticle = this._journalArticleService.getArticle(journalArticleId);
        return new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper(journalArticle, themeDisplay);
    }

    private String _getLocalizedString(DDMFormFieldValue ddmFormFieldValue, Locale locale) {
        return (String)Try.fromFallible(() -> ((DDMFormFieldValue)ddmFormFieldValue).getValue()).map(value -> value.getString(locale)).filter(valueString -> !this._isJSONObject((String)valueString)).orElse(null);
    }

    private PageItems<com.liferay.structured.content.apio.internal.model.JournalArticleWrapper> _getPageItems(Pagination pagination, long contentSpaceId, ThemeDisplay themeDisplay) {
        List journalArticleWrappers = Stream.of(this._journalArticleService.getArticles(contentSpaceId, 0L, pagination.getStartPosition(), pagination.getEndPosition(), null)).flatMap(Collection::stream).map(journalArticle -> new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper((JournalArticle)journalArticle, themeDisplay)).collect(Collectors.toList());
        int count = this._journalArticleService.getArticlesCount(contentSpaceId, 0L);
        return new PageItems(journalArticleWrappers, count);
    }

    private String _getRenderedContent(com.liferay.structured.content.apio.internal.model.JournalArticleWrapper journalArticleWrapper, DDMTemplate ddmTemplate, Locale locale) {
        return (String)Try.fromFallible(() -> this._journalContent.getDisplay(journalArticleWrapper.getGroupId(), journalArticleWrapper.getArticleId(), ddmTemplate.getTemplateKey(), null, locale.getLanguage(), journalArticleWrapper.getThemeDisplay())).map(JournalArticleDisplay::getContent).map(content -> content.replaceAll("[\\t\\n]", "")).orElse(null);
    }

    private List<RenderedJournalArticle> _getRenderedJournalArticles(com.liferay.structured.content.apio.internal.model.JournalArticleWrapper journalArticleWrapper) {
        DDMStructure ddmStructure = journalArticleWrapper.getDDMStructure();
        return Stream.of(ddmStructure.getTemplates()).flatMap(Collection::stream).map(ddmTemplate -> RenderedJournalArticle.create((Function<Locale, String>)((Function)arg_0 -> ((DDMTemplate)ddmTemplate).getName(arg_0)), (Function<Locale, String>)((Function)locale -> this._getRenderedContent(journalArticleWrapper, (DDMTemplate)ddmTemplate, (Locale)locale)))).collect(Collectors.toList());
    }

    private boolean _isJSONObject(String json) {
        try {
            return json.startsWith("{") && JSONFactoryUtil.createJSONObject((String)json) != null;
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
            }
            return false;
        }
    }

    private com.liferay.structured.content.apio.internal.model.JournalArticleWrapper _updateJournalArticle(long journalArticleId, StructuredContentUpdaterForm structuredContentUpdaterForm, ThemeDisplay themeDisplay) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(structuredContentUpdaterForm.getGroup());
        JournalArticle journalArticle = this._journalArticleService.updateArticle(structuredContentUpdaterForm.getUser(), structuredContentUpdaterForm.getGroup(), 0L, String.valueOf(journalArticleId), (double)structuredContentUpdaterForm.getVersion(), structuredContentUpdaterForm.getTitleMap(), structuredContentUpdaterForm.getDescriptionMap(), structuredContentUpdaterForm.getText(), null, serviceContext);
        return new com.liferay.structured.content.apio.internal.model.JournalArticleWrapper(journalArticle, themeDisplay);
    }
}

