/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.model;

import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.DateEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.structured.content.apio.internal.architect.filter.StructuredContentEntityModel;
import com.liferay.structured.content.apio.internal.architect.resource.StructuredContentNestedCollectionResource;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DDMStructureModelListener
extends BaseModelListener<DDMStructure> {
    private static final Log _log = LogFactoryUtil.getLog(DDMStructureModelListener.class);
    private BundleContext _bundleContext;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    private Map<Long, List<EntityField>> _entityFieldsMap = new HashMap<Long, List<EntityField>>();
    private ServiceRegistration<EntityModel> _serviceRegistration;

    @Activate
    public void activate(BundleContext bundleContext) {
        try {
            this._bundleContext = bundleContext;
            this._entityFieldsMap = this._getEntityFieldsMap();
            this._serviceRegistration = this._register(this._bundleContext, this._entityFieldsMap);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
    }

    @Deactivate
    public void deactivate() {
        this._unregister(this._serviceRegistration);
    }

    public void onAfterCreate(DDMStructure ddmStructure) throws ModelListenerException {
        long classNameId = this._classNameLocalService.getClassNameId(JournalArticle.class.getName());
        if (ddmStructure.getClassNameId() != classNameId) {
            return;
        }
        try {
            Map.Entry<Long, List<EntityField>> simpleEntry = this._getEntry(ddmStructure);
            this._entityFieldsMap.put(simpleEntry.getKey(), simpleEntry.getValue());
            this._serviceRegistration = this._updateRegistry(this._bundleContext, this._serviceRegistration, this._entityFieldsMap);
        }
        catch (PortalException pe) {
            throw new ModelListenerException((Throwable)pe);
        }
    }

    public void onAfterRemove(DDMStructure ddmStructure) throws ModelListenerException {
        if (ddmStructure == null) {
            return;
        }
        long classNameId = this._classNameLocalService.getClassNameId(JournalArticle.class.getName());
        if (ddmStructure.getClassNameId() != classNameId) {
            return;
        }
        this._entityFieldsMap.remove(ddmStructure.getStructureId());
        this._serviceRegistration = this._updateRegistry(this._bundleContext, this._serviceRegistration, this._entityFieldsMap);
    }

    public void onAfterUpdate(DDMStructure ddmStructure) throws ModelListenerException {
        this.onAfterCreate(ddmStructure);
    }

    protected String encodeName(long ddmStructureId, String fieldName, Locale locale, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{this._ddmIndexer.encodeName(ddmStructureId, fieldName, locale), "_", type}));
    }

    private Optional<EntityField> _createEntityField(DDMStructure ddmStructure, DDMFormField ddmFormField) throws PortalException {
        String indexType = ddmStructure.getFieldProperty(ddmFormField.getName(), "indexType");
        if (Validator.isNull((String)indexType)) {
            return Optional.empty();
        }
        if (Objects.equals(ddmFormField.getType(), "checkbox")) {
            return Optional.of(new BooleanEntityField(StructuredContentNestedCollectionResource.encodeFilterAndSortIdentifier(ddmStructure, ddmFormField.getName()), locale -> this.encodeName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String")));
        }
        if (Objects.equals(ddmFormField.getDataType(), "date")) {
            return Optional.of(new DateEntityField(StructuredContentNestedCollectionResource.encodeFilterAndSortIdentifier(ddmStructure, ddmFormField.getName()), locale -> this.encodeName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String"), locale -> this.encodeName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String"), this::_getDDMDateFieldValue));
        }
        if (Objects.equals(ddmFormField.getDataType(), "double") || Objects.equals(ddmFormField.getDataType(), "number")) {
            return Optional.of(new DoubleEntityField(StructuredContentNestedCollectionResource.encodeFilterAndSortIdentifier(ddmStructure, ddmFormField.getName()), locale -> this.encodeName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "Number")));
        }
        if (Objects.equals(ddmFormField.getDataType(), "long") || Objects.equals(ddmFormField.getDataType(), "integer")) {
            return Optional.of(new IntegerEntityField(StructuredContentNestedCollectionResource.encodeFilterAndSortIdentifier(ddmStructure, ddmFormField.getName()), locale -> this.encodeName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "Number")));
        }
        if (Objects.equals(ddmFormField.getDataType(), "radio") || Objects.equals(ddmFormField.getType(), "text") && Objects.equals(ddmFormField.getIndexType(), "keyword")) {
            return Optional.of(new StringEntityField(StructuredContentNestedCollectionResource.encodeFilterAndSortIdentifier(ddmStructure, ddmFormField.getName()), locale -> this.encodeName(ddmStructure.getStructureId(), ddmFormField.getName(), (Locale)locale, "String")));
        }
        return Optional.empty();
    }

    private String _getDDMDateFieldValue(Object fieldValue) {
        DateFormat indexDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
        try {
            Date date = indexDateFormat.parse(String.valueOf(fieldValue));
            DateFormat searchDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd");
            return searchDateFormat.format(date);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    private Map<Long, List<EntityField>> _getEntityFieldsMap() throws PortalException {
        HashMap<Long, List<EntityField>> entityFieldsMap = new HashMap<Long, List<EntityField>>();
        ActionableDynamicQuery actionableDynamicQuery = this._ddmStructureLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            long classNameId = this._classNameLocalService.getClassNameId(JournalArticle.class.getName());
            dynamicQuery.add(classNameIdProperty.eq((Object)classNameId));
        });
        actionableDynamicQuery.setPerformActionMethod(ddmStructure -> {
            Map.Entry<Long, List<EntityField>> simpleEntry = this._getEntry((DDMStructure)ddmStructure);
            entityFieldsMap.put(simpleEntry.getKey(), simpleEntry.getValue());
        });
        actionableDynamicQuery.performActions();
        return entityFieldsMap;
    }

    private Map.Entry<Long, List<EntityField>> _getEntry(DDMStructure ddmStructure) throws PortalException {
        ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
        List ddmFormFields = ddmStructure.getDDMFormFields(false);
        for (DDMFormField ddmFormField : ddmFormFields) {
            Optional<EntityField> entityFieldOptional = this._createEntityField(ddmStructure, ddmFormField);
            if (!entityFieldOptional.isPresent()) continue;
            entityFields.add(entityFieldOptional.get());
        }
        return new AbstractMap.SimpleEntry<Long, List<EntityField>>(ddmStructure.getStructureId(), entityFields);
    }

    private ServiceRegistration<EntityModel> _register(BundleContext bundleContext, Map<Long, List<EntityField>> entityFieldsMap) {
        Collection<List<EntityField>> collection = entityFieldsMap.values();
        Stream<List<EntityField>> stream = collection.stream();
        List<EntityField> entityFields = stream.flatMap(Collection::stream).collect(Collectors.toList());
        return bundleContext.registerService(EntityModel.class, (Object)new StructuredContentEntityModel(entityFields), (Dictionary)new HashMapDictionary<String, Object>(){
            {
                this.put("entity.model.name", "StructuredContent");
            }
        });
    }

    private void _unregister(ServiceRegistration<EntityModel> serviceRegistration) {
        serviceRegistration.unregister();
    }

    private ServiceRegistration<EntityModel> _updateRegistry(BundleContext bundleContext, ServiceRegistration<EntityModel> serviceRegistration, Map<Long, List<EntityField>> entityFieldsMap) {
        this._unregister(serviceRegistration);
        return this._register(bundleContext, entityFieldsMap);
    }
}

