/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.architect.provider;

import com.liferay.apio.architect.provider.Provider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.sort.Sort;
import com.liferay.portal.odata.sort.SortParser;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Provider.class})
public class SortProvider
implements Provider<Sort> {
    private static final Log _log = LogFactoryUtil.getLog(SortProvider.class);
    private SortParser _sortParser;

    public Sort createContext(HttpServletRequest httpServletRequest) {
        String sortString = httpServletRequest.getParameter("sort");
        if (Validator.isNull((String)sortString)) {
            return Sort.emptySort();
        }
        return new Sort(this._sortParser.parse(sortString));
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=StructuredContent)", unbind="unbind")
    public void setSortParser(SortParser sortParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + sortParser));
        }
        this._sortParser = sortParser;
    }

    public void unbind(SortParser sortParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + sortParser));
        }
        this._sortParser = null;
    }
}

