/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.architect.provider;

import com.liferay.apio.architect.provider.Provider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.InvalidFilterException;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={Provider.class})
public class FilterProvider
implements Provider<Filter> {
    private static final Log _log = LogFactoryUtil.getLog(FilterProvider.class);
    private FilterParser _filterParser;

    public Filter createContext(HttpServletRequest httpServletRequest) {
        String filterString = httpServletRequest.getParameter("filter");
        if (Validator.isNull((String)filterString)) {
            return Filter.emptyFilter();
        }
        try {
            return new Filter(this._filterParser.parse(filterString));
        }
        catch (Exception e) {
            throw new InvalidFilterException(String.format("Invalid query computed from filter '%s': %s", filterString, e.getMessage()), (Throwable)e);
        }
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(entity.model.name=StructuredContent)", unbind="unbind")
    public void setFilterParser(FilterParser filterParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Binding " + filterParser));
        }
        this._filterParser = filterParser;
    }

    public void unbind(FilterParser filterParser) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unbinding " + filterParser));
        }
        this._filterParser = null;
    }
}

