/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.architect.form;

import com.liferay.apio.architect.form.Form;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentValuesForm;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class StructuredContentUpdaterForm {
    private List<Long> _categories;
    private String _description;
    private List<String> _keywords;
    private Integer _publishedDateDay;
    private Integer _publishedDateHour;
    private Integer _publishedDateMinute;
    private Integer _publishedDateMonth;
    private Integer _publishedDateYear;
    private List<StructuredContentValuesForm> _structuredContentValuesForms = new ArrayList<StructuredContentValuesForm>();
    private String _title;

    public static Form<StructuredContentUpdaterForm> buildForm(Form.Builder<StructuredContentUpdaterForm> formBuilder) {
        return formBuilder.title(__ -> "The structured content updater form").description(__ -> "This form can be used to update a structured content").constructor(StructuredContentUpdaterForm::new).addOptionalDate("datePublished", StructuredContentUpdaterForm::setPublishedDate).addOptionalLinkedModelList("category", CategoryIdentifier.class, StructuredContentUpdaterForm::setCategories).addOptionalNestedModelList("values", StructuredContentValuesForm::buildForm, StructuredContentUpdaterForm::setStructuredContentValuesForms).addOptionalString("description", StructuredContentUpdaterForm::setDescription).addOptionalString("title", StructuredContentUpdaterForm::setTitle).addOptionalStringList("keywords", StructuredContentUpdaterForm::setKeywords).build();
    }

    public List<Long> getCategories() {
        return this._categories;
    }

    public Optional<Map<Locale, String>> getDescriptionMapOptional() {
        return this._getStringMapOptional(Locale.getDefault(), this._description);
    }

    public Optional<Map<Locale, String>> getDescriptionMapOptional(Locale locale) {
        return this._getStringMapOptional(locale, this._description);
    }

    public List<String> getKeywords() {
        return this._keywords;
    }

    public Optional<Integer> getPublishedDateDayOptional() {
        return Optional.ofNullable(this._publishedDateDay);
    }

    public Optional<Integer> getPublishedDateHourOptional() {
        return Optional.ofNullable(this._publishedDateHour);
    }

    public Optional<Integer> getPublishedDateMinuteOptional() {
        return Optional.ofNullable(this._publishedDateMinute);
    }

    public Optional<Integer> getPublishedDateMonthOptional() {
        return Optional.ofNullable(this._publishedDateMonth);
    }

    public Optional<Integer> getPublishedDateYearOptional() {
        return Optional.ofNullable(this._publishedDateYear);
    }

    public ServiceContext getServiceContext(long groupId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        if (ListUtil.isNotEmpty(this._keywords)) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray(this._keywords));
        }
        if (ListUtil.isNotEmpty(this._categories)) {
            serviceContext.setAssetCategoryIds(ArrayUtil.toLongArray(this._categories));
        }
        serviceContext.setScopeGroupId(groupId);
        return serviceContext;
    }

    public List<StructuredContentValuesForm> getStructuredContentValuesForms() {
        return this._structuredContentValuesForms;
    }

    public Optional<Map<Locale, String>> getTitleMapOptional() {
        return this._getStringMapOptional(Locale.getDefault(), this._title);
    }

    public Optional<Map<Locale, String>> getTitleMapOptional(Locale locale) {
        return this._getStringMapOptional(locale, this._title);
    }

    public void setCategories(List<Long> categories) {
        this._categories = categories;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setKeywords(List<String> keywords) {
        this._keywords = keywords;
    }

    public void setPublishedDate(Date publishedDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(publishedDate);
        this._publishedDateDay = calendar.get(5);
        this._publishedDateHour = calendar.get(10);
        this._publishedDateMinute = calendar.get(12);
        this._publishedDateMonth = calendar.get(2);
        this._publishedDateYear = calendar.get(1);
    }

    public void setStructuredContentValuesForms(List<StructuredContentValuesForm> structuredContentValuesForms) {
        this._structuredContentValuesForms = structuredContentValuesForms;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    private Optional<Map<Locale, String>> _getStringMapOptional(Locale locale, String value) {
        return Optional.ofNullable(value).map(description -> {
            HashMap<Locale, String> map = new HashMap<Locale, String>();
            map.put(locale, value);
            return map;
        });
    }
}

