/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structured.content.apio.internal.architect.form;

import com.liferay.apio.architect.form.Form;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.structure.apio.architect.identifier.ContentStructureIdentifier;
import com.liferay.structured.content.apio.internal.architect.form.StructuredContentValuesForm;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class StructuredContentCreatorForm {
    private List<Long> _categories;
    private Long _contentStructureId;
    private String _description;
    private List<String> _keywords;
    private Integer _publishedDateDay;
    private Integer _publishedDateHour;
    private Integer _publishedDateMinute;
    private Integer _publishedDateMonth;
    private Integer _publishedDateYear;
    private List<StructuredContentValuesForm> _structuredContentValuesForms = new ArrayList<StructuredContentValuesForm>();
    private String _title;

    public static Form<StructuredContentCreatorForm> buildForm(Form.Builder<StructuredContentCreatorForm> formBuilder) {
        return formBuilder.title(__ -> "The structured content creator form").description(__ -> "This form can be used to create a structured content").constructor(StructuredContentCreatorForm::new).addOptionalDate("datePublished", StructuredContentCreatorForm::setPublishedDate).addOptionalLinkedModelList("category", CategoryIdentifier.class, StructuredContentCreatorForm::setCategories).addOptionalNestedModelList("values", StructuredContentValuesForm::buildForm, StructuredContentCreatorForm::setStructuredContentValuesForms).addOptionalString("description", StructuredContentCreatorForm::setDescription).addOptionalStringList("keywords", StructuredContentCreatorForm::setKeywords).addRequiredLinkedModel("contentStructure", ContentStructureIdentifier.class, StructuredContentCreatorForm::setContentStructureId).addRequiredString("title", StructuredContentCreatorForm::setTitle).build();
    }

    public List<Long> getCategories() {
        return this._categories;
    }

    public Long getContentStructureId() {
        return this._contentStructureId;
    }

    public Map<Locale, String> getDescriptionMap(Locale locale) {
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, this._description);
        return descriptionMap;
    }

    public Optional<Integer> getPublishedDateDayOptional() {
        return Optional.ofNullable(this._publishedDateDay);
    }

    public Optional<Integer> getPublishedDateHourOptional() {
        return Optional.ofNullable(this._publishedDateHour);
    }

    public Optional<Integer> getPublishedDateMinuteOptional() {
        return Optional.ofNullable(this._publishedDateMinute);
    }

    public Optional<Integer> getPublishedDateMonthOptional() {
        return Optional.ofNullable(this._publishedDateMonth);
    }

    public Optional<Integer> getPublishedDateYearOptional() {
        return Optional.ofNullable(this._publishedDateYear);
    }

    public ServiceContext getServiceContext(long groupId) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        if (ListUtil.isNotEmpty(this._keywords)) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray(this._keywords));
        }
        if (ListUtil.isNotEmpty(this._categories)) {
            serviceContext.setAssetCategoryIds(ArrayUtil.toLongArray(this._categories));
        }
        serviceContext.setScopeGroupId(groupId);
        return serviceContext;
    }

    public List<StructuredContentValuesForm> getStructuredContentValuesForms() {
        return this._structuredContentValuesForms;
    }

    public Map<Locale, String> getTitleMap(Locale locale) {
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, this._title);
        return titleMap;
    }

    public void setCategories(List<Long> categories) {
        this._categories = categories;
    }

    public void setContentStructureId(Long contentStructureId) {
        this._contentStructureId = contentStructureId;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setKeywords(List<String> keywords) {
        this._keywords = keywords;
    }

    public void setPublishedDate(Date publishedDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(publishedDate);
        this._publishedDateDay = calendar.get(5);
        this._publishedDateHour = calendar.get(10);
        this._publishedDateMinute = calendar.get(12);
        this._publishedDateMonth = calendar.get(2);
        this._publishedDateYear = calendar.get(1);
    }

    public void setStructuredContentValuesForms(List<StructuredContentValuesForm> structuredContentValuesForms) {
        this._structuredContentValuesForms = structuredContentValuesForms;
    }

    public void setTitle(String title) {
        this._title = title;
    }
}

