/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structure.apio.internal.util;

import com.liferay.apio.architect.functional.Try;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.DDMFormSuccessPageSettings;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.structure.apio.internal.model.FormLayoutPage;
import com.liferay.structure.apio.internal.util.LocalizedValueUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StructureRepresentorUtil {
    public static Function<DDMFormField, List<Map.Entry<String, LocalizedValue>>> getFieldOptions(Function<DDMFormField, DDMFormFieldOptions> function) {
        return ddmFormField -> (ArrayList)Try.fromFallible(() -> (DDMFormFieldOptions)function.apply((DDMFormField)ddmFormField)).map(DDMFormFieldOptions::getOptions).map(Map::entrySet).map(ArrayList::new).orElse(null);
    }

    public static Function<DDMFormField, List<Map.Entry<String, LocalizedValue>>> getFieldOptions(String key) {
        return StructureRepresentorUtil.getFieldOptions((DDMFormField ddmFormField) -> (DDMFormFieldOptions)ddmFormField.getProperty(key));
    }

    public static <T> Function<DDMFormField, T> getFieldProperty(Function<Object, T> parseFunction, String key) {
        return ddmFormField -> Try.fromFallible(() -> ddmFormField.getProperty(key)).map(parseFunction::apply).orElse(null);
    }

    public static BiFunction<DDMFormField, Locale, String> getLocalizedString(String key) {
        return LocalizedValueUtil.getLocalizedString((T ddmFormField) -> (LocalizedValue)ddmFormField.getProperty(key));
    }

    public static List<FormLayoutPage> getPages(DDMStructure ddmStructure) {
        return ((Stream)Try.fromFallible(() -> ((DDMStructure)ddmStructure).getDDMFormLayout()).map(DDMFormLayout::getDDMFormLayoutPages).map(Collection::stream).orElseGet(Stream::empty)).map(StructureRepresentorUtil._getFormLayoutPage(ddmStructure)).collect(Collectors.toList());
    }

    public static DDMFormSuccessPageSettings getSuccessPage(DDMStructure ddmStructure) {
        DDMForm ddmForm = ddmStructure.getDDMForm();
        return ddmForm.getDDMFormSuccessPageSettings();
    }

    public static DDMStructureVersion getVersion(DDMStructure ddmStructure) {
        return (DDMStructureVersion)Try.fromFallible(() -> ((DDMStructure)ddmStructure).getStructureVersion()).orElse(null);
    }

    public static Function<DDMFormField, Boolean> hasFormRules() {
        return ddmFormField -> ((Stream)Try.fromFallible(() -> ((DDMFormField)ddmFormField).getDDMForm()).map(DDMForm::getDDMFormRules).map(Collection::stream).orElseGet(Stream::empty)).map(DDMFormRule::getCondition).anyMatch(ruleCondition -> ruleCondition.contains(ddmFormField.getName()));
    }

    private static List<String> _getFieldNames(DDMFormLayoutPage ddmFormLayoutPage, DDMStructure ddmStructure) {
        return Optional.ofNullable(ddmFormLayoutPage.getDDMFormLayoutRows()).map(Collection::stream).orElseGet(Stream::empty).map(DDMFormLayoutRow::getDDMFormLayoutColumns).flatMap(Collection::stream).map(DDMFormLayoutColumn::getDDMFormFieldNames).map(formFieldNames -> StructureRepresentorUtil._getNestedFieldNames(formFieldNames, ddmStructure)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Function<List<String>, List<DDMFormField>> _getFieldsPerPage(DDMStructure ddmStructure) {
        return fieldNamesPerPage -> ((Stream)Try.fromFallible(() -> ddmStructure.getDDMFormFields(true)).map(Collection::stream).orElseGet(Stream::empty)).filter(ddmFormField -> fieldNamesPerPage.contains(ddmFormField.getName())).collect(Collectors.toList());
    }

    private static Function<DDMFormLayoutPage, FormLayoutPage> _getFormLayoutPage(DDMStructure ddmStructure) {
        return ddmFormLayoutPage -> Optional.ofNullable(StructureRepresentorUtil._getFieldNames(ddmFormLayoutPage, ddmStructure)).map(StructureRepresentorUtil._getFieldsPerPage(ddmStructure)).map(ddmFormFields -> new FormLayoutPage((DDMFormLayoutPage)ddmFormLayoutPage, (List<DDMFormField>)ddmFormFields)).orElse(null);
    }

    private static List<String> _getNestedFieldNames(List<String> ddmFormFieldNames, DDMStructure ddmStructure) {
        List ddmFormFields = ddmStructure.getDDMFormFields(false);
        Stream ddmFormFieldStream = ddmFormFields.stream();
        return ddmFormFieldStream.filter(formField -> ddmFormFieldNames.contains(formField.getName())).map(formField -> formField.getNestedDDMFormFields().stream().map(DDMFormField::getName).collect(Collectors.toList())).map(fieldNames -> StructureRepresentorUtil._getNestedFieldNames(fieldNames, ddmStructure)).peek(fieldNames -> fieldNames.addAll(ddmFormFieldNames)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

