/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.structure.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.NestedRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.content.space.apio.architect.identifier.ContentSpaceIdentifier;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureModel;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameService;
import com.liferay.structure.apio.architect.identifier.ContentStructureIdentifier;
import com.liferay.structure.apio.architect.model.FormLayoutPage;
import com.liferay.structure.apio.architect.util.StructureRepresentorBuilderHelper;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NestedCollectionResource.class})
public class ContentStructureNestedCollectionResource
implements NestedCollectionResource<DDMStructure, Long, ContentStructureIdentifier, Long, ContentSpaceIdentifier> {
    @Reference
    private ClassNameService _classNameService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private StructureRepresentorBuilderHelper _structureRepresentorBuilderHelper;

    public NestedCollectionRoutes<DDMStructure, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<DDMStructure, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).build();
    }

    public String getName() {
        return "content-structures";
    }

    public ItemRoutes<DDMStructure, Long> itemRoutes(ItemRoutes.Builder<DDMStructure, Long> builder) {
        return builder.addGetter(this::_getItem).build();
    }

    public Representor<DDMStructure> representor(Representor.Builder<DDMStructure, Long> builder) {
        Representor.FirstStep ddmStructureFirstStep = this._structureRepresentorBuilderHelper.buildDDMStructureFirstStep(builder);
        ddmStructureFirstStep.addNestedList("formPages", arg_0 -> ((StructureRepresentorBuilderHelper)this._structureRepresentorBuilderHelper).getFormLayoutPages(arg_0), nestedBuilder -> (NestedRepresentor)this._buildFormLayoutPage((NestedRepresentor.Builder<FormLayoutPage>)nestedBuilder).build());
        Representor.FirstStep bidirectionalModelStep = ddmStructureFirstStep.addBidirectionalModel("contentSpace", "contentStructures", ContentSpaceIdentifier.class, DDMStructureModel::getGroupId);
        return (Representor)bidirectionalModelStep.build();
    }

    private NestedRepresentor.FirstStep<DDMFormField> _buildDDMFormFields(NestedRepresentor.Builder<DDMFormField> ddmFormFieldBuilder) {
        return this._structureRepresentorBuilderHelper.buildDDMFormFieldFirstStep(ddmFormFieldBuilder);
    }

    private NestedRepresentor.FirstStep<FormLayoutPage> _buildFormLayoutPage(NestedRepresentor.Builder<FormLayoutPage> builder) {
        NestedRepresentor.FirstStep formLayoutPageFirstStep = this._structureRepresentorBuilderHelper.buildFormLayoutPageFirstStep(builder);
        formLayoutPageFirstStep.addNestedList("fields", FormLayoutPage::getFields, ddmFormFieldBuilder -> (NestedRepresentor)this._buildDDMFormFields((NestedRepresentor.Builder<DDMFormField>)ddmFormFieldBuilder).build());
        return formLayoutPageFirstStep;
    }

    private DDMStructure _getItem(Long structureId) throws PortalException {
        return this._ddmStructureLocalService.getStructure(structureId.longValue());
    }

    private PageItems<DDMStructure> _getPageItems(Pagination pagination, Long groupId) {
        ClassName className = this._classNameService.fetchClassName(JournalArticle.class.getName());
        Long classNameId = className.getClassNameId();
        List ddmStructures = this._ddmStructureLocalService.getStructures(groupId.longValue(), classNameId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._ddmStructureLocalService.getStructuresCount(groupId.longValue(), classNameId.longValue());
        return new PageItems((Collection)ddmStructures, count);
    }
}

