/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLiferayPluginPackageFileCheck
extends BaseFileCheck {
    private static final Pattern _licensesPattern = Pattern.compile("\nlicenses=(\\w+)\n");
    private static final Pattern _singleValueOnMultipleLinesPattern = Pattern.compile("\n.*=(\\\\\n *).*(\n[^ ]|\\Z)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/liferay-plugin-package.properties")) {
            return this._formatPluginPackageProperties(absolutePath, content);
        }
        return content;
    }

    private String _fixIncorrectLicenses(String absolutePath, String content) {
        if (!this.isModulesApp(absolutePath, false)) {
            return content;
        }
        Matcher matcher = _licensesPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String licenses = matcher.group(1);
        String expectedLicenses = "LGPL";
        if (this.isModulesApp(absolutePath, true)) {
            expectedLicenses = "DXP";
        }
        if (licenses.equals(expectedLicenses)) {
            return content;
        }
        return StringUtil.replace(content, "licenses=" + licenses, "licenses=" + expectedLicenses, matcher.start());
    }

    private String _formatPluginPackageProperties(String absolutePath, String content) {
        content = StringUtil.replace(content, "\n\n", "\n");
        Matcher matcher = _singleValueOnMultipleLinesPattern.matcher(content = StringUtil.replace(content, '\t', "    "));
        if (matcher.find()) {
            content = StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
        }
        return this._fixIncorrectLicenses(absolutePath, content);
    }
}

