/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import antlr.CommonHiddenStreamToken;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.tools.java.parser.JavaClassCall;
import com.liferay.portal.tools.java.parser.JavaClosingBrace;
import com.liferay.portal.tools.java.parser.JavaEnumConstantDefinition;
import com.liferay.portal.tools.java.parser.JavaLambdaExpression;
import com.liferay.portal.tools.java.parser.JavaTerm;
import com.liferay.portal.tools.java.parser.JavaTryStatement;
import com.liferay.portal.tools.java.parser.ParsedJavaClass;
import com.liferay.portal.tools.java.parser.ParsedJavaTerm;
import com.liferay.portal.tools.java.parser.Position;
import com.liferay.portal.tools.java.parser.util.DetailASTUtil;
import com.liferay.portal.tools.java.parser.util.FileUtil;
import com.liferay.portal.tools.java.parser.util.JavaParserUtil;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JavaParser {
    private static int _maxLineLength;

    public static String parse(File file, int maxLineLength) throws CheckstyleException, IOException {
        return JavaParser.parse(file, maxLineLength, true);
    }

    public static String parse(File file, int maxLineLength, boolean writeFile) throws CheckstyleException, IOException {
        return JavaParser.parse(file, FileUtil.read(file), maxLineLength, writeFile);
    }

    public static String parse(File file, String content, int maxLineLength) throws CheckstyleException, IOException {
        return JavaParser.parse(file, content, maxLineLength, true);
    }

    public static String parse(File file, String content, int maxLineLength, boolean writeFile) throws CheckstyleException, IOException {
        _maxLineLength = maxLineLength;
        String newContent = JavaParser._parse(file, content);
        if (writeFile && !newContent.equals(content)) {
            FileUtil.write(file, newContent);
        }
        return newContent;
    }

    private static ParsedJavaClass _addClosingJavaTerm(ParsedJavaClass parsedJavaClass, DetailAST closingDetailAST, FileContents fileContents, String className) {
        DetailAST rcurlyDetailAST = null;
        if (closingDetailAST.getType() == 72) {
            DetailAST parentDetailAST = closingDetailAST.getParent();
            rcurlyDetailAST = parentDetailAST.getLastChild();
        } else if (closingDetailAST.getType() == 7) {
            rcurlyDetailAST = closingDetailAST.getLastChild();
        }
        if (rcurlyDetailAST != null) {
            JavaClosingBrace javaClosingBrace = new JavaClosingBrace();
            String curlyExpecedIndent = JavaParser._getExpectedIndent(rcurlyDetailAST, fileContents);
            String content = javaClosingBrace.toString(curlyExpecedIndent, "", _maxLineLength);
            parsedJavaClass.addJavaTerm(content, DetailASTUtil.getStartPosition(rcurlyDetailAST), DetailASTUtil.getEndPosition(rcurlyDetailAST, fileContents), className);
        }
        return parsedJavaClass;
    }

    private static ContentModifications _addCommentContentModifications(ContentModifications contentModifications, ParsedJavaTerm parsedJavaTerm, String indent, FileContents fileContents) {
        CommonHiddenStreamToken precedingCommentToken = parsedJavaTerm.getPrecedingCommentToken();
        if (precedingCommentToken == null) {
            return contentModifications;
        }
        String expectedCommentIndent = indent;
        String trimmedJavaTermContent = StringUtil.trim(parsedJavaTerm.getContent());
        if (trimmedJavaTermContent.startsWith("}") || trimmedJavaTermContent.startsWith(")")) {
            expectedCommentIndent = expectedCommentIndent + "\t";
        }
        while (precedingCommentToken != null) {
            String line = fileContents.getLine(precedingCommentToken.getLine() - 1);
            if (!JavaParser._isAtLineStart(line, precedingCommentToken.getColumn() - 1)) {
                return contentModifications;
            }
            String actualCommentIndent = JavaParser._getIndent(line);
            if (!actualCommentIndent.equals(expectedCommentIndent)) {
                contentModifications.addReplaceContent(expectedCommentIndent + StringUtil.trim(line), precedingCommentToken.getLine());
            }
            if (precedingCommentToken.getType() == 144) {
                precedingCommentToken = precedingCommentToken.getHiddenBefore();
                continue;
            }
            String text = precedingCommentToken.getText();
            boolean javadoc = false;
            if (StringUtil.startsWith(StringUtil.trim(text), '*')) {
                javadoc = true;
            } else if (actualCommentIndent.equals(expectedCommentIndent)) {
                precedingCommentToken = precedingCommentToken.getHiddenBefore();
                continue;
            }
            int end = precedingCommentToken.getLine() + StringUtil.count(text, "\n");
            for (int i = precedingCommentToken.getLine() + 1; i <= end; ++i) {
                line = fileContents.getLine(i - 1);
                if (Validator.isNull(line)) {
                    contentModifications.addRemoveLineLineNumber(i);
                }
                if (javadoc) {
                    String actualIndent = JavaParser._getIndent(line);
                    if (actualIndent.equals(expectedCommentIndent + " ")) continue;
                    contentModifications.addReplaceContent(expectedCommentIndent + " " + StringUtil.trim(line), i);
                    continue;
                }
                if (!line.startsWith(actualCommentIndent)) continue;
                contentModifications.addReplaceContent(StringUtil.replaceFirst(line, actualCommentIndent, expectedCommentIndent), i);
            }
            precedingCommentToken = precedingCommentToken.getHiddenBefore();
        }
        return contentModifications;
    }

    private static ContentModifications _addContentModifications(ContentModifications contentModifications, ParsedJavaTerm parsedJavaTerm, FileContents fileContents) {
        int precedingLineAction;
        if (parsedJavaTerm.getContent() == null) {
            return contentModifications;
        }
        Position endPosition = parsedJavaTerm.getEndPosition();
        int endLineNumber = endPosition.getLineNumber();
        String endLine = fileContents.getLine(endLineNumber - 1);
        if (!JavaParser._isAtLineEnd(endLine, endPosition.getLinePosition())) {
            return contentModifications;
        }
        int followingLineAction = parsedJavaTerm.getFollowingLineAction();
        if (followingLineAction != 1) {
            String trimmedFollowingLine = StringUtil.trim(fileContents.getLine(endLineNumber));
            if (followingLineAction == 0 && Validator.isNotNull(trimmedFollowingLine)) {
                contentModifications.addInsertLineBreakLineNumber(endLineNumber + 1);
            } else if (followingLineAction == 2 && Validator.isNull(trimmedFollowingLine)) {
                contentModifications.addRemoveLineLineNumber(endLineNumber + 1);
            }
        }
        String expectedJavaTermContent = parsedJavaTerm.getContent();
        Position startPosition = parsedJavaTerm.getStartPosition();
        int startLineNumber = startPosition.getLineNumber();
        String actualJavaTermContent = JavaParser._getContent(fileContents, startLineNumber, endLineNumber);
        if (!(actualJavaTermContent.startsWith(expectedJavaTermContent) || JavaParser._isExcludedJavaTerm(parsedJavaTerm) || actualJavaTermContent.contains("\n\n") && Objects.equals(parsedJavaTerm.getClassName(), JavaTryStatement.class.getName()))) {
            contentModifications.addReplaceContent(parsedJavaTerm.getContent(), startPosition.getLineNumber(), endPosition.getLineNumber());
        }
        if ((precedingLineAction = parsedJavaTerm.getPrecedingLineAction()) != 1) {
            String trimmedPrecedingLine = StringUtil.trim(fileContents.getLine(startLineNumber - 2));
            if (precedingLineAction == 0 && Validator.isNotNull(trimmedPrecedingLine)) {
                contentModifications.addInsertLineBreakLineNumber(startLineNumber);
            } else if (precedingLineAction == 2 && Validator.isNull(trimmedPrecedingLine)) {
                contentModifications.addRemoveLineLineNumber(startLineNumber - 1);
            }
        }
        return JavaParser._addCommentContentModifications(contentModifications, parsedJavaTerm, JavaParser._getIndent(expectedJavaTermContent), fileContents);
    }

    private static ParsedJavaClass _addJavaTerm(ParsedJavaClass parsedJavaClass, DetailAST detailAST, JavaTerm javaTerm, FileContents fileContents) throws IOException {
        if (javaTerm == null) {
            return parsedJavaClass;
        }
        Class<?> clazz = javaTerm.getClass();
        String className = clazz.getName();
        DetailAST closingDetailAST = DetailASTUtil.getClosingDetailAST(detailAST);
        if (closingDetailAST != null) {
            parsedJavaClass = JavaParser._addClosingJavaTerm(parsedJavaClass, closingDetailAST, fileContents, className);
        }
        Position startPosition = DetailASTUtil.getStartPosition(detailAST);
        String expectedIndent = JavaParser._getExpectedIndent(detailAST, fileContents);
        String javaTermContent = javaTerm.toString(expectedIndent, "", _maxLineLength);
        if (javaTermContent.contains("\n${JAVA_CLASS_CALL_NESTED_CODE_BLOCK}\n") || javaTermContent.contains("\n${JAVA_ENUM_CONSTANT_DEFINITION_NESTED_CODE_BLOCK}\n") || javaTermContent.contains("\n${JAVA_LAMBDA_EXPRESSION_NESTED_CODE_BLOCK}\n")) {
            return JavaParser._addJavaTermWithNestedCodeBlocks(parsedJavaClass, detailAST, javaTermContent, className, startPosition, fileContents);
        }
        Position endPosition = null;
        endPosition = detailAST.getType() == 155 ? DetailASTUtil.getEndPosition(JavaParser._getLastEnumConstantDefinitionDetailAST(detailAST), fileContents) : DetailASTUtil.getEndPosition(detailAST, fileContents);
        parsedJavaClass.addJavaTerm(javaTermContent, startPosition, endPosition, className);
        return parsedJavaClass;
    }

    private static ParsedJavaClass _addJavaTermWithNestedCodeBlocks(ParsedJavaClass parsedJavaClass, DetailAST detailAST, String javaTermContent, String className, Position startPosition, FileContents fileContents) throws IOException {
        String followingNestedCodeBlockClassName = null;
        String precedingNestedCodeBlockClassName = null;
        List<Position> curlyBracePositionList = JavaParser._getCurlyBracePositionList(new ArrayList<Position>(), detailAST);
        Collections.sort(curlyBracePositionList);
        int count = 0;
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(javaTermContent));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.equals("${JAVA_CLASS_CALL_NESTED_CODE_BLOCK}")) {
                    followingNestedCodeBlockClassName = JavaClassCall.class.getName();
                } else if (line.equals("${JAVA_ENUM_CONSTANT_DEFINITION_NESTED_CODE_BLOCK}")) {
                    followingNestedCodeBlockClassName = JavaEnumConstantDefinition.class.getName();
                } else if (line.equals("${JAVA_LAMBDA_EXPRESSION_NESTED_CODE_BLOCK}")) {
                    followingNestedCodeBlockClassName = JavaLambdaExpression.class.getName();
                } else {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                sb.setIndex(sb.index() - 1);
                Position partStartPosition = null;
                partStartPosition = count == 0 ? startPosition : curlyBracePositionList.get(count * 2 - 1);
                Position partEndPosition = curlyBracePositionList.get(count * 2);
                parsedJavaClass.addJavaTerm(sb.toString(), partStartPosition, partEndPosition, className, precedingNestedCodeBlockClassName, followingNestedCodeBlockClassName);
                sb.setIndex(0);
                precedingNestedCodeBlockClassName = followingNestedCodeBlockClassName;
                ++count;
            }
        }
        sb.setIndex(sb.index() - 1);
        Position partEndPosition = DetailASTUtil.getEndPosition(detailAST, fileContents);
        Position partStartPosition = curlyBracePositionList.get(count * 2 - 1);
        parsedJavaClass.addJavaTerm(sb.toString(), partStartPosition, partEndPosition, className, precedingNestedCodeBlockClassName, null);
        return parsedJavaClass;
    }

    private static String _fixContent(String content, String javaTermContent, Position startPosition, Position endPosition) {
        int x = JavaParser._getLineStartPos(content, startPosition.getLineNumber());
        int y = JavaParser._getLineStartPos(content, endPosition.getLineNumber()) + endPosition.getLinePosition();
        return StringUtil.replaceFirst(content, content.substring(x, y), javaTermContent, x - 1);
    }

    private static String _fixIncorrectStartOrEndPositions(String content, ParsedJavaClass parsedJavaClass, FileContents fileContents) {
        ParsedJavaTerm parsedJavaTerm = parsedJavaClass.getLastParsedJavaTerm();
        while (parsedJavaTerm != null) {
            int endLinePosition;
            if (parsedJavaTerm.containsCommentToken() || parsedJavaTerm.getContent() == null) {
                parsedJavaTerm = parsedJavaTerm.getPreviousParsedJavaTerm();
                continue;
            }
            Position startPosition = parsedJavaTerm.getStartPosition();
            int startLineNumber = startPosition.getLineNumber();
            if (!JavaParser._isAtLineStart(fileContents.getLine(startLineNumber - 1), startPosition.getLinePosition())) {
                int lineStartPos = JavaParser._getLineStartPos(content, startPosition.getLineNumber());
                content = StringUtil.insert(content, "\n", lineStartPos + startPosition.getLinePosition());
                parsedJavaTerm = parsedJavaTerm.getPreviousParsedJavaTerm();
                continue;
            }
            Position endPosition = parsedJavaTerm.getEndPosition();
            int endLineNumber = endPosition.getLineNumber();
            String endLine = fileContents.getLine(endLineNumber - 1);
            if (!JavaParser._isAtLineEnd(endLine, endLinePosition = endPosition.getLinePosition())) {
                String remainder = StringUtil.trim(endLine.substring(endLinePosition));
                if (Validator.isNull(remainder)) {
                    content = JavaParser._trimLine(content, endLine, endLineNumber);
                } else if (remainder.startsWith("//") || remainder.startsWith("/*")) {
                    content = JavaParser._fixContent(content, parsedJavaTerm.getContent(), startPosition, endPosition);
                }
            }
            parsedJavaTerm = parsedJavaTerm.getPreviousParsedJavaTerm();
        }
        return content;
    }

    private static String _getContent(FileContents fileContents, int start, int end) {
        StringBundler sb = new StringBundler();
        for (int i = start; i <= end; ++i) {
            sb.append(fileContents.getLine(i - 1));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static List<Position> _getCurlyBracePositionList(List<Position> curlyBracePositionList, DetailAST detailAST) {
        DetailAST lastChildDetailAST;
        if (detailAST == null) {
            return curlyBracePositionList;
        }
        if (detailAST.getType() == 155 || detailAST.getType() == 136) {
            DetailAST objblockDetailAST = detailAST.findFirstToken(6);
            if (objblockDetailAST != null && objblockDetailAST.getChildCount() > 2) {
                DetailAST leftCurlyDetailAST = objblockDetailAST.getFirstChild();
                curlyBracePositionList.add(new Position(leftCurlyDetailAST.getLineNo(), leftCurlyDetailAST.getColumnNo() + 1));
                DetailAST rightCurlyDetailAST = objblockDetailAST.getLastChild();
                curlyBracePositionList.add(new Position(rightCurlyDetailAST.getLineNo(), rightCurlyDetailAST.getColumnNo()));
            }
        } else if (detailAST.getType() == 181 && (lastChildDetailAST = detailAST.getLastChild()).getType() == 7) {
            curlyBracePositionList.add(new Position(lastChildDetailAST.getLineNo(), lastChildDetailAST.getColumnNo() + 1));
            lastChildDetailAST = lastChildDetailAST.getLastChild();
            curlyBracePositionList.add(new Position(lastChildDetailAST.getLineNo(), lastChildDetailAST.getColumnNo()));
        }
        if (detailAST.getType() != 6 && detailAST.getType() != 7) {
            curlyBracePositionList = JavaParser._getCurlyBracePositionList(curlyBracePositionList, detailAST.getFirstChild());
        }
        return JavaParser._getCurlyBracePositionList(curlyBracePositionList, detailAST.getNextSibling());
    }

    private static String _getExpectedIndent(DetailAST detailAST, FileContents fileContents) {
        String indent = "";
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            DetailAST grandParentDetailAST;
            if (parentDetailAST.getType() == 34 || parentDetailAST.getType() == 89 || parentDetailAST.getType() == 6 || parentDetailAST.getType() == 7) {
                indent = indent + "\t";
            }
            if (parentDetailAST.getType() == 6) {
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) continue;
                String expectedIndent = JavaParser._getExpectedIndent(parentDetailAST, fileContents);
                String actualIndent = JavaParser._getIndent(fileContents.getLine(parentDetailAST.getLineNo() - 1));
                if (!actualIndent.startsWith(expectedIndent)) continue;
                indent = indent + StringUtil.replaceFirst(actualIndent, expectedIndent, "");
                continue;
            }
            if (parentDetailAST.getType() == 176) {
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 95) continue;
                indent = indent + "\t";
                continue;
            }
            if (parentDetailAST.getType() == 7) {
                String expectedIndent;
                String actualIndent;
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 181) continue;
                int lambdaLineNumber = parentDetailAST.getLineNo();
                DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() == 76) {
                    lambdaLineNumber = firstChildDetailAST.getLineNo();
                }
                if (!(actualIndent = StringUtil.removeChar(JavaParser._getIndent(fileContents.getLine(lambdaLineNumber - 1)), ' ')).startsWith(expectedIndent = JavaParser._getExpectedIndent(parentDetailAST, fileContents))) continue;
                indent = indent + StringUtil.replaceFirst(actualIndent, expectedIndent, "");
                continue;
            }
            if (parentDetailAST.getType() != 92 && parentDetailAST.getType() != 83 && parentDetailAST.getType() != 7 && (grandParentDetailAST = parentDetailAST.getParent()) != null && (grandParentDetailAST.getType() == 92 || grandParentDetailAST.getType() == 83 || grandParentDetailAST.getType() == 84)) {
                indent = indent + "\t";
            }
            if ((parentDetailAST.getType() == 91 || parentDetailAST.getType() == 83 || parentDetailAST.getType() == 84) && parentDetailAST.findFirstToken(7) == null) {
                indent = indent + "\t";
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        if (detailAST.getType() != 73) {
            return indent;
        }
        return StringUtil.replaceFirst(indent, "\t", "");
    }

    private static String _getIndent(String s) {
        char c;
        StringBundler sb = new StringBundler(s.length());
        for (int i = 0; i < s.length() && Character.isWhitespace(c = s.charAt(i)); ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static DetailAST _getLastEnumConstantDefinitionDetailAST(DetailAST enumConstantDefinitionDetailAST) {
        DetailAST lastEnumConstantDefinitionDetailAST = enumConstantDefinitionDetailAST;
        for (DetailAST nextSiblingDetailAST = enumConstantDefinitionDetailAST.getNextSibling(); nextSiblingDetailAST != null; nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) {
            if (nextSiblingDetailAST.getType() != 155) continue;
            lastEnumConstantDefinitionDetailAST = nextSiblingDetailAST;
        }
        return lastEnumConstantDefinitionDetailAST;
    }

    private static List<String> _getLines(String s) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(s));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private static int _getLineStartPos(String content, int lineNumber) {
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == 1) {
            return 0;
        }
        int x = -1;
        for (int i = 1; i < lineNumber; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    private static ParsedJavaClass _getParsedJavaClass(DetailAST rootDetailAST, FileContents fileContents) throws IOException {
        ParsedJavaClass parsedJavaClass = JavaParser._walk(new ParsedJavaClass(), rootDetailAST, fileContents);
        parsedJavaClass.processCommentTokens();
        return parsedJavaClass;
    }

    private static boolean _isAtLineEnd(String line, int x) {
        return line.length() == x;
    }

    private static boolean _isAtLineStart(String line, int x) {
        return Validator.isNull(StringUtil.trim(line.substring(0, x)));
    }

    private static boolean _isExcludedJavaTerm(ParsedJavaTerm parsedJavaTerm) {
        CommonHiddenStreamToken precedingCommentToken = parsedJavaTerm.getPrecedingCommentToken();
        while (precedingCommentToken != null) {
            if (precedingCommentToken.getType() == 144 && StringUtil.startsWith(StringUtil.trim(precedingCommentToken.getText()), "Skip JavaParser")) {
                return true;
            }
            precedingCommentToken = precedingCommentToken.getHiddenBefore();
        }
        return false;
    }

    private static String _parse(File file, String content) throws CheckstyleException, IOException {
        List<String> lines = JavaParser._getLines(content);
        FileText fileText = new FileText(file, lines);
        FileContents fileContents = new FileContents(fileText);
        DetailAST rootDetailAST = com.puppycrawl.tools.checkstyle.JavaParser.parse((FileContents)fileContents);
        ParsedJavaClass parsedJavaClass = JavaParser._getParsedJavaClass(rootDetailAST, fileContents);
        String newContent = JavaParser._fixIncorrectStartOrEndPositions(content, parsedJavaClass, fileContents);
        if (!newContent.equals(content)) {
            return JavaParser._parse(file, newContent);
        }
        newContent = JavaParser._parseContent(parsedJavaClass, fileContents, lines);
        if (!newContent.equals(content)) {
            return JavaParser._parse(file, newContent);
        }
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        if (!(newContent = importsFormatter.format(JavaParser._trimContent(newContent), ToolsUtil.getPackagePath(file), StringUtil.replaceLast(file.getName(), ".java", ""))).equals(content)) {
            return JavaParser._parse(file, newContent);
        }
        return newContent;
    }

    private static String _parseContent(ParsedJavaClass parsedJavaClass, FileContents fileContents, List<String> lines) {
        ContentModifications contentModifications = new ContentModifications();
        for (ParsedJavaTerm parsedJavaTerm = parsedJavaClass.getLastParsedJavaTerm(); parsedJavaTerm != null; parsedJavaTerm = parsedJavaTerm.getPreviousParsedJavaTerm()) {
            if (parsedJavaTerm.containsCommentToken()) continue;
            contentModifications = JavaParser._addContentModifications(contentModifications, parsedJavaTerm, fileContents);
        }
        StringBundler sb = new StringBundler();
        for (int i = 0; i < lines.size(); ++i) {
            Tuple replaceContentTuple;
            if (contentModifications.isRemoveLineLineNumber(i + 1)) continue;
            if (contentModifications.isInsertLineLineNumber(i + 1)) {
                sb.append("\n");
            }
            if ((replaceContentTuple = contentModifications.getReplaceContentTuple(i + 1)) == null) {
                sb.append(lines.get(i));
                sb.append("\n");
                continue;
            }
            sb.append((String)replaceContentTuple.getObject(0));
            sb.append("\n");
            i = (Integer)replaceContentTuple.getObject(1) - 1;
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private static ParsedJavaClass _parseDetailAST(ParsedJavaClass parsedJavaClass, DetailAST detailAST, FileContents fileContents) throws IOException {
        DetailAST rparentDetailAST;
        DetailAST previousSiblingDetailAST;
        if (detailAST == null) {
            return parsedJavaClass;
        }
        if (detailAST.getType() == 10 && (previousSiblingDetailAST = detailAST.getPreviousSibling()) != null && previousSiblingDetailAST.getType() == 74) {
            return parsedJavaClass;
        }
        JavaTerm javaTerm = JavaParserUtil.parseJavaTerm(detailAST);
        if (javaTerm != null) {
            parsedJavaClass = JavaParser._addJavaTerm(parsedJavaClass, detailAST, javaTerm, fileContents);
        }
        if (detailAST.getType() == 85) {
            DetailAST doWhileDetailAST = detailAST.findFirstToken(175);
            parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, doWhileDetailAST, fileContents);
        } else if (detailAST.getType() == 92) {
            DetailAST firstChildDetailAST = detailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 83) {
                DetailAST rparentDetailAST2;
                if (firstChildDetailAST.findFirstToken(7) == null && (rparentDetailAST2 = firstChildDetailAST.findFirstToken(77)) != null) {
                    parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, rparentDetailAST2.getNextSibling(), fileContents);
                }
            } else if (firstChildDetailAST.getType() != 7) {
                parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, firstChildDetailAST, fileContents);
            }
        } else if (detailAST.getType() == 83) {
            DetailAST literalElseDetailAST;
            DetailAST literalIfDetailAST = detailAST;
            while ((literalElseDetailAST = literalIfDetailAST.findFirstToken(92)) != null) {
                parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, literalElseDetailAST, fileContents);
                literalIfDetailAST = literalElseDetailAST.findFirstToken(83);
                if (literalIfDetailAST != null) continue;
                break;
            }
        } else if (detailAST.getType() == 89) {
            List<DetailAST> caseGroupDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, false, 33);
            for (DetailAST caseGroupDetailAST : caseGroupDetailASTList) {
                parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, caseGroupDetailAST, fileContents);
            }
        } else if (detailAST.getType() == 95) {
            List<DetailAST> literalCatchDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, false, 96);
            for (DetailAST literalCatchDetailAST : literalCatchDetailASTList) {
                parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, literalCatchDetailAST, fileContents);
            }
            DetailAST literalFinallyDetailAST = detailAST.findFirstToken(97);
            if (literalFinallyDetailAST != null) {
                parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, literalFinallyDetailAST, fileContents);
            }
        }
        if ((detailAST.getType() == 91 || detailAST.getType() == 83 || detailAST.getType() == 84) && detailAST.findFirstToken(7) == null && (rparentDetailAST = detailAST.findFirstToken(77)) != null) {
            parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, rparentDetailAST.getNextSibling(), fileContents);
        }
        return parsedJavaClass;
    }

    private static String _trimContent(String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(StringUtil.trimTrailing(line));
                sb.append("\n");
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        String newContent = sb.toString();
        while (newContent.contains("\n\n\n")) {
            newContent = StringUtil.replace(newContent, "\n\n\n", "\n\n");
        }
        return newContent;
    }

    private static String _trimLine(String content, String line, int lineNumber) {
        int x = JavaParser._getLineStartPos(content, lineNumber);
        return StringUtil.replaceFirst(content, line, StringUtil.trimTrailing(line), x);
    }

    private static ParsedJavaClass _walk(ParsedJavaClass parsedJavaClass, DetailAST detailAST, FileContents fileContents) throws IOException {
        CommonHiddenStreamToken commonHiddenStreamToken;
        if (detailAST == null) {
            return parsedJavaClass;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (!(detailAST.getType() != 157 && detailAST.getType() != 14 && detailAST.getType() != 154 && detailAST.getType() != 15 || parentDetailAST != null && parentDetailAST.getType() == 6)) {
            parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, detailAST, fileContents);
        } else if (detailAST.getType() == 30 || detailAST.getType() == 16 || detailAST.getType() == 152) {
            parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, detailAST, fileContents);
        }
        if (parentDetailAST != null && (parentDetailAST.getType() == 6 || parentDetailAST.getType() == 7)) {
            parsedJavaClass = JavaParser._parseDetailAST(parsedJavaClass, detailAST, fileContents);
        }
        if ((commonHiddenStreamToken = DetailASTUtil.getHiddenBefore(detailAST)) != null) {
            parsedJavaClass.addPrecedingCommentToken(commonHiddenStreamToken, DetailASTUtil.getStartPosition(detailAST));
        }
        parsedJavaClass = JavaParser._walk(parsedJavaClass, detailAST.getFirstChild(), fileContents);
        parsedJavaClass = JavaParser._walk(parsedJavaClass, detailAST.getNextSibling(), fileContents);
        return parsedJavaClass;
    }

    private static class ContentModifications {
        private final List<Integer> _insertLineBreakLineNumbers = new ArrayList<Integer>();
        private final List<Integer> _removeLineLineNumbers = new ArrayList<Integer>();
        private final Map<Integer, Tuple> _replaceContentMap = new HashMap<Integer, Tuple>();

        private ContentModifications() {
        }

        public void addInsertLineBreakLineNumber(int lineNumber) {
            this._insertLineBreakLineNumbers.add(lineNumber);
        }

        public void addRemoveLineLineNumber(int lineNumber) {
            this._removeLineLineNumbers.add(lineNumber);
        }

        public void addReplaceContent(String content, int lineNumber) {
            this._replaceContentMap.put(lineNumber, new Tuple(content, lineNumber));
        }

        public void addReplaceContent(String content, int startlineNumber, int endLineNumber) {
            this._replaceContentMap.put(startlineNumber, new Tuple(content, endLineNumber));
        }

        public Tuple getReplaceContentTuple(int lineNumber) {
            return this._replaceContentMap.get(lineNumber);
        }

        public boolean isInsertLineLineNumber(int lineNumber) {
            return this._insertLineBreakLineNumbers.contains(lineNumber);
        }

        public boolean isRemoveLineLineNumber(int lineNumber) {
            return this._removeLineLineNumbers.contains(lineNumber);
        }
    }
}

