/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UnusedMethodCheck
extends BaseCheck {
    private static final String _ALLOWED_METHOD_NAMES_KEY = "allowedMethodNames";
    private static final String _MSG_UNUSED_METHOD = "method.unused";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<DetailAST> methodDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 9);
        if (methodDefinitionDetailASTList.isEmpty()) {
            return;
        }
        List<String> allowedMethodNames = this.getAttributeValues(_ALLOWED_METHOD_NAMES_KEY);
        List<String> referencedMethodNames = this._getReferencedMethodNames(detailAST);
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            DetailAST nameDetailAST;
            String name;
            DetailAST modifiersDetailAST = methodDefinitionDetailAST.findFirstToken(5);
            if (!modifiersDetailAST.branchContains(61) || AnnotationUtil.containsAnnotation((DetailAST)methodDefinitionDetailAST) || this._hasSuppressUnusedWarningsAnnotation(methodDefinitionDetailAST) || allowedMethodNames.contains(name = (nameDetailAST = methodDefinitionDetailAST.findFirstToken(58)).getText()) || referencedMethodNames.contains(nameDetailAST.getText())) continue;
            this.log(methodDefinitionDetailAST, _MSG_UNUSED_METHOD, new Object[]{name});
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<String> _getReferencedMethodNames(DetailAST classDefinitionDetailAST) {
        ArrayList<String> referencedMethodNames = new ArrayList<String>();
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getAllChildTokens(classDefinitionDetailAST, true, 27);
        for (DetailAST detailAST : methodCallDetailASTList) {
            void var6_8;
            DetailAST detailAST2 = detailAST.getFirstChild();
            if (detailAST2.getType() == 59) {
                DetailAST detailAST3 = detailAST2.getLastChild();
            }
            referencedMethodNames.add(var6_8.getText());
        }
        List<DetailAST> methodReferenceDetailASTList = DetailASTUtil.getAllChildTokens(classDefinitionDetailAST, true, 180);
        for (DetailAST detailAST : methodReferenceDetailASTList) {
            DetailAST lastChildDetailAST = detailAST.getLastChild();
            referencedMethodNames.add(lastChildDetailAST.getText());
        }
        List<DetailAST> list = DetailASTUtil.getAllChildTokens(classDefinitionDetailAST, true, 136);
        for (DetailAST literalNewDetailAST : list) {
            DetailAST exprDetailAST;
            DetailAST firstChildDetailAST = literalNewDetailAST.getFirstChild();
            if (firstChildDetailAST == null || firstChildDetailAST.getType() != 58 || !Objects.equals(firstChildDetailAST.getText(), "MethodKey")) continue;
            DetailAST elistDetailAST = literalNewDetailAST.findFirstToken(34);
            List<DetailAST> exprDetailASTList = DetailASTUtil.getAllChildTokens(elistDetailAST, false, 28);
            if (exprDetailASTList.size() < 2 || (firstChildDetailAST = (exprDetailAST = exprDetailASTList.get(1)).getFirstChild()).getType() != 139) continue;
            String text = firstChildDetailAST.getText();
            referencedMethodNames.add(text.substring(1, text.length() - 1));
        }
        List<DetailAST> list2 = DetailASTUtil.getAllChildTokens(classDefinitionDetailAST, true, 159);
        for (DetailAST annotationDetailAST : list2) {
            DetailAST atDetailAST = annotationDetailAST.findFirstToken(170);
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)atDetailAST.getNextSibling());
            String annotationName = fullIdent.getText();
            if (!annotationName.endsWith("Reference")) continue;
            List<DetailAST> annotationMemberValuePairDetailASTList = DetailASTUtil.getAllChildTokens(annotationDetailAST, false, 160);
            for (DetailAST annotationMemberValuePairDetailAST : annotationMemberValuePairDetailASTList) {
                DetailAST nextSiblingDetailAST;
                String propertyValueName;
                DetailAST firstChildDetailAST = annotationMemberValuePairDetailAST.getFirstChild();
                String propertyName = firstChildDetailAST.getText();
                if (!propertyName.equals("unbind") || !(propertyValueName = (fullIdent = FullIdent.createFullIdentBelow((DetailAST)(nextSiblingDetailAST = firstChildDetailAST.getNextSibling()).getNextSibling())).getText()).matches("\".*\"")) continue;
                referencedMethodNames.add(propertyValueName.substring(1, propertyValueName.length() - 1));
            }
        }
        return referencedMethodNames;
    }

    private boolean _hasSuppressUnusedWarningsAnnotation(DetailAST methodDefinitionDetailAST) {
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)methodDefinitionDetailAST, (String)"SuppressWarnings");
        if (annotationDetailAST == null) {
            return false;
        }
        List<DetailAST> literalStringDetailASTList = DetailASTUtil.getAllChildTokens(annotationDetailAST, true, 139);
        for (DetailAST literalStringDetailAST : literalStringDetailASTList) {
            String s = literalStringDetailAST.getText();
            if (!s.equals("\"unused\"")) continue;
            return true;
        }
        return false;
    }
}

