/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class OperatorOperandCheck
extends BaseCheck {
    private static final int[] _ARITHMETIC_OPERATOR_TOKEN_TYPES = new int[]{127, 126, 128, 125, 60};
    private static final String _MSG_IMPROVE_READABILITY = "readability.improve";
    private static final int[] _RELATIONAL_OPERATOR_TOKEN_TYPES = new int[]{116, 120, 118, 119, 117, 115};

    public int[] getDefaultTokens() {
        return ArrayUtil.append(_ARITHMETIC_OPERATOR_TOKEN_TYPES, _RELATIONAL_OPERATOR_TOKEN_TYPES);
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST lastChildDetailAST;
        if (this._isInsideGlobalVariableDefinition(detailAST)) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 27 && DetailASTUtil.isAtLineEnd(firstChildDetailAST, this.getLine(firstChildDetailAST.getLineNo() - 1))) {
            this.log(firstChildDetailAST, _MSG_IMPROVE_READABILITY, new Object[]{"left", detailAST.getText()});
        }
        if ((lastChildDetailAST = detailAST.getLastChild()).getType() == 27 && ArrayUtil.contains(_ARITHMETIC_OPERATOR_TOKEN_TYPES, detailAST.getType()) && DetailASTUtil.isAtLineEnd(lastChildDetailAST, this.getLine(lastChildDetailAST.getLineNo() - 1))) {
            this.log(lastChildDetailAST, _MSG_IMPROVE_READABILITY, new Object[]{"right", detailAST.getText()});
        }
    }

    private boolean _isInsideGlobalVariableDefinition(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (parentDetailAST.getType() == 14 || parentDetailAST.getType() == 154 || parentDetailAST.getType() == 15) {
                return true;
            }
            if (parentDetailAST.getType() == 8 || parentDetailAST.getType() == 9) {
                return false;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }
}

