/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;

public class BNDDirectoryNameCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkDirectoryName(fileName, absolutePath);
        }
        return content;
    }

    private void _checkDirectoryName(String fileName, String absolutePath) {
        int x;
        int y;
        int z;
        String applicationName;
        String moduleName = BNDSourceUtil.getModuleName(absolutePath);
        if (absolutePath.matches(".*/apps(/.*){3,}") && !moduleName.startsWith(applicationName = absolutePath.substring((z = absolutePath.lastIndexOf("/", (y = absolutePath.lastIndexOf("/", (x = absolutePath.lastIndexOf("/")) - 1)) - 1)) + 1, y))) {
            this.addMessage(fileName, StringBundler.concat("Module '", moduleName, "' should start with '", applicationName, "'"), "module_directory_structure.markdown");
        }
        if (moduleName.endsWith("-taglib-web")) {
            String newModuleName = moduleName.substring(0, moduleName.length() - 4);
            this.addMessage(fileName, StringBundler.concat("Rename module '", moduleName, "' to '", newModuleName, "'"), "module_directory_structure.markdown");
        }
    }
}

