/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UnnecessaryTypeCastCheck
extends BaseCheck {
    private static final String _MSG_UNNECESSARY_TYPE_CAST = "type.cast.unnecessary";

    public int[] getDefaultTokens() {
        return new int[]{23};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST rparenDetailAST = detailAST.findFirstToken(77);
        DetailAST nextSiblingDetailAST = rparenDetailAST.getNextSibling();
        if (nextSiblingDetailAST.getType() != 27) {
            return;
        }
        DetailAST firstChildDetailAST = nextSiblingDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        this._checkUnnecessaryMethodCallTypeCast(detailAST, firstChildDetailAST, "Enumeration", "nextElement", 1);
        this._checkUnnecessaryMethodCallTypeCast(detailAST, firstChildDetailAST, "List", "get", 1);
        this._checkUnnecessaryMethodCallTypeCast(detailAST, firstChildDetailAST, "Map", "get", 2);
        this._checkUnnecessaryMethodCallTypeCast(detailAST, firstChildDetailAST, "Map.Entry", "getKey", 1);
        this._checkUnnecessaryMethodCallTypeCast(detailAST, firstChildDetailAST, "Map.Entry", "getValue", 2);
    }

    private void _checkUnnecessaryMethodCallTypeCast(DetailAST typecastDetailAST, DetailAST dotDetailAST, String typeName, String methodName, int index) {
        DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
        if (!methodName.equals(lastChildDetailAST.getText())) {
            return;
        }
        DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 58) {
            return;
        }
        String variableName = firstChildDetailAST.getText();
        String variableTypeName = this.getVariableTypeName(dotDetailAST, variableName, true);
        if (!variableTypeName.startsWith(typeName + "<")) {
            return;
        }
        List<String> genericTypeNames = this._getGenericTypeNames(variableTypeName);
        if (genericTypeNames.size() >= index && Objects.equals(this.getTypeName(typecastDetailAST, true), genericTypeNames.get(index - 1))) {
            this.log(dotDetailAST, _MSG_UNNECESSARY_TYPE_CAST, new Object[]{variableName + "." + methodName});
        }
    }

    private List<String> _getGenericTypeNames(String typeName) {
        int x = typeName.indexOf(60);
        int y = typeName.lastIndexOf(62);
        if (x == -1 || y == -1) {
            return null;
        }
        String genericType = typeName.substring(x + 1, y);
        ArrayList<String> genericTypeNames = new ArrayList<String>();
        x = -1;
        y = 0;
        while (true) {
            if ((x = genericType.indexOf(44, x + 1)) == -1) {
                genericTypeNames.add(StringUtil.trim(genericType.substring(y)));
                return genericTypeNames;
            }
            String s = genericType.substring(y, x);
            if (StringUtil.count(s, '<') != StringUtil.count(s, '>')) continue;
            genericTypeNames.add(StringUtil.trim(s));
            y = x + 1;
        }
    }
}

