/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodNamingCheck
extends BaseCheck {
    private static final String _MSG_RENAME_METHOD = "method.rename";
    private static final Pattern _doMethodNamePattern = Pattern.compile("^_do([A-Z])(.*)$");

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String methodName = this._getMethodName(detailAST);
        this._checkDoMethodName(detailAST, methodName);
    }

    private void _checkDoMethodName(DetailAST detailAST, String methodName) {
        Matcher matcher = _doMethodNamePattern.matcher(methodName);
        if (!matcher.find()) {
            return;
        }
        String noDoName = "_" + StringUtil.toLowerCase(matcher.group(1)) + matcher.group(2);
        String noUnderscoreName = methodName.substring(1);
        DetailAST parentDetailAST = detailAST.getParent();
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(parentDetailAST, false, 9);
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            String curMethodName = this._getMethodName(methodDefinitionDetailAST);
            if (!curMethodName.equals(noUnderscoreName) && (!curMethodName.equals(noDoName) || !Objects.equals(this.getSignature(detailAST), this.getSignature(methodDefinitionDetailAST)))) continue;
            return;
        }
        this.log(detailAST, _MSG_RENAME_METHOD, new Object[]{methodName, noDoName});
    }

    private String _getMethodName(DetailAST detailAST) {
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        return nameDetailAST.getText();
    }
}

