/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.PropertyValueComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class PropertiesSourceFormatterFileCheck
extends BaseFileCheck {
    private static final Pattern _checkPropertyPattern = Pattern.compile("\n\\s*#?(checkstyle|source\\.check)\\.(.*\\.check)\\.");
    private Boolean _hasPrivateAppsDir;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (absolutePath.endsWith("/source-formatter.properties")) {
            content = this._fixCheckProperties(content);
            return this._formatSourceFormatterProperties(fileName, content);
        }
        return content;
    }

    private String _fixCheckProperties(String content) throws Exception {
        Matcher matcher = _checkPropertyPattern.matcher(content);
        while (matcher.find()) {
            List<String> checkNames = null;
            checkNames = Objects.equals(matcher.group(1), "checkstyle") ? this._getCheckstyleCheckNames() : this._getSourceCheckCheckNames();
            String match = matcher.group(2);
            String formattedMatch = StringUtil.removeChar(match, '.');
            for (String checkName : checkNames) {
                if (!StringUtil.equalsIgnoreCase(checkName, formattedMatch)) continue;
                return StringUtil.replaceFirst(content, match, checkName, matcher.start());
            }
        }
        return content;
    }

    private String _formatSourceFormatterProperties(String fileName, String content) throws Exception {
        int level = 3;
        if (this.isPortalSource()) {
            level = 7;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = properties.getProperty(key);
            if (Validator.isNull(value)) continue;
            List<String> propertyValues = ListUtil.fromString(value, ",");
            if (propertyValues.size() > 1) {
                content = this._sortPropertyValues(content, key, propertyValues);
            }
            if (!key.endsWith("excludes")) continue;
            for (String propertyFileName : propertyValues) {
                File file;
                if (propertyFileName.contains("*") || propertyFileName.endsWith("-ext.properties") || this.isPortalSource() && !this._hasPrivateAppsDir() && this.isModulesApp(propertyFileName, true)) continue;
                int pos = propertyFileName.indexOf(64);
                if (pos != -1) {
                    propertyFileName = propertyFileName.substring(0, pos);
                }
                if ((file = this.getFile(propertyFileName, level)) != null) continue;
                this.addMessage(fileName, "Property value '" + propertyFileName + "' points to file that does not exist");
            }
        }
        return content;
    }

    private List<String> _getCheckstyleCheckNames() throws Exception {
        ArrayList<String> checkstyleCheckNames = new ArrayList<String>();
        checkstyleCheckNames.addAll(this._getCheckstyleCheckNames(this._getRootElement("checkstyle.xml")));
        return checkstyleCheckNames;
    }

    private List<String> _getCheckstyleCheckNames(Element moduleElement) {
        ArrayList<String> checkstyleCheckNames = new ArrayList<String>();
        String checkName = moduleElement.attributeValue("name");
        int x = checkName.lastIndexOf(46);
        if (x != -1) {
            checkstyleCheckNames.add(checkName.substring(x + 1));
        } else {
            checkstyleCheckNames.add(checkName);
        }
        for (Element childModuleElement : moduleElement.elements("module")) {
            checkstyleCheckNames.addAll(this._getCheckstyleCheckNames(childModuleElement));
        }
        return checkstyleCheckNames;
    }

    private Element _getRootElement(String fileName) throws Exception {
        ClassLoader classLoader = PropertiesSourceFormatterFileCheck.class.getClassLoader();
        String content = StringUtil.read(classLoader.getResourceAsStream(fileName));
        Document document = SourceUtil.readXML(content);
        return document.getRootElement();
    }

    private List<String> _getSourceCheckCheckNames() throws Exception {
        ArrayList<String> sourceCheckCheckNames = new ArrayList<String>();
        Element rootElement = this._getRootElement("sourcechecks.xml");
        for (Element sourceProcessorElement : rootElement.elements("source-processor")) {
            for (Element checkElement : sourceProcessorElement.elements("check")) {
                sourceCheckCheckNames.add(checkElement.attributeValue("name"));
            }
        }
        return sourceCheckCheckNames;
    }

    private synchronized boolean _hasPrivateAppsDir() {
        if (this._hasPrivateAppsDir != null) {
            return this._hasPrivateAppsDir;
        }
        this._hasPrivateAppsDir = false;
        if (this.isPortalSource()) {
            return this._hasPrivateAppsDir;
        }
        File dxpAppsDir = this.getFile("modules/dxp/apps", 7);
        if (dxpAppsDir != null) {
            this._hasPrivateAppsDir = true;
            return this._hasPrivateAppsDir;
        }
        File privateAppsDir = this.getFile("modules/private/apps", 7);
        if (privateAppsDir != null) {
            this._hasPrivateAppsDir = true;
        }
        return this._hasPrivateAppsDir;
    }

    private String _sortPropertyValues(String content, String propertyKey, List<String> propertyValues) {
        PropertyValueComparator comparator = new PropertyValueComparator();
        for (int i = 0; i < propertyValues.size() - 1; ++i) {
            String nextPropertyValue;
            String propertyValue = propertyValues.get(i);
            if (comparator.compare(propertyValue, nextPropertyValue = propertyValues.get(i + 1)) <= 0) continue;
            return this._swapValues(content, propertyKey, propertyValue, nextPropertyValue);
        }
        return content;
    }

    private String _swapValues(String content, int x, String s1, String s2) {
        char c;
        do {
            if ((x = content.indexOf(s1, x + 1)) != -1) continue;
            return content;
        } while (!Character.isWhitespace(c = content.charAt(x - 1)) && c != '=' && c != ',' || x + s1.length() < content.length() && !Character.isWhitespace(c = content.charAt(x + s1.length())) && c != ',');
        return StringUtil.replaceFirst(content, s1, s2, x);
    }

    private String _swapValues(String content, String propertyKey, String propertyValue, String nextPropertyValue) {
        int x = -1;
        do {
            if ((x = content.indexOf(propertyKey + "=")) != -1) continue;
            return content;
        } while (x != 0 && !Character.isWhitespace(content.charAt(x - 1)));
        content = this._swapValues(content, x, nextPropertyValue, propertyValue);
        content = this._swapValues(content, x, propertyValue, nextPropertyValue);
        return content;
    }
}

