/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJSPTermsCheck;
import java.io.IOException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPTaglibVariableCheck
extends BaseJSPTermsCheck {
    private static final Pattern _taglibVariablePattern = Pattern.compile("(\t*String (\\w+) = (.*);)\n\\s*%>\\s+(<[\\S\\s]*?>)\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        return this._formatTaglibVariable(fileName, content);
    }

    private String _formatTaglibVariable(String fileName, String content) throws IOException {
        Matcher matcher = _taglibVariablePattern.matcher(content);
        while (matcher.find()) {
            String nextTag = matcher.group(4);
            String taglibValue = matcher.group(3);
            String variableName = matcher.group(2);
            if (taglibValue.contains("\\\"") || taglibValue.contains("'") && taglibValue.contains("\"")) {
                if (variableName.startsWith("taglib") || StringUtil.count(content, variableName) != 2 || !nextTag.contains("=\"<%= " + variableName + " %>\"")) continue;
                this.addMessage(fileName, "Variable '" + variableName + "' should start with 'taglib'", this.getLineNumber(content, matcher.start()));
                continue;
            }
            if (!nextTag.contains("=\"<%= " + variableName + " %>\"")) continue;
            this.populateContentsMap(fileName, content);
            String newContent = StringUtil.replaceFirst(content, variableName, taglibValue, matcher.start(4));
            HashSet<String> checkedFileNames = new HashSet<String>();
            HashSet<String> includeFileNames = new HashSet<String>();
            if (!this.hasUnusedJSPTerm(fileName, newContent, "\\W" + variableName + "\\W", "variable", checkedFileNames, includeFileNames, this.getContentsMap())) continue;
            return StringUtil.replaceFirst(newContent, matcher.group(1), "", matcher.start());
        }
        return content;
    }
}

