/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.web.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;

public class UpgradePortletPreferences
extends BaseUpgradePortletPreferences {
    protected String[] getPortletIds() {
        return new String[]{"com_liferay_site_navigation_menu_web_portlet_SiteNavigationMenuPortlet%"};
    }

    protected void upgradeDisplayStyle(PortletPreferences portletPreferences) throws ReadOnlyException {
        String displayStyle = GetterUtil.getString((String)portletPreferences.getValue("displayStyle", null));
        if (Validator.isNull((String)displayStyle) || displayStyle.startsWith("ddmTemplate_")) {
            return;
        }
        portletPreferences.setValue("displayStyle", "ddmTemplate_list-menu-ftl");
        this._persistSupportedProperties(portletPreferences, displayStyle);
        this._removeUnsupportedPreferences(portletPreferences);
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        this.upgradeDisplayStyle(portletPreferences);
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    private void _persistSupportedProperties(PortletPreferences portletPreferences, String displayStyle) throws ReadOnlyException {
        String includedLayouts = "auto";
        String rootLayoutLevel = "1";
        String rootLayoutType = "absolute";
        if (displayStyle.equals("[custom]")) {
            includedLayouts = portletPreferences.getValue("includedLayouts", includedLayouts);
            rootLayoutLevel = portletPreferences.getValue("rootLayoutLevel", rootLayoutLevel);
            rootLayoutType = portletPreferences.getValue("rootLayoutType", rootLayoutType);
        } else {
            String[] displayStyleDefinition = PropsUtil.getArray((String)"navigation.display.style", (Filter)new Filter(displayStyle));
            if (displayStyleDefinition != null && displayStyleDefinition.length != 0) {
                includedLayouts = displayStyleDefinition[3];
                rootLayoutLevel = displayStyleDefinition[2];
                rootLayoutType = displayStyleDefinition[1];
            } else if (displayStyle.equals("from-level-0")) {
                rootLayoutLevel = "0";
            } else if (displayStyle.equals("from-level-1-to-all-sublevels")) {
                includedLayouts = "all";
            } else if (displayStyle.equals("from-level-2-with-title")) {
                rootLayoutLevel = "2";
            } else if (displayStyle.equals("relative-with-breadcrumb")) {
                rootLayoutLevel = "0";
                rootLayoutType = "relative";
            }
        }
        portletPreferences.setValue("includedLayouts", includedLayouts);
        portletPreferences.setValue("rootLayoutLevel", rootLayoutLevel);
        portletPreferences.setValue("rootLayoutType", rootLayoutType);
    }

    private void _removeUnsupportedPreferences(PortletPreferences portletPreferences) throws ReadOnlyException {
        portletPreferences.reset("bulletStyle");
        portletPreferences.reset("headerType");
        portletPreferences.reset("nestedChildren");
    }
}

