/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.item.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;

public class SiteNavigationMenuItemUtil {
    public static UnicodeProperties getSiteNavigationMenuItemProperties(PortletRequest portletRequest, String prefix) {
        Map parameterMap = portletRequest.getParameterMap();
        Object[] localizableParameters = new String[]{};
        for (String key : parameterMap.keySet()) {
            if (key.startsWith(prefix)) continue;
            localizableParameters = (String[])ArrayUtil.append((Object[])localizableParameters, (Object)key);
        }
        UnicodeProperties unicodeProperties = PropertiesParamUtil.getProperties((PortletRequest)portletRequest, (String)prefix);
        for (Object localizableParameter : localizableParameters) {
            Map map = LocalizationUtil.getLocalizationMap((PortletRequest)portletRequest, (String)localizableParameter);
            if (MapUtil.isEmpty((Map)map)) continue;
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                if (Validator.isNull((String)value)) continue;
                String key = (String)localizableParameter + "_" + LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey()));
                unicodeProperties.setProperty(key, value);
            }
        }
        if (!unicodeProperties.containsKey((Object)"defaultLanguageId")) {
            unicodeProperties.setProperty("defaultLanguageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getMostRelevantLocale()));
        }
        return unicodeProperties;
    }

    public static String getSiteNavigationMenuItemXML(SiteNavigationMenuItem siteNavigationMenuItem, String name) throws PortalException {
        Stream stream;
        Map<String, String> map;
        if (siteNavigationMenuItem == null) {
            return "";
        }
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
        Set availableLocales = LanguageUtil.getAvailableLocales((long)siteNavigationMenuItem.getGroupId());
        if (Objects.equals(siteNavigationMenuItem.getType(), "layout")) {
            String layoutUuid = (String)typeSettingsProperties.get((Object)"layoutUuid");
            boolean privateLayout = GetterUtil.getBoolean((String)((String)typeSettingsProperties.get((Object)"privateLayout")));
            Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)siteNavigationMenuItem.getGroupId(), (boolean)privateLayout);
            Map nameMap = layout.getNameMap();
            for (Map.Entry nameEntry : nameMap.entrySet()) {
                String languageId2 = LocaleUtil.toLanguageId((Locale)((Locale)nameEntry.getKey()));
                String value = (String)nameEntry.getValue();
                if (!Validator.isNull((String)typeSettingsProperties.getProperty("name_" + languageId2))) continue;
                typeSettingsProperties.setProperty("name_" + languageId2, value);
            }
        }
        if (MapUtil.isEmpty(map = (stream = availableLocales.stream()).map(locale -> LocaleUtil.toLanguageId((Locale)locale)).filter(languageId -> Validator.isNotNull((String)typeSettingsProperties.getProperty(name + "_" + languageId))).collect(Collectors.toMap(languageId -> languageId, languageId -> typeSettingsProperties.getProperty(name + "_" + languageId))))) {
            String defaultLanguageId = typeSettingsProperties.getProperty("defaultLanguageId", LocaleUtil.toLanguageId((Locale)PortalUtil.getSiteDefaultLocale((long)siteNavigationMenuItem.getGroupId())));
            map.put(defaultLanguageId, typeSettingsProperties.getProperty(name));
        }
        return LocalizationUtil.getXml(map, (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getMostRelevantLocale()), (String)name);
    }
}

