/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.language.web.internal.display.context;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.KeyValuePairComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import com.liferay.site.navigation.language.web.configuration.SiteNavigationLanguagePortletInstanceConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SiteNavigationLanguageDisplayContext {
    private String[] _availableLanguageIds;
    private String _ddmTemplateKey;
    private long _displayStyleGroupId;
    private String[] _languageIds;
    private final PortletDisplayTemplate _portletDisplayTemplate;
    private final SiteNavigationLanguagePortletInstanceConfiguration _siteNavigationLanguagePortletInstanceConfiguration;
    private final ThemeDisplay _themeDisplay;

    public SiteNavigationLanguageDisplayContext(HttpServletRequest httpServletRequest) throws ConfigurationException {
        this._portletDisplayTemplate = (PortletDisplayTemplate)httpServletRequest.getAttribute("PORTLET_DISPLAY_TEMPLATE");
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        this._siteNavigationLanguagePortletInstanceConfiguration = (SiteNavigationLanguagePortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(SiteNavigationLanguagePortletInstanceConfiguration.class);
    }

    public List<KeyValuePair> getAvailableLanguageIdKVPs() {
        ArrayList<KeyValuePair> availableLanguageIdKVPs = new ArrayList();
        Object[] languageIds = this.getLanguageIds();
        Arrays.sort(languageIds);
        Set availableLanguageIdsSet = SetUtil.fromArray((Object[])this.getAvailableLanguageIds());
        for (String languageId : availableLanguageIdsSet) {
            if (Arrays.binarySearch(languageIds, languageId) >= 0) continue;
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            availableLanguageIdKVPs.add(new KeyValuePair(languageId, locale.getDisplayName(this._themeDisplay.getLocale())));
        }
        availableLanguageIdKVPs = ListUtil.sort(availableLanguageIdKVPs, (Comparator)new KeyValuePairComparator(false, true));
        return availableLanguageIdKVPs;
    }

    public String[] getAvailableLanguageIds() {
        if (this._availableLanguageIds != null) {
            return this._availableLanguageIds;
        }
        this._availableLanguageIds = LocaleUtil.toLanguageIds((Collection)LanguageUtil.getAvailableLocales((long)this._themeDisplay.getSiteGroupId()));
        return this._availableLanguageIds;
    }

    public List<KeyValuePair> getCurrentLanguageIdKVPs() {
        String[] languageIds;
        ArrayList<KeyValuePair> currentLanguageIdKVPs = new ArrayList<KeyValuePair>();
        for (String languageId : languageIds = this.getLanguageIds()) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            currentLanguageIdKVPs.add(new KeyValuePair(languageId, locale.getDisplayName(this._themeDisplay.getLocale())));
        }
        return currentLanguageIdKVPs;
    }

    public String getDDMTemplateKey() {
        if (this._ddmTemplateKey != null) {
            return this._ddmTemplateKey;
        }
        String displayStyle = this._siteNavigationLanguagePortletInstanceConfiguration.displayStyle();
        if (displayStyle != null) {
            this._ddmTemplateKey = this._portletDisplayTemplate.getDDMTemplateKey(displayStyle);
        }
        return this._ddmTemplateKey;
    }

    public long getDisplayStyleGroupId() {
        if (this._displayStyleGroupId != 0L) {
            return this._displayStyleGroupId;
        }
        this._displayStyleGroupId = this._siteNavigationLanguagePortletInstanceConfiguration.displayStyleGroupId();
        if (this._displayStyleGroupId <= 0L) {
            this._displayStyleGroupId = this._themeDisplay.getSiteGroupId();
        }
        return this._displayStyleGroupId;
    }

    public String[] getLanguageIds() {
        if (this._languageIds != null) {
            return this._languageIds;
        }
        this._languageIds = StringUtil.split((String)this._siteNavigationLanguagePortletInstanceConfiguration.languageIds());
        if (ArrayUtil.isEmpty((Object[])this._languageIds)) {
            this._languageIds = this.getAvailableLanguageIds();
        }
        return this._languageIds;
    }

    public SiteNavigationLanguagePortletInstanceConfiguration getSiteNavigationLanguagePortletInstanceConfiguration() {
        return this._siteNavigationLanguagePortletInstanceConfiguration;
    }
}

