Liferay.Loader.define("site-navigation-admin-web@3.0.24/site_navigation_menu_editor/components/MenuItem", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/card', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../constants/sidebarPanelIds', '../contexts/SelectedMenuItemIdContext', '../contexts/SidebarPanelIdContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.MenuItem = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _card = _interopRequireDefault(require("@frontend-taglib-clay$clayui/card"));

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _sidebarPanelIds = require("../constants/sidebarPanelIds");

    var _SelectedMenuItemIdContext = require("../contexts/SelectedMenuItemIdContext");

    var _SidebarPanelIdContext = require("../contexts/SidebarPanelIdContext");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var MenuItem = function MenuItem(_ref) {
      var item = _ref.item;
      var setSelectedMenuItemId = (0, _SelectedMenuItemIdContext.useSetSelectedMenuItemId)();
      var setSidebarPanelId = (0, _SidebarPanelIdContext.useSetSidebarPanelId)();
      var selected = (0, _SelectedMenuItemIdContext.useSelectedMenuItemId)() === item.siteNavigationMenuItemId;
      return _react["default"].createElement(_card["default"], {
        className: (0, _classnames["default"])('site_navigation_menu_editor_MenuItem', {
          'site_navigation_menu_editor_MenuItem--selected': selected
        }),
        horizontal: true,
        selectable: true
      }, _react["default"].createElement(_form.ClayCheckbox, {
        checked: selected,
        onChange: function onChange() {
          setSelectedMenuItemId(item.siteNavigationMenuItemId);
          setSidebarPanelId(_sidebarPanelIds.SIDEBAR_PANEL_IDS.menuItemSettings);
        }
      }, _react["default"].createElement(_card["default"].Body, {
        className: "px-0"
      }, _react["default"].createElement(_card["default"].Row, null, _react["default"].createElement(_layout["default"].ContentCol, {
        gutters: true
      }, _react["default"].createElement(_button.ClayButtonWithIcon, {
        displayType: "unstyled",
        small: true,
        symbol: "drag"
      })), _react["default"].createElement(_layout["default"].ContentCol, {
        expand: true
      }, _react["default"].createElement(_card["default"].Description, {
        displayType: "title"
      }, item.title), _react["default"].createElement(_card["default"].Description, {
        displayType: "subtitle"
      }, item.type)), _react["default"].createElement(_layout["default"].ContentCol, {
        gutters: true
      }, _react["default"].createElement(_button.ClayButtonWithIcon, {
        displayType: "unstyled",
        small: true,
        symbol: "times-circle"
      }))))));
    };

    exports.MenuItem = MenuItem;
    //# sourceMappingURL=MenuItem.js.map
  }
});
//# sourceMappingURL=MenuItem.js.map