Liferay.Loader.define("site-navigation-admin-web@3.0.24/js/SiteNavigationMenuItemDOMHandler", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.unselectAll = exports.setSelected = exports.setDragging = exports.isSelected = exports.isMenuItem = exports.isChildOf = exports.getSiblings = exports.getParent = exports.getNextSibling = exports.getId = exports.getFromId = exports.getFromContentElement = exports.getChildren = exports.MENU_ITEM_DRAGGING_CLASSNAME = exports.MENU_ITEM_DRAG_ICON_CLASSNAME = exports.MENU_ITEM_CLASSNAME = exports.MENU_ITEM_CONTENT_CLASSNAME = exports.MENU_CONTAINER_CLASSNAME = void 0;

    var _metalDom = require("frontend-js-metal-web$metal-dom");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var MENU_CONTAINER_CLASSNAME = 'site-navigation-menu-container';
    exports.MENU_CONTAINER_CLASSNAME = MENU_CONTAINER_CLASSNAME;
    var MENU_ITEM_CLASSNAME = 'site-navigation-menu-item';
    exports.MENU_ITEM_CLASSNAME = MENU_ITEM_CLASSNAME;
    var MENU_ITEM_CONTENT_CLASSNAME = "".concat(MENU_ITEM_CLASSNAME, "__content");
    exports.MENU_ITEM_CONTENT_CLASSNAME = MENU_ITEM_CONTENT_CLASSNAME;
    var MENU_ITEM_DRAGGING_CLASSNAME = "".concat(MENU_ITEM_CLASSNAME, "--dragging");
    exports.MENU_ITEM_DRAGGING_CLASSNAME = MENU_ITEM_DRAGGING_CLASSNAME;
    var MENU_ITEM_DRAG_ICON_CLASSNAME = "".concat(MENU_ITEM_CLASSNAME, "__drag-icon");
    exports.MENU_ITEM_DRAG_ICON_CLASSNAME = MENU_ITEM_DRAG_ICON_CLASSNAME;
    var MENU_ITEM_SELECTED_CLASSNAME = "".concat(MENU_ITEM_CLASSNAME, "--selected");
    /**
     * Returns the menu item element's children.
     *
     * @param {HTMLElement} menuItem The menu item to return children for.
     * @return {Array<HTMLElement>}
     */

    var getChildren = function getChildren(menuItem) {
      return Array.prototype.slice.call(menuItem.children).filter(function (child) {
        return (0, _metalDom.hasClass)(child, MENU_ITEM_CLASSNAME);
      });
    };
    /**
     * Returns the parent menu item element of the menu item content.
     *
     * @param {HTMLElement} menuItemContent The menu item content to return the
     * parent menu item for.
     * @return {HTMLElement|null}
     */

    exports.getChildren = getChildren;

    var getFromContentElement = function getFromContentElement(menuItemContent) {
      return (0, _metalDom.closest)(menuItemContent, ".".concat(MENU_ITEM_CLASSNAME));
    };
    /**
     * Returns the menu item element with the given ID.
     *
     * @param {number|string} menuItemId The menu item's ID.
     * @return {HTMLElement|null}
     */

    exports.getFromContentElement = getFromContentElement;

    var getFromId = function getFromId(menuItemId) {
      return document.querySelector(".".concat(MENU_ITEM_CLASSNAME, "[data-site-navigation-menu-item-id=\"").concat(menuItemId, "\"]"));
    };
    /**
     * Returns the given menu item element's ID.
     *
     * @param {HTMLElement} menuItem The menu item
     * @return {number}
     */

    exports.getFromId = getFromId;

    var getId = function getId(menuItem) {
      return parseInt(menuItem.dataset.siteNavigationMenuItemId, 10) || 0;
    };
    /**
     * Returns the next menu item sibling of the given menu item element.
     *
     * @param {HTMLElement} menuItem The menu item.
     * @return {HTMLElement|null}
     */

    exports.getId = getId;

    var getNextSibling = function getNextSibling(menuItem) {
      (0, _metalDom.next)(menuItem, ".".concat(MENU_ITEM_CLASSNAME));
    };
    /**
     * Returns the menu item element's parent.
     *
     * @param {HTMLElement} menuItem The menu item.
     * @return {HTMLElement|null}
     */

    exports.getNextSibling = getNextSibling;

    var getParent = function getParent(menuItem) {
      return menuItem.parentElement;
    };
    /**
     * Returns the menu item element's siblings.
     *
     * @param {HTMLElement} menuItem The menu item.
     * @return {Array<HTMLElement>}
     */

    exports.getParent = getParent;

    var getSiblings = function getSiblings(menuItem) {
      var parentElement = menuItem.parentElement;
      var siblings = [];

      if (parentElement) {
        siblings = getChildren(parentElement);
      }

      return siblings;
    };
    /**
     * Returns <code>true</code> if the menu item is a child of the parent menu
     * item.
     *
     * @param {HTMLElement} menuItem The menu item to check.
     * @param {HTMLElement} parentMenuItem The parent menu item.
     * @return {boolean} Whether the menu item is a child of the parent menu item.
     */

    exports.getSiblings = getSiblings;

    var isChildOf = function isChildOf(menuItem, parentMenuItem) {
      return (0, _metalDom.contains)(parentMenuItem, menuItem);
    };
    /**
     * Returns <code>true</code> if the given HTML element is a menu item.
     * @param {HTMLElement} htmlElement The HTML element to check.
     * @return {boolean} Whether the HTML element is a menu item.
     */

    exports.isChildOf = isChildOf;

    var isMenuItem = function isMenuItem(htmlElement) {
      return (0, _metalDom.hasClass)(htmlElement, MENU_ITEM_CLASSNAME);
    };
    /**
     * Returns <code>true</code> if the given menu item element is selected.
     *
     * @param {HTMLElement} menuItem The menu item to check.
     * @return {boolean} Whether the menu item is selected.
     */

    exports.isMenuItem = isMenuItem;

    var isSelected = function isSelected(menuItem) {
      return (0, _metalDom.hasClass)(menuItem, MENU_ITEM_SELECTED_CLASSNAME);
    };
    /**
     * Mutates the given menu item element by changing it's status to
     * dragging or not dragging.
     * @param {HTMLElement} menuItem The menu item.
     */

    exports.isSelected = isSelected;

    var setDragging = function setDragging(menuItem) {
      var dragging = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      if (dragging) {
        (0, _metalDom.addClasses)(menuItem, MENU_ITEM_DRAGGING_CLASSNAME);
      } else {
        (0, _metalDom.removeClasses)(menuItem, MENU_ITEM_DRAGGING_CLASSNAME);
      }
    };
    /**
     * Mutates the given menu item by changing it's status to selected. Only a
     * single menu item can be selected, so any other selected menu item will be
     * unselected.
     *
     * @param {!HTMLElement} menuItem The menu item.
     */

    exports.setDragging = setDragging;

    var setSelected = function setSelected(menuItem) {
      unselectAll();
      (0, _metalDom.addClasses)(menuItem, MENU_ITEM_SELECTED_CLASSNAME);
    };
    /**
     * Mutates all selected menu items and sets their status to unselected.
     */

    exports.setSelected = setSelected;

    var unselectAll = function unselectAll() {
      var selectedMenuItem = (0, _metalDom.toElement)(".".concat(MENU_ITEM_SELECTED_CLASSNAME));

      if (selectedMenuItem) {
        (0, _metalDom.removeClasses)(selectedMenuItem, MENU_ITEM_SELECTED_CLASSNAME);
      }
    };

    exports.unselectAll = unselectAll;
    //# sourceMappingURL=SiteNavigationMenuItemDOMHandler.js.map
  }
});
//# sourceMappingURL=SiteNavigationMenuItemDOMHandler.js.map