Liferay.Loader.define("site-navigation-admin-web@3.0.14/js/SiteNavigationMenuEditor", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-drag-drop', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state', './SiteNavigationMenuDOMHandler', './SiteNavigationMenuItemDOMHandler'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.SiteNavigationMenuEditor = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalDragDrop = require("frontend-js-metal-web$metal-drag-drop");

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _metalState = _interopRequireWildcard(require("frontend-js-metal-web$metal-state"));

  var _SiteNavigationMenuDOMHandler = require("./SiteNavigationMenuDOMHandler");

  var _SiteNavigationMenuItemDOMHandler = require("./SiteNavigationMenuItemDOMHandler");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _get(target, property, receiver) {
    if (typeof Reflect !== "undefined" && Reflect.get) {
      _get = Reflect.get;
    } else {
      _get = function _get(target, property, receiver) {
        var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
          return desc.get.call(receiver);
        }return desc.value;
      };
    }return _get(target, property, receiver || target);
  }

  function _superPropBase(object, property) {
    while (!Object.prototype.hasOwnProperty.call(object, property)) {
      object = _getPrototypeOf(object);if (object === null) break;
    }return object;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * List of keys used for moving elements with the keyboard.
   */
  var KEYS = {
    ARROW_DOWN: 'ArrowDown',
    ARROW_LEFT: 'ArrowLeft',
    ARROW_RIGHT: 'ArrowRight',
    ARROW_UP: 'ArrowUp',
    ENTER: 'Enter',
    SPACEBAR: ' '
  };
  /**
   * Provides the Site Navigation Menu Editor.
   */

  var SiteNavigationMenuEditor =
  /*#__PURE__*/
  function (_State) {
    _inherits(SiteNavigationMenuEditor, _State);

    /**
     * @inheritDoc
     */
    function SiteNavigationMenuEditor(config) {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, SiteNavigationMenuEditor);

      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(SiteNavigationMenuEditor)).call.apply(_getPrototypeOf2, [this, config].concat(args)));
      var controlMenu = document.querySelector('.control-menu');
      _this._controlMenuHeight = controlMenu ? controlMenu.offsetHeight : 0;
      var managementBar = document.querySelector('.management-bar');
      _this._managementBarHeight = managementBar ? managementBar.offsetHeight : 0;

      _this.setState(config);

      _this._dragDrop = new _metalDragDrop.DragDrop({
        autoScroll: true,
        dragPlaceholder: _metalDragDrop.Drag.Placeholder.CLONE,
        handles: ".".concat(_SiteNavigationMenuItemDOMHandler.MENU_ITEM_DRAG_ICON_CLASSNAME),
        sources: ".".concat(_SiteNavigationMenuItemDOMHandler.MENU_ITEM_CLASSNAME),
        targets: ".".concat(_SiteNavigationMenuItemDOMHandler.MENU_ITEM_CLASSNAME)
      });

      _this._dragDrop.on(_metalDragDrop.DragDrop.Events.DRAG, _this._handleDragItem.bind(_assertThisInitialized(_this)));

      _this._dragDrop.on(_metalDragDrop.Drag.Events.START, _this._handleDragStart.bind(_assertThisInitialized(_this)));

      _this._dragDrop.on(_metalDragDrop.DragDrop.Events.END, _this._handleDropItem.bind(_assertThisInitialized(_this)));

      _this._itemClickHandler = _metalDom.dom.on(".".concat(_SiteNavigationMenuItemDOMHandler.MENU_ITEM_CONTENT_CLASSNAME), 'click', _this._handleItemClick.bind(_assertThisInitialized(_this)));
      _this._itemKeyUpHandler = _metalDom.dom.on(".".concat(_SiteNavigationMenuItemDOMHandler.MENU_ITEM_CLASSNAME), 'keyup', _this._handleItemKeyUp.bind(_assertThisInitialized(_this)));

      _this.on('selectedMenuItemChanged', _this._handleSelectedMenuItemChanged.bind(_assertThisInitialized(_this)));

      return _this;
    }
    /**
     * @inheritDoc
     */

    _createClass(SiteNavigationMenuEditor, [{
      key: "dispose",
      value: function dispose() {
        var _get2;

        if (this._dragDrop) {
          this._dragDrop.dispose();

          this._dragDrop = null;
        }

        if (this._itemClickHandler) {
          this._itemClickHandler.removeListener();

          this._itemClickHandler = null;
        }

        if (this._itemKeyUpHandler) {
          this._itemKeyUpHandler.removeListener();

          this._itemKeyUpHandler = null;
        }

        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        (_get2 = _get(_getPrototypeOf(SiteNavigationMenuEditor.prototype), "dispose", this)).call.apply(_get2, [this].concat(args));
      }
      /**
       * Handles the event when the user drags the item across the container.
       *
       * @param {!object} data The drag event data.
       * @private
       */

    }, {
      key: "_handleDragItem",
      value: function _handleDragItem(data) {
        var placeholderMenuItem = data.placeholder;
        var sourceMenuItem = data.source;
        var nearestMenuItem = (0, _SiteNavigationMenuDOMHandler.getNearestMenuItem)(sourceMenuItem, placeholderMenuItem);

        if (!this._draggedItemRegion) {
          this._draggedItemRegion = _metalPosition["default"].getRegion(placeholderMenuItem);
        }

        this._draggedItemRegion = _metalPosition["default"].getRegion(placeholderMenuItem);

        if (placeholderMenuItem && (0, _SiteNavigationMenuItemDOMHandler.isMenuItem)(placeholderMenuItem) && sourceMenuItem && (0, _SiteNavigationMenuItemDOMHandler.isMenuItem)(sourceMenuItem) && nearestMenuItem && (0, _SiteNavigationMenuItemDOMHandler.isMenuItem)(nearestMenuItem)) {
          var nested = (0, _SiteNavigationMenuDOMHandler.shouldBeNested)(placeholderMenuItem, nearestMenuItem);
          var over = (0, _SiteNavigationMenuDOMHandler.isOver)(placeholderMenuItem, nearestMenuItem);

          if (!over && nested) {
            (0, _SiteNavigationMenuDOMHandler.insertAtPosition)(nearestMenuItem, sourceMenuItem, 0);
          } else {
            var nearestMenuItemParent = (0, _SiteNavigationMenuItemDOMHandler.getParent)(nearestMenuItem);
            var nearestMenuItemIndex = (0, _SiteNavigationMenuItemDOMHandler.getChildren)(nearestMenuItemParent).indexOf(nearestMenuItem) + (over ? 0 : 1);
            (0, _SiteNavigationMenuDOMHandler.insertAtPosition)(nearestMenuItemParent, sourceMenuItem, nearestMenuItemIndex);
          }
        }
      }
      /**
       * Handles the event when the user starts to drag the item across the
       * container.
       *
       * @param {!object} data The drag event data.
       * @param {!Event} event The drag event.
       * @private
       */

    }, {
      key: "_handleDragStart",
      value: function _handleDragStart(data, event) {
        var menuItem = event.target.getActiveDrag();
        this.selectedMenuItem = menuItem;
        (0, _SiteNavigationMenuItemDOMHandler.setDragging)(menuItem, true);
      }
      /**
       * Handles the event when the user drops the item on the container.
       *
       * @param {!object} data The drop event data.
       * @param {!Event} event The drop event.
       * @private
       */

    }, {
      key: "_handleDropItem",
      value: function _handleDropItem(data, event) {
        event.preventDefault();
        var menuItem = data.source;
        var menuItemId = (0, _SiteNavigationMenuItemDOMHandler.getId)(menuItem);
        var menuItemIndex = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem).indexOf(menuItem);
        var menuItemParentId = (0, _SiteNavigationMenuItemDOMHandler.getId)((0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItem));
        this._draggedItemRegion = null;

        this._updateParentAndOrder({
          dragOrder: menuItemIndex,
          parentId: menuItemParentId,
          siteNavigationMenuItemId: menuItemId
        });

        (0, _SiteNavigationMenuItemDOMHandler.setDragging)(menuItem, false);
      }
      /**
       * Handles the event when the user clicks on a menu item.
       *
       * @param {!Event} event The click event data.
       * @private
       */

    }, {
      key: "_handleItemClick",
      value: function _handleItemClick(event) {
        var menuItem = (0, _SiteNavigationMenuItemDOMHandler.getFromContentElement)(event.delegateTarget);
        this.selectedMenuItem = menuItem;
      }
      /**
       * Handles the event when the user presses a key on a menu item.
       *
       * @param {!Event} event The key up event data.
       * @private
       */

    }, {
      key: "_handleItemKeyUp",
      value: function _handleItemKeyUp(event) {
        event.stopPropagation();
        var menuItem = event.delegateTarget;
        var menuItemIndex = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem).indexOf(menuItem);
        var menuItemParent = (0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItem);
        var layoutModified = false;

        if (event.key === KEYS.ENTER || event.key === KEYS.SPACEBAR) {
          this.selectedMenuItem = menuItem;
        } else if (event.key === KEYS.ARROW_LEFT) {
          var menuItemParentIndex = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItemParent).indexOf(menuItemParent);
          var menuItemGrandParent = (0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItemParent);

          if (menuItemParentIndex !== -1) {
            (0, _SiteNavigationMenuDOMHandler.insertAtPosition)(menuItemGrandParent, menuItem, menuItemParentIndex + 1);
          }

          layoutModified = true;
        } else if (event.key === KEYS.ARROW_UP && menuItemIndex > 0) {
          (0, _SiteNavigationMenuDOMHandler.insertAtPosition)(menuItemParent, menuItem, menuItemIndex - 1);
          layoutModified = true;
        } else if (event.key === KEYS.ARROW_RIGHT && menuItemIndex > 0) {
          var previousSibling = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem)[menuItemIndex - 1];
          (0, _SiteNavigationMenuDOMHandler.insertAtPosition)(previousSibling, menuItem, Infinity);
          layoutModified = true;
        } else if (event.key === KEYS.ARROW_DOWN) {
          (0, _SiteNavigationMenuDOMHandler.insertAtPosition)(menuItemParent, menuItem, menuItemIndex + 2);
          layoutModified = true;
        }

        if (layoutModified) {
          var siteNavigationMenuItemId = (0, _SiteNavigationMenuItemDOMHandler.getId)(menuItem);

          this._updateParentAndOrder({
            dragOrder: (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem).indexOf(menuItem),
            parentId: (0, _SiteNavigationMenuItemDOMHandler.getId)((0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItem)),
            siteNavigationMenuItemId: siteNavigationMenuItemId
          });

          requestAnimationFrame(function () {
            var modifiedMenuItem = (0, _SiteNavigationMenuItemDOMHandler.getFromId)(siteNavigationMenuItemId);
            modifiedMenuItem.focus();
          });
        }
      }
      /**
       * Handles the event when the selected menu item property changes.
       *
       * @param {{newVal: HTMLElement|null}} event
       * @private
       */

    }, {
      key: "_handleSelectedMenuItemChanged",
      value: function _handleSelectedMenuItemChanged(event) {
        (0, _SiteNavigationMenuItemDOMHandler.unselectAll)();

        if (event.newVal) {
          (0, _SiteNavigationMenuItemDOMHandler.setSelected)(event.newVal);
        }
      }
      /**
       * Sends layout information to the server and returns a promise that
       * resolves after finishing.
       *
       * @param {{
       *   dragOrder: !string,
       *   parentId: !string,
       *   siteNavigationMenuItemId: !string
       * }} data
       * @private
       * @return {Promise} The promise.
       */

    }, {
      key: "_updateParentAndOrder",
      value: function _updateParentAndOrder(data) {
        var formData = new FormData();
        formData.append("".concat(this.namespace, "siteNavigationMenuItemId"), data.siteNavigationMenuItemId);
        formData.append("".concat(this.namespace, "parentSiteNavigationMenuItemId"), data.parentId);
        formData.append("".concat(this.namespace, "order"), data.dragOrder);
        return (0, _frontendJsWeb.fetch)(this.editSiteNavigationMenuItemParentURL, {
          body: formData,
          method: 'POST'
        });
      }
    }]);

    return SiteNavigationMenuEditor;
  }(_metalState["default"]);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  exports.SiteNavigationMenuEditor = SiteNavigationMenuEditor;
  SiteNavigationMenuEditor.STATE = {
    /**
     * Control menu height.
     *
     * @default 0
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @private
     * @type {number}
     */
    _controlMenuHeight: _metalState.Config.number().internal().value(0),

    /**
     * @default -1
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @private
     * @type {number}
     */
    _currentYPosition: _metalState.Config.number().internal().value(-1),

    /**
     * Internal <code>DragDrop</code> instance.
     *
     * @default null
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @type {object|null}
     */
    _dragDrop: _metalState.Config.internal().value(null),

    /**
     * Dragged item.
     *
     * @default undefined
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @private
     * @type {HTMLElement|null}
     */
    _draggedItemRegion: _metalState.Config.object().internal(),

    /**
     * Management bar height.
     *
     * @default 0
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @private
     * @type {number}
     */
    _managementBarHeight: _metalState.Config.number().internal().value(0),

    /**
     * URL for the edit site navigation menu item parent action.
     *
     * @default undefined
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @type {!string}
     */
    editSiteNavigationMenuItemParentURL: _metalState.Config.string().required(),

    /**
     * Portlet namespace to use in the edit action.
     *
     * @default undefined
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @type {!string}
     */
    namespace: _metalState.Config.string().required(),

    /**
     * Selected menu item DOM element.
     *
     * @default null
     * @instance
     * @memberOf SiteNavigationMenuEditor
     * @type {HTMLElement}
     */
    selectedMenuItem: _metalState.Config.object().value(null)
  };
  var _default = SiteNavigationMenuEditor;
  exports["default"] = _default;
  //# sourceMappingURL=SiteNavigationMenuEditor.js.map
});
//# sourceMappingURL=SiteNavigationMenuEditor.js.map