Liferay.Loader.define("site-navigation-menu-web@1.0.6/js/SiteNavigationMenu.es", ['exports', 'metal-dom/src/all/dom', 'metal-position/src/all/position', './SiteNavigationMenuItem.es'], function (exports, _dom, _position, _SiteNavigationMenuItem) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.SiteNavigationMenu = undefined;

	var _position2 = _interopRequireDefault(_position);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	/**
  * Constant indicating how much a menuItem element should be moved
  * to the right in order to consider it nested to it's parent.
  */

	var NEST_THRESHOLD = 30;

	/**
  * Set of static functions for managing site navigation menu
  * querying and mutation.
  * @type {Object}
  */

	var SiteNavigationMenu = {

		/**
   * Gets the nearest menuItem element for the given originMenuItem
   * and placeholder.
   *
   * The placeholder is used for retrieving the reference position, and
   * the originMenuItem for checking that child elements are being avoided.
   *
   * @param {HTMLElement} originMenuItem
   * @param {HTMLElement} placeholder
   * @return {HTMLElement}
   */

		getNearestMenuItem: function getNearestMenuItem(originMenuItem, placeholder) {
			var container = (0, _dom.toElement)('.' + _SiteNavigationMenuItem.MENU_CONTAINER_CLASSNAME);
			var originMenuItemId = _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(originMenuItem);
			var originMenuItemRegion = _position2.default.getRegion(placeholder);

			return Array.prototype.slice.call(document.querySelectorAll('.' + _SiteNavigationMenuItem.MENU_ITEM_CLASSNAME)).filter(function (menuItem) {
				return (0, _dom.contains)(container, menuItem) && !(0, _dom.contains)(originMenuItem, menuItem) && _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(menuItem) !== originMenuItemId && !(0, _dom.hasClass)(menuItem, _SiteNavigationMenuItem.MENU_ITEM_DRAGGING_CLASSNAME);
			}).map(function (menuItem) {
				var menuItemRegion = _position2.default.getRegion(menuItem);

				var distance = Math.sqrt(Math.pow(originMenuItemRegion.left - menuItemRegion.left, 2) + Math.pow(originMenuItemRegion.top - menuItemRegion.top, 2));

				return {
					distance: distance,
					menuItem: menuItem,
					region: menuItemRegion
				};
			}).reduce(function (distanceA, distanceB) {
				return distanceA.distance < distanceB.distance ? distanceA : distanceB;
			}, {
				distance: Infinity,
				menuItem: null
			}).menuItem;
		},

		/**
   * Inserts the given menuItem as child of given parentMenuItem
   * at the given position.
   * @param {HTMLElement} parentMenuItem
   * @param {HTMLElement} menuItem
   * @param {number} position
   * @review
   */

		insertAtPosition: function insertAtPosition(parentMenuItem, menuItem, position) {
			var children = _SiteNavigationMenuItem.SiteNavigationMenuItem.getChildren(parentMenuItem);

			if (position >= children.length) {
				parentMenuItem.appendChild(menuItem);
			} else {
				parentMenuItem.insertBefore(menuItem, children[position]);
			}
		},

		/**
   * Insert the given menuItem at the top of the navigation tree
   * @param {HTMLElement} menuItem
   */

		insertAtTop: function insertAtTop(menuItem) {
			var container = (0, _dom.toElement)('.' + _SiteNavigationMenuItem.MENU_CONTAINER_CLASSNAME);

			var children = _SiteNavigationMenuItem.SiteNavigationMenuItem.getChildren(container);

			if (children.length) {
				container.insertBefore(menuItem, children[0]);
			} else {
				container.appendChild(menuItem);
			}
		},

		/**
   * Returns true if the first menuItem element is over
   * the second menuItem element.
   * @param {HTMLElement} menuItemA
   * @param {HTMLElement} menuItemB
   * @return {boolean}
   */

		isOver: function isOver(menuItemA, menuItemB) {
			var menuItemARegion = _position2.default.getRegion(menuItemA);
			var menuItemBRegion = _position2.default.getRegion(menuItemB);

			return menuItemARegion.top < menuItemBRegion.top;
		},

		/**
   * Returns true if the given menuItem element should be nested
   * inside the given parentMenuItem element by checking their positions.
   * @param {HTMLElement} menuItem
   * @param {HTMLElement} parentMenuItem
   * @return {boolean}
   */

		shouldBeNested: function shouldBeNested(menuItem, parentMenuItem) {
			var nested = false;

			if (_SiteNavigationMenuItem.SiteNavigationMenuItem.isMenuItem(parentMenuItem)) {
				var menuItemRegion = _position2.default.getRegion(menuItem);
				var parentMenuItemRegion = _position2.default.getRegion(parentMenuItem);

				var nestedInParent = menuItemRegion.left > parentMenuItemRegion.left + NEST_THRESHOLD;

				var parentWithChildren = _SiteNavigationMenuItem.SiteNavigationMenuItem.getChildren(parentMenuItem).filter(function (childMenuItem) {
					return _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(childMenuItem) !== _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(menuItem);
				}).length > 0;

				nested = nestedInParent || parentWithChildren;
			}

			return nested;
		}
	};

	exports.SiteNavigationMenu = SiteNavigationMenu;
	exports.default = SiteNavigationMenu;
});
//# sourceMappingURL=SiteNavigationMenu.es.js.map
