Liferay.Loader.define("site-navigation-menu-web@1.0.21/metal-throttle/src/throttle", ['exports'], function (exports) {
	'use strict';

	/**
  * Debounces function execution.
  * @param {!function()} fn
  * @param {number} [delay=0]
  * @return {!function()}
  */

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	function throttle(fn) {
		var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

		var last = 0;

		return function () {
			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var next = last + delay;
			var now = Date.now();

			if (next < now) {
				try {
					fn.call.apply(fn, [null].concat(args));
				} catch (error) {
					throw error;
				} finally {
					last = Date.now();
				}
			}
		};
	}

	exports.default = throttle;
	exports.throttle = throttle;
});
//# sourceMappingURL=throttle.js.map
