/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.admin.web.internal.handler;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.site.navigation.exception.DuplicateSiteNavigationMenuException;
import com.liferay.site.navigation.exception.SiteNavigationMenuNameException;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={SiteNavigationMenuExceptionRequestHandler.class})
public class SiteNavigationMenuExceptionRequestHandler {
    public void handlePortalException(ActionRequest actionRequest, ActionResponse actionResponse, PortalException pe) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        String errorMessage = "an-unexpected-error-occurred";
        if (pe instanceof DuplicateSiteNavigationMenuException) {
            errorMessage = "please-enter-a-unique-name";
        } else if (pe instanceof SiteNavigationMenuNameException) {
            errorMessage = "please-enter-a-valid-name";
        }
        jsonObject.put("error", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)errorMessage));
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }
}

