/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.navigation.admin.web.internal.security.permission.resource.SiteNavigationPermission;
import com.liferay.site.navigation.admin.web.internal.util.SiteNavigationMenuPortletUtil;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalServiceUtil;
import com.liferay.site.navigation.service.SiteNavigationMenuServiceUtil;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class SiteNavigationAdminDisplayContext {
    private String _displayStyle;
    private String _keywords;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _orderByCol;
    private String _orderByType;
    private final HttpServletRequest _request;
    private SearchContainer _searchContainer;
    private Long _siteNavigationMenuId;
    private final SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;
    private String _siteNavigationMenuName;

    public SiteNavigationAdminDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = request;
        this._siteNavigationMenuItemTypeRegistry = (SiteNavigationMenuItemTypeRegistry)this._request.getAttribute("SITE_NAVIGATION_MENU_ITEM_TYPE_REGISTRY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSelectedSiteNavigationMenus");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteNavigationAdminDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public List<DropdownItem> getAddSiteNavigationMenuItemDropdownItems() {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new DropdownItemList(){
            {
                for (SiteNavigationMenuItemType siteNavigationMenuItemType : SiteNavigationAdminDisplayContext.this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemTypes()) {
                    this.add(dropdownItem -> {
                        dropdownItem.setHref((Object)SiteNavigationAdminDisplayContext.this._getAddURL(siteNavigationMenuItemType));
                        dropdownItem.setLabel(siteNavigationMenuItemType.getLabel(themeDisplay.getLocale()));
                    });
                }
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String[] getDisplayViews() {
        return new String[]{"list", "icon", "descriptive"};
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SiteNavigationAdminDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteNavigationAdminDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SiteNavigationAdminDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteNavigationAdminDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getKeywords() {
        if (Validator.isNotNull((String)this._keywords)) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        return this._keywords;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"create-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        String displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle");
        if (Validator.isNotNull((String)displayStyle)) {
            portletURL.setParameter("displayStyle", this.getDisplayStyle());
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public SiteNavigationMenu getPrimarySiteNavigationMenu() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return SiteNavigationMenuLocalServiceUtil.fetchPrimarySiteNavigationMenu((long)themeDisplay.getScopeGroupId());
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public SearchContainer getSearchContainer() {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this.getPortletURL(), null, "there-are-no-navigation-menus");
        OrderByComparator<SiteNavigationMenu> orderByComparator = SiteNavigationMenuPortletUtil.getOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        searchContainer.setOrderByCol(this.getOrderByCol());
        searchContainer.setOrderByComparator(orderByComparator);
        searchContainer.setOrderByType(this.getOrderByType());
        EmptyOnClickRowChecker emptyOnClickRowChecker = new EmptyOnClickRowChecker((PortletResponse)this._liferayPortletResponse);
        searchContainer.setRowChecker((RowChecker)emptyOnClickRowChecker);
        List menus = null;
        int menusCount = 0;
        if (Validator.isNotNull((String)this.getKeywords())) {
            menus = SiteNavigationMenuServiceUtil.getSiteNavigationMenus((long)themeDisplay.getScopeGroupId(), (String)this.getKeywords(), (int)searchContainer.getStart(), (int)searchContainer.getEnd(), orderByComparator);
            menusCount = SiteNavigationMenuServiceUtil.getSiteNavigationMenusCount((long)themeDisplay.getScopeGroupId(), (String)this.getKeywords());
        } else {
            menus = SiteNavigationMenuServiceUtil.getSiteNavigationMenus((long)themeDisplay.getScopeGroupId(), (int)searchContainer.getStart(), (int)searchContainer.getEnd(), orderByComparator);
            menusCount = SiteNavigationMenuServiceUtil.getSiteNavigationMenusCount((long)themeDisplay.getScopeGroupId());
        }
        searchContainer.setResults(menus);
        searchContainer.setTotal(menusCount);
        this._searchContainer = searchContainer;
        return this._searchContainer;
    }

    public SiteNavigationMenu getSiteNavigationMenu() throws PortalException {
        if (this.getSiteNavigationMenuId() == 0L) {
            return null;
        }
        return SiteNavigationMenuServiceUtil.fetchSiteNavigationMenu((long)this.getSiteNavigationMenuId());
    }

    public long getSiteNavigationMenuId() {
        if (this._siteNavigationMenuId != null) {
            return this._siteNavigationMenuId;
        }
        this._siteNavigationMenuId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"siteNavigationMenuId");
        return this._siteNavigationMenuId;
    }

    public SiteNavigationMenuItemTypeRegistry getSiteNavigationMenuItemTypeRegistry() {
        return this._siteNavigationMenuItemTypeRegistry;
    }

    public String getSiteNavigationMenuName() throws PortalException {
        if (this._siteNavigationMenuName != null) {
            return this._siteNavigationMenuName;
        }
        SiteNavigationMenu siteNavigationMenu = this.getSiteNavigationMenu();
        this._siteNavigationMenuName = siteNavigationMenu.getName();
        return this._siteNavigationMenuName;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() {
        SearchContainer searchContainer = this.getSearchContainer();
        return searchContainer.getTotal();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean hasEditPermission() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        return !stagingGroupHelper.isLocalLiveGroup(group) && !stagingGroupHelper.isRemoteLiveGroup(group) || !group.isStagedPortlet("com_liferay_site_navigation_admin_web_portlet_SiteNavigationAdminPortlet");
    }

    public boolean isShowAddButton() {
        if (!this.hasEditPermission()) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return SiteNavigationPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getSiteGroupId(), "ADD_SITE_NAVIGATION_MENU");
    }

    private String _getAddURL(SiteNavigationMenuItemType siteNavigationMenuItemType) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        PortletURL addURL = this._liferayPortletResponse.createRenderURL();
        addURL.setParameter("mvcPath", "/add_site_navigation_menu_item.jsp");
        PortletURL addSiteNavigationMenuItemRedirectURL = this._liferayPortletResponse.createRenderURL();
        addSiteNavigationMenuItemRedirectURL.setParameter("mvcPath", "/add_site_navigation_menu_item_redirect.jsp");
        addSiteNavigationMenuItemRedirectURL.setParameter("portletResource", portletDisplay.getId());
        addURL.setParameter("redirect", addSiteNavigationMenuItemRedirectURL.toString());
        addURL.setParameter("siteNavigationMenuId", String.valueOf(this.getSiteNavigationMenuId()));
        addURL.setParameter("type", siteNavigationMenuItemType.getType());
        try {
            addURL.setWindowState(LiferayWindowState.POP_UP);
        }
        catch (WindowStateException wse) {
            return "";
        }
        return addURL.toString();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)SiteNavigationAdminDisplayContext.this.getPortletURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteNavigationAdminDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SiteNavigationAdminDisplayContext.this.getOrderByCol(), "create-date"));
                    dropdownItem.setHref(SiteNavigationAdminDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "create-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteNavigationAdminDisplayContext.this._request, (String)"create-date"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SiteNavigationAdminDisplayContext.this.getOrderByCol(), "name"));
                    dropdownItem.setHref(SiteNavigationAdminDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteNavigationAdminDisplayContext.this._request, (String)"name"));
                });
            }
        };
    }
}

