/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.testray.dispatch.task.executor.internal.dispatch.executor;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.liferay.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(property={"dispatch.task.executor.cluster.mode=single-node", "dispatch.task.executor.feature.flag=LPS-163118", "dispatch.task.executor.name=testray", "dispatch.task.executor.overlapping=false", "dispatch.task.executor.type=testray"}, service={DispatchTaskExecutor.class})
public class SiteInitializerTestrayDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    private static final String _TESTRAY_BUILD_STATUS_ACTIVE = "ACTIVE";
    private static final String _TESTRAY_CASE_RESULT_STATUS_BLOCKED = "BLOCKED";
    private static final String _TESTRAY_CASE_RESULT_STATUS_DID_NOT_RUN = "DIDNOTRUN";
    private static final String _TESTRAY_CASE_RESULT_STATUS_FAILED = "FAILED";
    private static final String _TESTRAY_CASE_RESULT_STATUS_IN_PROGRESS = "INPROGRESS";
    private static final String _TESTRAY_CASE_RESULT_STATUS_PASSED = "PASSED";
    private static final String _TESTRAY_CASE_RESULT_STATUS_TEST_FIX = "TESTFIX";
    private static final String _TESTRAY_CASE_RESULT_STATUS_UNTESTED = "UNTESTED";
    private static final int _TESTRAY_RUN_EXTERNAL_REFERENCE_TYPE_POSHI = 1;
    private static final Log _log = LogFactoryUtil.getLog(SiteInitializerTestrayDispatchTaskExecutor.class);
    private DefaultDTOConverterContext _defaultDTOConverterContext;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final Map<String, ObjectDefinition> _objectDefinitions = new HashMap<String, ObjectDefinition>();
    private final Map<String, Long> _objectEntryIds = new HashMap<String, Long>();
    @Reference(target="(object.entry.manager.storage.type=default)")
    private ObjectEntryManager _objectEntryManager;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws Exception {
        UnicodeProperties unicodeProperties = dispatchTrigger.getDispatchTaskSettingsUnicodeProperties();
        if (Validator.isNull((String)unicodeProperties.getProperty("s3APIKey")) || Validator.isNull((String)unicodeProperties.getProperty("s3BucketName")) || Validator.isNull((String)unicodeProperties.getProperty("s3ErroredFolderName")) || Validator.isNull((String)unicodeProperties.getProperty("s3InboxFolderName")) || Validator.isNull((String)unicodeProperties.getProperty("s3ProcessedFolderName"))) {
            _log.error((Object)"The required properties are not set");
            return;
        }
        User user = this._userLocalService.getUser(dispatchTrigger.getUserId());
        this._defaultDTOConverterContext = new DefaultDTOConverterContext(false, null, null, null, null, LocaleUtil.getSiteDefault(), null, user);
        PermissionChecker originalPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
        String originalName = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        try {
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._load(dispatchTrigger.getCompanyId())));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._uploadToTestray(dispatchTrigger.getCompanyId(), unicodeProperties)));
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)originalPermissionChecker);
            PrincipalThreadLocal.setName((String)originalName);
        }
    }

    public String getName() {
        return "testray";
    }

    private ObjectEntry _addObjectEntry(String objectDefinitionShortName, Map<String, Object> properties) throws Exception {
        ObjectDefinition objectDefinition = this._getObjectDefinition(objectDefinitionShortName);
        ObjectEntry objectEntry = new ObjectEntry();
        objectEntry.setProperties(properties);
        return this._objectEntryManager.addObjectEntry((DTOConverterContext)this._defaultDTOConverterContext, objectDefinition, objectEntry, null);
    }

    private JSONArray _addTestrayAttachments(Node testcaseNode) throws Exception {
        JSONArray jsonArray = null;
        Element testcaseElement = (Element)testcaseNode;
        NodeList attachmentsNodeList = testcaseElement.getElementsByTagName("attachments");
        for (int i = 0; i < attachmentsNodeList.getLength(); ++i) {
            Node attachmentsNode = attachmentsNodeList.item(i);
            if (attachmentsNode.getNodeType() != 1) continue;
            Element attachmentsElement = (Element)attachmentsNode;
            NodeList fileNodeList = attachmentsElement.getElementsByTagName("file");
            for (int j = 0; j < fileNodeList.getLength(); ++j) {
                Node fileNode = fileNodeList.item(j);
                if (fileNode.getNodeType() != 1) continue;
                Element fileElement = (Element)fileNode;
                jsonArray = JSONUtil.put((Object)JSONUtil.put((String)"name", (Object)fileElement.getAttribute("name")).put("url", fileElement.getAttribute("url")).put("value", fileElement.getAttribute("value")));
            }
        }
        return jsonArray;
    }

    private void _addTestrayCase(long companyId, Node testcaseNode, long testrayBuildId, String testrayBuildTime, Map<String, Object> testrayCasePropertiesMap, long testrayProjectId, long testrayRunId) throws Exception {
        String testrayCaseName = (String)testrayCasePropertiesMap.get("testray.testcase.name");
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Case#", testrayCaseName, "#ProjectId#", testrayProjectId});
        long testrayCaseId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayCaseName, "'"}), "Case", objectEntryIdsKey);
        long testrayTeamId = this._getTestrayTeamId(companyId, testrayProjectId, (String)testrayCasePropertiesMap.get("testray.team.name"));
        long testrayComponentId = this._getTestrayComponentId(companyId, (String)testrayCasePropertiesMap.get("testray.main.component.name"), testrayProjectId, testrayTeamId);
        if (testrayCaseId == 0L) {
            ObjectEntry objectEntry = this._addObjectEntry("Case", HashMapBuilder.put((Object)"caseNumber", (Object)this._increment(companyId, "caseNumber", "projectId eq '" + testrayProjectId + "'", "Case")).put((Object)"description", testrayCasePropertiesMap.get("testray.testcase.description")).put((Object)"name", (Object)((String)testrayCasePropertiesMap.get("testray.testcase.name"))).put((Object)"priority", testrayCasePropertiesMap.get("testray.testcase.priority")).put((Object)"r_caseTypeToCases_c_caseTypeId", (Object)this._getTestrayCaseTypeId(companyId, (String)testrayCasePropertiesMap.get("testray.case.type.name"))).put((Object)"r_componentToCases_c_componentId", (Object)testrayComponentId).put((Object)"r_projectToCases_c_projectId", (Object)testrayProjectId).build());
            testrayCaseId = objectEntry.getId();
            this._objectEntryIds.put(objectEntryIdsKey, testrayCaseId);
        }
        long testrayCaseResultId = this._getTestrayCaseResultId(testcaseNode, testrayBuildId, testrayBuildTime, testrayCaseId, testrayCasePropertiesMap, testrayComponentId, testrayRunId);
        this._addTestrayCaseResultIssue(companyId, testrayCaseResultId, (String)testrayCasePropertiesMap.get("testray.case.defect"));
        this._addTestrayCaseResultIssue(companyId, testrayCaseResultId, (String)testrayCasePropertiesMap.get("testray.case.issue"));
    }

    private void _addTestrayCaseResultIssue(long companyId, long testrayCaseResultId, String testrayIssueName) throws Exception {
        String objectEntryIdsKey = "Issue#" + testrayIssueName;
        if (this._isEmpty(testrayIssueName)) {
            return;
        }
        this._addObjectEntry("CaseResultsIssues", HashMapBuilder.put((Object)"r_caseResultToCaseResultsIssues_c_caseResultId", (Object)testrayCaseResultId).put((Object)"r_issueToCaseResultsIssues_c_issueId", () -> {
            long testrayIssueId = this._getObjectEntryId(companyId, "name eq '" + testrayIssueName + "'", "Issue", objectEntryIdsKey);
            if (testrayIssueId > 0L) {
                return testrayIssueId;
            }
            testrayIssueId = this._addTestrayIssue(testrayIssueName);
            this._objectEntryIds.put(objectEntryIdsKey, testrayIssueId);
            return testrayIssueId;
        }).build());
    }

    private void _addTestrayCases(long companyId, Element element, long testrayBuildId, String testrayBuildTime, long testrayProjectId, long testrayRunId) throws Exception {
        NodeList testCaseNodeList = element.getElementsByTagName("testcase");
        for (int i = 0; i < testCaseNodeList.getLength(); ++i) {
            Node testcaseNode = testCaseNodeList.item(i);
            Map<String, Object> testrayCasePropertiesMap = this._getTestrayCaseProperties((Element)testcaseNode);
            this._addTestrayCase(companyId, testcaseNode, testrayBuildId, testrayBuildTime, testrayCasePropertiesMap, testrayProjectId, testrayRunId);
        }
    }

    private void _addTestrayFactor(long testrayFactorCategoryId, String testrayFactorCategoryName, long testrayFactorOptionId, String testrayFactorOptionName, long testrayRunId) throws Exception {
        this._addObjectEntry("Factor", HashMapBuilder.put((Object)"r_factorCategoryToFactors_c_factorCategoryId", (Object)testrayFactorCategoryId).put((Object)"r_factorOptionToFactors_c_factorOptionId", (Object)testrayFactorOptionId).put((Object)"r_runToFactors_c_runId", (Object)testrayRunId).put((Object)"testrayFactorCategoryName", (Object)testrayFactorCategoryName).put((Object)"testrayFactorOptionName", (Object)testrayFactorOptionName).build());
    }

    private long _addTestrayIssue(String testrayIssueName) throws Exception {
        ObjectEntry objectEntry = this._addObjectEntry("Issue", HashMapBuilder.put((Object)"name", (Object)testrayIssueName).build());
        return objectEntry.getId();
    }

    private void _autofill(long companyId, ObjectEntry testrayCaseResultObjectEntry1, ObjectEntry testrayCaseResultObjectEntry2) throws Exception {
        ObjectEntry destinationTestrayCaseResultObjectEntry = null;
        ObjectEntry sourceTestrayCaseResultObjectEntry = null;
        List sourceTestrayCaseResultsIssuesObjectEntries = null;
        com.liferay.portal.vulcan.pagination.Page testrayCaseResultsIssuesObjectEntriesPage1 = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get("CaseResultsIssues"), null, null, (DTOConverterContext)this._defaultDTOConverterContext, "caseResultId eq '" + testrayCaseResultObjectEntry1.getId() + "'", null, null, null);
        List testrayCaseResultsIssuesObjectEntries1 = (List)testrayCaseResultsIssuesObjectEntriesPage1.getItems();
        com.liferay.portal.vulcan.pagination.Page testrayCaseResultsIssuesObjectEntriesPage2 = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get("CaseResultsIssues"), null, null, (DTOConverterContext)this._defaultDTOConverterContext, "caseResultId eq '" + testrayCaseResultObjectEntry2.getId() + "'", null, null, null);
        List testrayCaseResultsIssuesObjectEntries2 = (List)testrayCaseResultsIssuesObjectEntriesPage2.getItems();
        if ((Long)this._getProperty("r_userToCaseResults_userId", testrayCaseResultObjectEntry1) > 0L && !testrayCaseResultsIssuesObjectEntries1.isEmpty() && (Long)this._getProperty("r_userToCaseResults_userId", testrayCaseResultObjectEntry2) <= 0L && testrayCaseResultsIssuesObjectEntries2.isEmpty()) {
            destinationTestrayCaseResultObjectEntry = testrayCaseResultObjectEntry2;
            sourceTestrayCaseResultObjectEntry = testrayCaseResultObjectEntry1;
            sourceTestrayCaseResultsIssuesObjectEntries = testrayCaseResultsIssuesObjectEntries1;
        } else if ((Long)this._getProperty("r_userToCaseResults_userId", testrayCaseResultObjectEntry1) <= 0L && testrayCaseResultsIssuesObjectEntries1.isEmpty() && (Long)this._getProperty("r_userToCaseResults_userId", testrayCaseResultObjectEntry2) > 0L && !testrayCaseResultsIssuesObjectEntries2.isEmpty()) {
            destinationTestrayCaseResultObjectEntry = testrayCaseResultObjectEntry1;
            sourceTestrayCaseResultObjectEntry = testrayCaseResultObjectEntry2;
            sourceTestrayCaseResultsIssuesObjectEntries = testrayCaseResultsIssuesObjectEntries2;
        }
        if (destinationTestrayCaseResultObjectEntry == null || sourceTestrayCaseResultObjectEntry == null) {
            return;
        }
        Map properties = destinationTestrayCaseResultObjectEntry.getProperties();
        properties.put("dueStatus", this._getProperty("dueStatus", sourceTestrayCaseResultObjectEntry));
        properties.put("r_userToCaseResults_userId", this._getProperty("r_userToCaseResults_userId", sourceTestrayCaseResultObjectEntry));
        this._objectEntryManager.updateObjectEntry((DTOConverterContext)this._defaultDTOConverterContext, this._objectDefinitions.get("CaseResult"), destinationTestrayCaseResultObjectEntry.getId().longValue(), destinationTestrayCaseResultObjectEntry);
        for (ObjectEntry sourceTestrayCaseResultsIssuesObjectEntry : sourceTestrayCaseResultsIssuesObjectEntries) {
            String testrayIssueId = String.valueOf(this._getProperty("r_issueToCaseResultsIssues_c_issueId", sourceTestrayCaseResultsIssuesObjectEntry));
            com.liferay.portal.vulcan.pagination.Page testrayIssueObjectEntriesPage = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get("Issue"), null, null, (DTOConverterContext)this._defaultDTOConverterContext, "id eq '" + testrayIssueId + "'", null, null, null);
            ObjectEntry testrayIssueObjectEntry = (ObjectEntry)testrayIssueObjectEntriesPage.fetchFirstItem();
            if (testrayIssueObjectEntry == null) continue;
            this._addTestrayCaseResultIssue(companyId, destinationTestrayCaseResultObjectEntry.getId(), (String)this._getProperty("name", testrayIssueObjectEntry));
        }
    }

    private ObjectEntry _fetchLatestTestrayRunObjectEntry(long companyId, String environmentHash, long testrayRoutineId, long testrayRunId) throws Exception {
        com.liferay.portal.vulcan.pagination.Page testrayBuildsObjectEntriesPage = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get("Build"), null, null, (DTOConverterContext)this._defaultDTOConverterContext, "routineId eq '" + testrayRoutineId + "'", null, null, null);
        List testrayBuildsObjectEntries = (List)testrayBuildsObjectEntriesPage.getItems();
        com.liferay.portal.vulcan.pagination.Page testrayRunsObjectEntriesPage = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get("Run"), null, null, (DTOConverterContext)this._defaultDTOConverterContext, StringBundler.concat((Object[])new Object[]{"environmentHash eq '", environmentHash, "' and id ne '", testrayRunId, "'"}), null, null, new Sort[]{new Sort("createDate", 3, true)});
        List testrayRunsObjectEntries = (List)testrayRunsObjectEntriesPage.getItems();
        for (ObjectEntry testrayRunObjectEntry : testrayRunsObjectEntries) {
            for (ObjectEntry testrayBuildObjectEntry : testrayBuildsObjectEntries) {
                if (!Objects.equals(testrayBuildObjectEntry.getId(), this._getProperty("r_buildToRuns_c_buildId", testrayRunObjectEntry))) continue;
                return testrayRunObjectEntry;
            }
        }
        return null;
    }

    private String _getAttributeValue(String attributeName, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node attributeNode = namedNodeMap.getNamedItem(attributeName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getTextContent();
    }

    private ObjectDefinition _getObjectDefinition(String objectDefinitionShortName) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitions.get(objectDefinitionShortName);
        if (objectDefinition == null) {
            throw new PortalException("No object definition found with short name " + objectDefinitionShortName);
        }
        return objectDefinition;
    }

    private List<ObjectEntry> _getObjectEntries(long companyId, String objectDefinitionShortName) throws Exception {
        com.liferay.portal.vulcan.pagination.Page objectEntriesPage = this._objectEntryManager.getObjectEntries(companyId, this._getObjectDefinition(objectDefinitionShortName), null, null, (DTOConverterContext)this._defaultDTOConverterContext, (Filter)null, null, null, null);
        return (List)objectEntriesPage.getItems();
    }

    private long _getObjectEntryId(long companyId, String filterString, String objectDefinitionShortName, String objectEntryIdsKey) throws Exception {
        Long objectEntryId = this._objectEntryIds.get(objectEntryIdsKey);
        if (objectEntryId != null) {
            return objectEntryId;
        }
        com.liferay.portal.vulcan.pagination.Page objectEntriesPage = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get(objectDefinitionShortName), null, null, (DTOConverterContext)this._defaultDTOConverterContext, filterString, null, null, null);
        ObjectEntry objectEntry = (ObjectEntry)objectEntriesPage.fetchFirstItem();
        if (objectEntry == null) {
            return 0L;
        }
        return objectEntry.getId();
    }

    private Map<String, String> _getPropertiesMap(Element element) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList propertiesNodeList = element.getElementsByTagName("properties");
        Node propertiesNode = propertiesNodeList.item(0);
        Element propertiesElement = (Element)propertiesNode;
        NodeList propertyNodeList = propertiesElement.getElementsByTagName("property");
        for (int i = 0; i < propertyNodeList.getLength(); ++i) {
            Node propertyNode = propertyNodeList.item(i);
            if (!propertyNode.hasAttributes()) continue;
            map.put(this._getAttributeValue("name", propertyNode), this._getAttributeValue("value", propertyNode));
        }
        return map;
    }

    private Object _getProperty(String key, ObjectEntry objectEntry) {
        Map properties = objectEntry.getProperties();
        return properties.get(key);
    }

    private String _getTestrayBuildDescription(Map<String, String> propertiesMap) {
        StringBundler sb = new StringBundler(15);
        if (propertiesMap.get("liferay.portal.bundle") != null) {
            sb.append("Bundle: ");
            sb.append(propertiesMap.get("liferay.portal.bundle"));
            sb.append(";");
            sb.append("\n");
        }
        if (propertiesMap.get("liferay.plugins.git.id") != null) {
            sb.append("Plugins hash: ");
            sb.append(propertiesMap.get("liferay.plugins.git.id"));
            sb.append(";");
            sb.append("\n");
        }
        if (propertiesMap.get("liferay.portal.branch") != null) {
            sb.append("Portal branch: ");
            sb.append(propertiesMap.get("liferay.portal.branch"));
            sb.append(";");
            sb.append("\n");
        }
        if (propertiesMap.get("liferay.portal.git.id") != null) {
            sb.append("Portal hash: ");
            sb.append(propertiesMap.get("liferay.portal.git.id"));
            sb.append(";");
        }
        return sb.toString();
    }

    private long _getTestrayBuildId(long companyId, Map<String, String> propertiesMap, String testrayBuildName, long testrayProjectId, long testrayRoutineId) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Build#", testrayBuildName, "#ProjectId#", testrayProjectId});
        long testrayBuildId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayBuildName, "'"}), "Build", objectEntryIdsKey);
        if (testrayBuildId != 0L) {
            return testrayBuildId;
        }
        long testrayProductVersionId = this._getTestrayProductVersionId(companyId, propertiesMap.get("testray.product.version"), testrayProjectId);
        ObjectEntry objectEntry = this._addObjectEntry("Build", HashMapBuilder.put((Object)"description", (Object)this._getTestrayBuildDescription(propertiesMap)).put((Object)"dueDate", (Object)propertiesMap.get("testray.build.time")).put((Object)"dueStatus", (Object)_TESTRAY_BUILD_STATUS_ACTIVE).put((Object)"gitHash", (Object)propertiesMap.get("git.id")).put((Object)"githubCompareURLs", (Object)propertiesMap.get("liferay.compare.urls")).put((Object)"name", (Object)testrayBuildName).put((Object)"r_productVersionToBuilds_c_productVersionId", (Object)testrayProductVersionId).put((Object)"r_projectToBuilds_c_projectId", (Object)testrayProjectId).put((Object)"r_routineToBuilds_c_routineId", (Object)testrayRoutineId).build());
        testrayBuildId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayBuildId);
        return testrayBuildId;
    }

    private Map<String, Object> _getTestrayCaseProperties(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NodeList propertiesNodeList = element.getElementsByTagName("properties");
        Node propertiesNode = propertiesNodeList.item(0);
        Element propertiesElement = (Element)propertiesNode;
        NodeList propertyNodeList = propertiesElement.getElementsByTagName("property");
        for (int i = 0; i < propertyNodeList.getLength(); ++i) {
            Node propertyNode = propertyNodeList.item(i);
            if (!propertyNode.hasAttributes()) continue;
            map.put(this._getAttributeValue("name", propertyNode), this._getAttributeValue("value", propertyNode));
        }
        return map;
    }

    private long _getTestrayCaseResultId(Node testcaseNode, long testrayBuildId, String testrayBuildTime, long testrayCaseId, Map<String, Object> testrayCasePropertiesMap, long testrayComponentId, long testrayRunId) throws Exception {
        String message;
        HashMap properties = HashMapBuilder.put((Object)"attachments", (Object)this._addTestrayAttachments(testcaseNode)).put((Object)"closedDate", (Object)testrayBuildTime).put((Object)"dueStatus", () -> {
            String testrayTestcaseStatus = (String)testrayCasePropertiesMap.get("testray.testcase.status");
            if (testrayTestcaseStatus.equals("blocked")) {
                return _TESTRAY_CASE_RESULT_STATUS_BLOCKED;
            }
            if (testrayTestcaseStatus.equals("dnr")) {
                return _TESTRAY_CASE_RESULT_STATUS_DID_NOT_RUN;
            }
            if (testrayTestcaseStatus.equals("failed")) {
                return _TESTRAY_CASE_RESULT_STATUS_FAILED;
            }
            if (testrayTestcaseStatus.equals("in-progress")) {
                return _TESTRAY_CASE_RESULT_STATUS_IN_PROGRESS;
            }
            if (testrayTestcaseStatus.equals("passed")) {
                return _TESTRAY_CASE_RESULT_STATUS_PASSED;
            }
            if (testrayTestcaseStatus.equals("test-fix")) {
                return _TESTRAY_CASE_RESULT_STATUS_TEST_FIX;
            }
            return _TESTRAY_CASE_RESULT_STATUS_UNTESTED;
        }).put((Object)"r_buildToCaseResult_c_buildId", (Object)testrayBuildId).put((Object)"r_caseToCaseResult_c_caseId", (Object)testrayCaseId).put((Object)"r_componentToCaseResult_c_componentId", (Object)testrayComponentId).put((Object)"r_runToCaseResult_c_runId", (Object)testrayRunId).put((Object)"startDate", (Object)testrayBuildTime).put((Object)"warnings", (Object)((Integer)testrayCasePropertiesMap.get("testray.testcase.warnings"))).build();
        Element element = (Element)testcaseNode;
        NodeList nodeList = element.getElementsByTagName("failure");
        Node failureNode = nodeList.item(0);
        if (failureNode != null && !(message = this._getAttributeValue("message", failureNode)).isEmpty()) {
            properties.put("errors", message);
        }
        ObjectEntry objectEntry = this._addObjectEntry("CaseResult", properties);
        return objectEntry.getId();
    }

    private Map<Long, ObjectEntry> _getTestrayCaseResultObjectEntries(long companyId, ObjectEntry testrayRunObjectEntry) throws Exception {
        HashMap<Long, ObjectEntry> testrayCaseResultObjectEntries = new HashMap<Long, ObjectEntry>();
        com.liferay.portal.vulcan.pagination.Page page = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get("CaseResult"), null, null, (DTOConverterContext)this._defaultDTOConverterContext, "runId eq '" + testrayRunObjectEntry.getId() + "'", null, null, null);
        for (ObjectEntry objectEntry : page.getItems()) {
            testrayCaseResultObjectEntries.put((Long)this._getProperty("r_caseToCaseResult_c_caseId", objectEntry), objectEntry);
        }
        return testrayCaseResultObjectEntries;
    }

    private long _getTestrayCaseTypeId(long companyId, String testrayCaseTypeName) throws Exception {
        String objectEntryIdsKey = "CaseType#" + testrayCaseTypeName;
        long testrayCaseTypeId = this._getObjectEntryId(companyId, "name eq '" + testrayCaseTypeName + "'", "CaseType", objectEntryIdsKey);
        if (testrayCaseTypeId != 0L) {
            return testrayCaseTypeId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("CaseType", HashMapBuilder.put((Object)"name", (Object)testrayCaseTypeName).build());
        testrayCaseTypeId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayCaseTypeId);
        return testrayCaseTypeId;
    }

    private long _getTestrayComponentId(long companyId, String testrayComponentName, long testrayProjectId, long testrayTeamId) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Component#", testrayComponentName, "#ProjectId#", testrayProjectId});
        long testrayComponentId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayComponentName, "'"}), "Component", objectEntryIdsKey);
        if (testrayComponentId != 0L) {
            return testrayComponentId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("Component", HashMapBuilder.put((Object)"name", (Object)testrayComponentName).put((Object)"r_projectToComponents_c_projectId", (Object)testrayProjectId).put((Object)"r_teamToComponents_c_teamId", (Object)testrayTeamId).build());
        testrayComponentId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayComponentId);
        return testrayComponentId;
    }

    private long _getTestrayFactorCategoryId(long companyId, String testrayFactorCategoryName) throws Exception {
        String objectEntryIdsKey = "FactorCategory#" + testrayFactorCategoryName;
        long testrayFactorCategoryId = this._getObjectEntryId(companyId, "name eq '" + testrayFactorCategoryName + "'", "FactorCategory", objectEntryIdsKey);
        if (testrayFactorCategoryId != 0L) {
            return testrayFactorCategoryId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("FactorCategory", HashMapBuilder.put((Object)"name", (Object)testrayFactorCategoryName).build());
        testrayFactorCategoryId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayFactorCategoryId);
        return testrayFactorCategoryId;
    }

    private long _getTestrayFactorOptionId(long companyId, long testrayFactorCategoryId, String testrayFactorOptionName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"FactorOption#", testrayFactorOptionName, "#FactorCategoryId#", testrayFactorCategoryId});
        long testrayFactorOptionId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"factorCategoryId eq '", testrayFactorCategoryId, "' and name eq '", testrayFactorOptionName, "'"}), "FactorOption", objectEntryIdsKey);
        if (testrayFactorOptionId != 0L) {
            return testrayFactorOptionId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("FactorOption", HashMapBuilder.put((Object)"name", (Object)testrayFactorOptionName).put((Object)"r_factorCategoryToOptions_c_factorCategoryId", (Object)testrayFactorCategoryId).build());
        testrayFactorOptionId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayFactorOptionId);
        return testrayFactorOptionId;
    }

    private long _getTestrayProductVersionId(long companyId, String testrayProductVersionName, long testrayProjectId) throws Exception {
        String objectEntryIdsKey = "ProductVersion#" + testrayProductVersionName;
        long testrayProductVersionId = this._getObjectEntryId(companyId, "name eq '" + testrayProductVersionName + "'", "ProductVersion", objectEntryIdsKey);
        if (testrayProductVersionId != 0L) {
            return testrayProductVersionId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("ProductVersion", HashMapBuilder.put((Object)"name", (Object)testrayProductVersionName).put((Object)"r_projectToProductVersions_c_projectId", (Object)testrayProjectId).build());
        testrayProductVersionId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayProductVersionId);
        return testrayProductVersionId;
    }

    private long _getTestrayProjectId(long companyId, String testrayProjectName) throws Exception {
        String objectEntryIdsKey = "Project#" + testrayProjectName;
        long testrayProjectId = this._getObjectEntryId(companyId, "name eq '" + testrayProjectName + "'", "Project", objectEntryIdsKey);
        if (testrayProjectId != 0L) {
            return testrayProjectId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("Project", HashMapBuilder.put((Object)"name", (Object)testrayProjectName).build());
        testrayProjectId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayProjectId);
        return testrayProjectId;
    }

    private long _getTestrayRoutineId(long companyId, long testrayProjectId, String testrayRoutineName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Routine#", testrayRoutineName, "#ProjectId#", testrayProjectId});
        long testrayRoutineId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayRoutineName, "'"}), "Routine", objectEntryIdsKey);
        if (testrayRoutineId != 0L) {
            return testrayRoutineId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("Routine", HashMapBuilder.put((Object)"name", (Object)testrayRoutineName).put((Object)"r_routineToProjects_c_projectId", (Object)testrayProjectId).build());
        testrayRoutineId = objectEntry.getId();
        this._objectEntryIds.put(objectEntryIdsKey, testrayRoutineId);
        return testrayRoutineId;
    }

    private String _getTestrayRunEnvironmentHash(long companyId, Element element, long testrayRunId) throws Exception {
        StringBundler sb = new StringBundler();
        NodeList environmentNodeList = element.getElementsByTagName("environment");
        for (int i = 0; i < environmentNodeList.getLength(); ++i) {
            Node node = environmentNodeList.item(i);
            if (!node.hasAttributes()) continue;
            String testrayFactorCategoryName = this._getAttributeValue("type", node);
            long testrayFactorCategoryId = this._getTestrayFactorCategoryId(companyId, testrayFactorCategoryName);
            String testrayFactorOptionName = this._getAttributeValue("option", node);
            long testrayFactorOptionId = this._getTestrayFactorOptionId(companyId, testrayFactorCategoryId, testrayFactorOptionName);
            this._addTestrayFactor(testrayFactorCategoryId, testrayFactorCategoryName, testrayFactorOptionId, testrayFactorOptionName, testrayRunId);
            sb.append(testrayFactorCategoryId);
            sb.append(testrayFactorOptionId);
        }
        String testrayFactorsString = sb.toString();
        return String.valueOf(testrayFactorsString.hashCode());
    }

    private long _getTestrayRunId(long companyId, Element element, Map<String, String> propertiesMap, long testrayBuildId, String testrayRunName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Run#", testrayRunName, "#BuildId#", testrayBuildId});
        long testrayRunId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"buildId eq '", testrayBuildId, "' and name eq '", testrayRunName, "'"}), "Run", objectEntryIdsKey);
        if (testrayRunId != 0L) {
            return testrayRunId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("Run", HashMapBuilder.put((Object)"externalReferencePK", (Object)propertiesMap.get("testray.run.id")).put((Object)"externalReferenceType", (Object)1).put((Object)"jenkinsJobKey", (Object)propertiesMap.get("jenkins.job.id")).put((Object)"name", (Object)testrayRunName).put((Object)"number", (Object)this._increment(companyId, "number", "buildId eq '" + testrayBuildId + "'", "Run")).put((Object)"r_buildToRuns_c_buildId", (Object)testrayBuildId).build());
        testrayRunId = objectEntry.getId();
        objectEntry.getProperties().put("environmentHash", this._getTestrayRunEnvironmentHash(companyId, element, testrayRunId));
        this._objectEntryManager.updateObjectEntry((DTOConverterContext)this._defaultDTOConverterContext, this._objectDefinitions.get("Run"), objectEntry.getId().longValue(), objectEntry);
        this._objectEntryIds.put(objectEntryIdsKey, testrayRunId);
        return testrayRunId;
    }

    private long _getTestrayTeamId(long companyId, long testrayProjectId, String testrayTeamName) throws Exception {
        String objectEntryIdsKey = StringBundler.concat((Object[])new Object[]{"Team#", testrayTeamName, "#ProjectId#", testrayProjectId});
        long testrayTeamId = this._getObjectEntryId(companyId, StringBundler.concat((Object[])new Object[]{"projectId eq '", testrayProjectId, "' and name eq '", testrayTeamName, "'"}), "Team", objectEntryIdsKey);
        if (testrayTeamId != 0L) {
            return testrayTeamId;
        }
        ObjectEntry objectEntry = this._addObjectEntry("Team", HashMapBuilder.put((Object)"name", (Object)testrayTeamName).put((Object)"r_projectToTeams_c_projectId", (Object)testrayProjectId).build());
        this._objectEntryIds.put(objectEntryIdsKey, objectEntry.getId());
        return objectEntry.getId();
    }

    private long _increment(long companyId, String fieldName, String filterString, String objectDefinitionShortName) throws Exception {
        com.liferay.portal.vulcan.pagination.Page objectEntriesPage = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitions.get(objectDefinitionShortName), null, null, (DTOConverterContext)this._defaultDTOConverterContext, filterString, null, null, new Sort[]{new Sort("nestedFieldArray.value_long#" + fieldName, true)});
        ObjectEntry objectEntry = (ObjectEntry)objectEntriesPage.fetchFirstItem();
        if (objectEntry == null) {
            return 1L;
        }
        Long fieldValue = (Long)this._getProperty(fieldName, objectEntry);
        if (fieldValue == null) {
            return 1L;
        }
        return fieldValue + 1L;
    }

    private void _invoke(UnsafeRunnable<Exception> unsafeRunnable) throws Exception {
        long startTime = System.currentTimeMillis();
        unsafeRunnable.run();
        if (_log.isInfoEnabled()) {
            Thread thread = Thread.currentThread();
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Invoking line ", stackTraceElement.getLineNumber(), " took ", System.currentTimeMillis() - startTime, " ms"}));
        }
    }

    private boolean _isEmpty(String value) {
        if (value == null) {
            return true;
        }
        String trimmedValue = value.trim();
        return trimmedValue.isEmpty();
    }

    private void _load(long companyId) throws Exception {
        List objectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(companyId, true, 0);
        if (ListUtil.isEmpty((List)objectDefinitions)) {
            return;
        }
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this._objectDefinitions.put(objectDefinition.getShortName(), objectDefinition);
        }
        this._loadTestrayCaseTypes(companyId);
        this._loadTestrayComponents(companyId);
        this._loadTestrayFactorCategories(companyId);
        this._loadTestrayFactorOptions(companyId);
        this._loadTestrayProjects(companyId);
        this._loadTestrayTeams(companyId);
    }

    private void _loadTestrayCaseTypes(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = this._getObjectEntries(companyId, "CaseType");
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put("CaseType#" + (String)this._getProperty("name", objectEntry), objectEntry.getId());
        }
    }

    private void _loadTestrayComponents(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = this._getObjectEntries(companyId, "Component");
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put(StringBundler.concat((Object[])new Object[]{"Component#", (String)this._getProperty("name", objectEntry), "#TeamId#", (Long)this._getProperty("r_teamToComponents_c_teamId", objectEntry)}), objectEntry.getId());
        }
    }

    private void _loadTestrayFactorCategories(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = this._getObjectEntries(companyId, "FactorCategory");
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put("FactorCategory#" + (String)this._getProperty("name", objectEntry), objectEntry.getId());
        }
    }

    private void _loadTestrayFactorOptions(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = this._getObjectEntries(companyId, "FactorOption");
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put(StringBundler.concat((Object[])new Object[]{"FactorOption#", (String)this._getProperty("name", objectEntry), "#FactorCategoryId#", (Long)this._getProperty("r_factorCategoryToOptions_c_factorCategoryId", objectEntry)}), objectEntry.getId());
        }
    }

    private void _loadTestrayProjects(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = this._getObjectEntries(companyId, "Project");
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put("Project#" + (String)this._getProperty("name", objectEntry), objectEntry.getId());
        }
    }

    private void _loadTestrayTeams(long companyId) throws Exception {
        List<ObjectEntry> objectEntries = this._getObjectEntries(companyId, "Team");
        if (ListUtil.isEmpty(objectEntries)) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            this._objectEntryIds.put(StringBundler.concat((Object[])new Object[]{"Team#", (String)this._getProperty("name", objectEntry), "#ProjectId#", (Long)this._getProperty("r_projectToTeams_c_projectIds", objectEntry)}), objectEntry.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processArchive(long companyId, byte[] bytes) throws Exception {
        Path tempFilePath;
        block11: {
            Path tempDirectoryPath = null;
            tempFilePath = null;
            try {
                tempDirectoryPath = Files.createTempDirectory(null, new FileAttribute[0]);
                tempFilePath = Files.createTempFile(null, null, new FileAttribute[0]);
                Files.write(tempFilePath, bytes, new OpenOption[0]);
                Archiver archiver = ArchiverFactory.createArchiver((String)"tar");
                File tempDirectoryFile = tempDirectoryPath.toFile();
                archiver.extract(tempFilePath.toFile(), tempDirectoryFile);
                DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                for (File file : tempDirectoryFile.listFiles()) {
                    try {
                        Document document = documentBuilder.parse(file);
                        this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._processDocument(companyId, document)));
                    }
                    catch (Exception exception) {
                        _log.error((Throwable)exception);
                    }
                    finally {
                        file.delete();
                    }
                }
                if (tempDirectoryPath == null) break block11;
            }
            catch (Throwable throwable) {
                if (tempDirectoryPath != null) {
                    Files.deleteIfExists(tempDirectoryPath);
                }
                if (tempFilePath != null) {
                    Files.deleteIfExists(tempFilePath);
                }
                throw throwable;
            }
            Files.deleteIfExists(tempDirectoryPath);
        }
        if (tempFilePath != null) {
            Files.deleteIfExists(tempFilePath);
        }
    }

    private void _processDocument(long companyId, Document document) throws Exception {
        Element element = document.getDocumentElement();
        Map<String, String> propertiesMap = this._getPropertiesMap(element);
        long testrayProjectId = this._getTestrayProjectId(companyId, propertiesMap.get("testray.project.name"));
        long testrayRoutineId = this._getTestrayRoutineId(companyId, testrayProjectId, propertiesMap.get("testray.build.type"));
        long testrayBuildId = this._getTestrayBuildId(companyId, propertiesMap, propertiesMap.get("testray.build.name"), testrayProjectId, testrayRoutineId);
        long testrayRunId = this._getTestrayRunId(companyId, element, propertiesMap, testrayBuildId, propertiesMap.get("testray.run.id"));
        this._addTestrayCases(companyId, element, testrayBuildId, propertiesMap.get("testray.build.time"), testrayProjectId, testrayRunId);
        ObjectEntry testrayRoutineObjectEntry = this._objectEntryManager.getObjectEntry((DTOConverterContext)this._defaultDTOConverterContext, this._objectDefinitions.get("Routine"), testrayRoutineId);
        if (!((Boolean)this._getProperty("autoanalyze", testrayRoutineObjectEntry)).booleanValue()) {
            return;
        }
        ObjectEntry testrayRunObjectEntry1 = this._objectEntryManager.getObjectEntry((DTOConverterContext)this._defaultDTOConverterContext, this._objectDefinitions.get("Run"), testrayRunId);
        ObjectEntry testrayRunObjectEntry2 = this._fetchLatestTestrayRunObjectEntry(companyId, (String)this._getProperty("environmentHash", testrayRunObjectEntry1), testrayRoutineObjectEntry.getId(), testrayRunId);
        if (testrayRunObjectEntry2 == null) {
            return;
        }
        Map<Long, ObjectEntry> testrayCaseResultObjectEntries1 = this._getTestrayCaseResultObjectEntries(companyId, testrayRunObjectEntry1);
        Map<Long, ObjectEntry> testrayCaseResultObjectEntries2 = this._getTestrayCaseResultObjectEntries(companyId, testrayRunObjectEntry2);
        for (Map.Entry<Long, ObjectEntry> entry : testrayCaseResultObjectEntries1.entrySet()) {
            ObjectEntry testrayCaseResultObjectEntry2 = testrayCaseResultObjectEntries2.get(entry.getKey());
            if (testrayCaseResultObjectEntry2 == null) continue;
            ObjectEntry testrayCaseResultObjectEntry1 = entry.getValue();
            String testrayCaseResultErrors1 = (String)this._getProperty("errors", testrayCaseResultObjectEntry1);
            String testrayCaseResultErrors2 = (String)this._getProperty("errors", testrayCaseResultObjectEntry2);
            if (Validator.isNull((String)testrayCaseResultErrors1) || Validator.isNull((String)testrayCaseResultErrors2) || !Objects.equals(testrayCaseResultErrors1, testrayCaseResultErrors2)) continue;
            this._autofill(companyId, testrayCaseResultObjectEntry1, testrayCaseResultObjectEntry2);
        }
    }

    private void _uploadToTestray(long companyId, UnicodeProperties unicodeProperties) throws Exception {
        String s3APIKey = unicodeProperties.getProperty("s3APIKey");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(s3APIKey.getBytes());){
            Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)inputStream))).build().getService();
            String s3InboxFolderName = unicodeProperties.getProperty("s3InboxFolderName");
            Page page = storage.list(unicodeProperties.getProperty("s3BucketName"), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)(s3InboxFolderName + "/"))});
            for (Blob blob : page.iterateAll()) {
                String name = blob.getName();
                if (name.equals(s3InboxFolderName + "/")) continue;
                try {
                    this._processArchive(companyId, blob.getContent(new Blob.BlobSourceOption[0]));
                    blob.copyTo(unicodeProperties.getProperty("s3BucketName"), name.replaceFirst(s3InboxFolderName, unicodeProperties.getProperty("s3ProcessedFolderName")), new Blob.BlobSourceOption[0]);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                    blob.copyTo(unicodeProperties.getProperty("s3BucketName"), name.replaceFirst(s3InboxFolderName, unicodeProperties.getProperty("s3ErroredFolderName")), new Blob.BlobSourceOption[0]);
                }
                blob.delete(new Blob.BlobSourceOption[0]);
            }
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to authenticate with GCP");
            throw new PortalException("Unable to authenticate with GCP", (Throwable)ioException);
        }
    }
}

