/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal;

import com.liferay.commerce.account.util.CommerceAccountRoleHelper;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.initializer.util.CPDefinitionsImporter;
import com.liferay.commerce.initializer.util.CPOptionCategoriesImporter;
import com.liferay.commerce.initializer.util.CPOptionsImporter;
import com.liferay.commerce.initializer.util.CPSpecificationOptionsImporter;
import com.liferay.commerce.initializer.util.CommerceInventoryWarehousesImporter;
import com.liferay.commerce.initializer.util.PortletSettingsImporter;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateLocalService;
import com.liferay.commerce.price.list.model.CommercePriceEntry;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.commerce.price.list.service.CommercePriceEntryLocalService;
import com.liferay.commerce.price.list.service.CommercePriceListLocalService;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.service.CPOptionLocalService;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.service.CommerceChannelService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductSpecification;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductSpecificationResource;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.ChannelResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.site.initializer.extender.internal.util.SiteInitializerUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceSiteInitializer.class})
public class CommerceSiteInitializer {
    private static final Log _log = LogFactoryUtil.getLog(CommerceSiteInitializer.class);
    @Reference
    private CatalogResource.Factory _catalogResourceFactory;
    @Reference
    private ChannelResource.Factory _channelResourceFactory;
    @Reference
    private CommerceAccountRoleHelper _commerceAccountRoleHelper;
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceChannelService _commerceChannelService;
    @Reference
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @Reference
    private CommerceInventoryWarehousesImporter _commerceInventoryWarehousesImporter;
    @Reference
    private CommerceNotificationTemplateLocalService _commerceNotificationTemplateLocalService;
    @Reference
    private CommercePriceEntryLocalService _commercePriceEntryLocalService;
    @Reference
    private CommercePriceListLocalService _commercePriceListLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionsImporter _cpDefinitionsImporter;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @Reference
    private CPOptionCategoriesImporter _cpOptionCategoriesImporter;
    @Reference
    private CPOptionLocalService _cpOptionLocalService;
    @Reference
    private CPOptionsImporter _cpOptionsImporter;
    @Reference
    private CPSpecificationOptionsImporter _cpSpecificationOptionsImporter;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletSettingsImporter _portletSettingsImporter;
    @Reference
    private ProductOptionResource.Factory _productOptionResourceFactory;
    @Reference
    private ProductSpecificationResource.Factory _productSpecificationResourceFactory;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private SettingsFactory _settingsFactory;

    public void addCPDefinitions(Bundle bundle, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        Channel channel = this._addOrUpdateCommerceChannel(serviceContext, servletContext);
        if (channel == null) {
            return;
        }
        this._addOrUpdateCommerceCatalogs(bundle, channel, this._addCommerceInventoryWarehouses(serviceContext, servletContext), serviceContext, servletContext);
        this._addCommerceNotificationTemplates(bundle, channel.getId(), documentsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, serviceContext, servletContext);
        this._addOrUpdateCPOptionCategories(serviceContext, servletContext);
    }

    public void addPortletSettings(ClassLoader classLoader, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/portlet-settings.json";
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        this._portletSettingsImporter.importPortletSettings(this._jsonFactory.createJSONArray(json), classLoader, "/site-initializer/portlet-settings/", serviceContext.getScopeGroupId(), group.getGroupId(), serviceContext.getUserId());
    }

    public long getCommerceChannelGroupId(long siteGroupId) {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(siteGroupId);
        return commerceChannel.getGroupId();
    }

    public String getCommerceOrderClassName() {
        return CommerceOrder.class.getName();
    }

    private void _addCommerceChannelConfiguration(Channel channel, String resourcePath, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        CommerceChannel commerceChannel = this._commerceChannelService.getCommerceChannel(channel.getId().longValue());
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        Map map1 = jsonObject.toMap();
        for (Map.Entry entry1 : map1.entrySet()) {
            Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), (String)entry1.getKey()));
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            Map map2 = (Map)entry1.getValue();
            for (Map.Entry entry2 : map2.entrySet()) {
                modifiableSettings.setValue((String)entry2.getKey(), String.valueOf(entry2.getValue()));
            }
            modifiableSettings.store();
        }
    }

    private List<CommerceInventoryWarehouse> _addCommerceInventoryWarehouses(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        return this._commerceInventoryWarehousesImporter.importCommerceInventoryWarehouses(this._jsonFactory.createJSONArray(SiteInitializerUtil.read("/site-initializer/commerce-inventory-warehouses.json", servletContext)), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _addCommerceNotificationTemplate(Bundle bundle, long commerceChannelId, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath + "commerce-notification-template.json", servletContext);
        if (Validator.isNull((String)json)) {
            return;
        }
        JSONObject commerceNotificationTemplateJSONObject = this._jsonFactory.createJSONObject(json);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        JSONObject bodyJSONObject = this._jsonFactory.createJSONObject();
        Enumeration enumeration = bundle.findEntries(resourcePath, "*.html", false);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                bodyJSONObject.put(FileUtil.getShortFileName((String)FileUtil.stripExtension((String)url.getPath())), StringUtil.replace((String)StringUtil.read((InputStream)url.openStream()), (String)"[$", (String)"$]", documentsStringUtilReplaceValues));
            }
        }
        this._commerceNotificationTemplateLocalService.addCommerceNotificationTemplate(serviceContext.getUserId(), commerceChannel.getGroupId(), commerceNotificationTemplateJSONObject.getString("name"), commerceNotificationTemplateJSONObject.getString("description"), commerceNotificationTemplateJSONObject.getString("from"), SiteInitializerUtil.toMap(commerceNotificationTemplateJSONObject.getString("fromName")), commerceNotificationTemplateJSONObject.getString("to"), commerceNotificationTemplateJSONObject.getString("cc"), commerceNotificationTemplateJSONObject.getString("bcc"), StringUtil.replace((String)commerceNotificationTemplateJSONObject.getString("type"), (String)"[$", (String)"$]", objectDefinitionIdsStringUtilReplaceValues), commerceNotificationTemplateJSONObject.getBoolean("enabled"), SiteInitializerUtil.toMap(commerceNotificationTemplateJSONObject.getString("subject")), SiteInitializerUtil.toMap(bodyJSONObject.toString()), serviceContext);
    }

    private void _addCommerceNotificationTemplates(Bundle bundle, long commerceChannelId, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/site-initializer/commerce-notification-templates");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            this._addCommerceNotificationTemplate(bundle, commerceChannelId, documentsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, resourcePath, serviceContext, servletContext);
        }
    }

    private void _addCommerceProductSpecifications(String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        ProductSpecificationResource.Builder productSpecificationResourceBuilder = this._productSpecificationResourceFactory.create();
        ProductSpecificationResource productSpecificationResource = productSpecificationResourceBuilder.user(serviceContext.fetchUser()).build();
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        this._cpSpecificationOptionsImporter.importCPSpecificationOptions(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
        for (int i = 0; i < jsonArray.length(); ++i) {
            final JSONObject jsonObject = jsonArray.getJSONObject(i);
            final CPDefinition cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(jsonObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId());
            if (cpDefinition == null) continue;
            ProductSpecification productSpecification = new ProductSpecification(){
                {
                    this.productId = cpDefinition.getCPDefinitionId();
                    this.specificationKey = jsonObject.getString("key");
                    this.value = JSONUtil.toStringMap((JSONObject)jsonObject.getJSONObject("productSpecificationValue"));
                }
            };
            productSpecificationResource.postProductIdProductSpecification(Long.valueOf(cpDefinition.getCPDefinitionId()), productSpecification);
        }
    }

    private void _addCPDefinitions(String assetVocabularyName, Bundle bundle, Catalog catalog, Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        Group commerceCatalogGroup = this._commerceCatalogLocalService.getCommerceCatalogGroup(catalog.getId().longValue());
        List cpDefinitions = this._cpDefinitionsImporter.importCPDefinitions(this._jsonFactory.createJSONArray(json), assetVocabularyName, commerceCatalogGroup.getGroupId(), channel.getId().longValue(), ListUtil.toLongArray(commerceInventoryWarehouses, (Accessor)CommerceInventoryWarehouse.COMMERCE_INVENTORY_WAREHOUSE_ID_ACCESSOR), bundleWiring.getClassLoader(), StringUtil.replace((String)resourcePath, (String)".json", (String)"/"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
        if (ListUtil.isEmpty((List)cpDefinitions)) {
            return;
        }
        for (CPDefinition cpDefinition : cpDefinitions) {
            List cpInstances = cpDefinition.getCPInstances();
            if (ListUtil.isEmpty((List)cpInstances)) continue;
            for (CPInstance cpInstance : cpInstances) {
                this._addOrUpdateCommercePriceEntries(cpDefinition, cpInstance, serviceContext);
            }
        }
    }

    private void _addCPInstanceSubscriptions(String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        ProductOptionResource.Builder productOptionResourceBuilder = this._productOptionResourceFactory.create();
        ProductOptionResource productOptionResource = productOptionResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            CPDefinition cpDefinition;
            JSONObject subscriptionPropertiesJSONObject = jsonArray.getJSONObject(i);
            final CPOption cpOption = this._cpOptionLocalService.fetchCPOption(serviceContext.getCompanyId(), subscriptionPropertiesJSONObject.getString("optionKey"));
            if (cpOption == null || (cpDefinition = this._cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(subscriptionPropertiesJSONObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId())) == null) continue;
            productOptionResource.postProductIdProductOptionsPage(Long.valueOf(cpDefinition.getCProductId()), new ProductOption[]{new ProductOption(){
                {
                    this.facetable = cpOption.isFacetable();
                    this.fieldType = cpOption.getDDMFormFieldTypeName();
                    this.key = cpOption.getKey();
                    this.name = LocalizedMapUtil.getI18nMap((Map)cpOption.getNameMap());
                    this.optionId = cpOption.getCPOptionId();
                    this.required = cpOption.isRequired();
                    this.skuContributor = cpOption.isSkuContributor();
                }
            }});
            this._cpInstanceLocalService.buildCPInstances(cpDefinition.getCPDefinitionId(), serviceContext);
            JSONArray cpInstancePropertiesJSONArray = subscriptionPropertiesJSONObject.getJSONArray("cpInstanceProperties");
            if (cpInstancePropertiesJSONArray == null) continue;
            for (int j = 0; j < cpInstancePropertiesJSONArray.length(); ++j) {
                JSONObject cpInstancePropertiesJSONObject = cpInstancePropertiesJSONArray.getJSONObject(j);
                this._updateCPInstanceProperties(cpDefinition, cpInstancePropertiesJSONObject, serviceContext);
            }
            this._addOrUpdateCommercePriceEntries(cpDefinition, this._cpInstanceLocalService.fetchByExternalReferenceCode(subscriptionPropertiesJSONObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId()), serviceContext);
        }
    }

    private void _addCPOptions(Catalog catalog, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        Group commerceCatalogGroup = this._commerceCatalogLocalService.getCommerceCatalogGroup(catalog.getId().longValue());
        this._cpOptionsImporter.importCPOptions(this._jsonFactory.createJSONArray(json), commerceCatalogGroup.getGroupId(), serviceContext.getUserId());
    }

    private void _addDefaultCPDisplayLayout(Channel channel, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), jsonObject.getBoolean("privateLayout"), jsonObject.getString("friendlyURL"));
        if (layout == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to create a default product commerce product display layout from JSON: " + json));
            }
            return;
        }
        CommerceChannel commerceChannel = this._commerceChannelService.getCommerceChannel(channel.getId().longValue());
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), "com.liferay.commerce.product.display.layout"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("productLayoutUuid", layout.getUuid());
        modifiableSettings.store();
    }

    private void _addModelResourcePermissions(String className, String primKey, String resourcePath, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this._resourcePermissionLocalService.addModelResourcePermissions(serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), serviceContext.getUserId(), className, primKey, ModelPermissionsFactory.create((Map)HashMapBuilder.put((Object)jsonObject.getString("roleName"), (Object)ArrayUtil.toStringArray((JSONArray)jsonObject.getJSONArray("actionIds"))).build(), null));
        }
    }

    private void _addOrUpdateCommerceCatalogs(Bundle bundle, Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/site-initializer/commerce-catalogs");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        CatalogResource.Builder builder = this._catalogResourceFactory.create();
        CatalogResource catalogResource = builder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith(".options.json") || resourcePath.endsWith(".products.json") || resourcePath.endsWith(".products.specifications.json") || resourcePath.endsWith(".products.subscriptions.properties.json") || !resourcePath.endsWith(".json")) continue;
            String json = SiteInitializerUtil.read(resourcePath, servletContext);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
            String assetVocabularyName = jsonObject.getString("assetVocabularyName");
            jsonObject.remove("assetVocabularyName");
            Catalog catalog = Catalog.toDTO((String)String.valueOf(jsonObject));
            if (catalog == null) {
                _log.error((Object)("Unable to transform commerce catalog from JSON: " + json));
                continue;
            }
            catalog = catalogResource.postCatalog(catalog);
            this._addCPOptions(catalog, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".options.json"), serviceContext, servletContext);
            this._addCPDefinitions(assetVocabularyName, bundle, catalog, channel, commerceInventoryWarehouses, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.json"), serviceContext, servletContext);
            this._addCommerceProductSpecifications(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.specifications.json"), serviceContext, servletContext);
            this._addCPInstanceSubscriptions(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.subscriptions.properties.json"), serviceContext, servletContext);
        }
    }

    private Channel _addOrUpdateCommerceChannel(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/commerce-channel.json";
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return null;
        }
        ChannelResource.Builder channelResourceBuilder = this._channelResourceFactory.create();
        ChannelResource channelResource = channelResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        jsonObject.put("siteGroupId", serviceContext.getScopeGroupId());
        Channel channel = Channel.toDTO((String)jsonObject.toString());
        if (channel == null) {
            _log.error((Object)("Unable to transform commerce channel from JSON: " + json));
            return null;
        }
        Page channelsPage = channelResource.getChannelsPage(null, channelResource.toFilter(StringBundler.concat((Object[])new Object[]{"siteGroupId eq '", serviceContext.getScopeGroupId(), "'"})), null, null);
        Channel existingChannel = (Channel)channelsPage.fetchFirstItem();
        channel = existingChannel == null ? channelResource.postChannel(channel) : channelResource.putChannel(existingChannel.getId(), channel);
        this._addCommerceChannelConfiguration(channel, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".config.json"), servletContext);
        this._addDefaultCPDisplayLayout(channel, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".default-cp-display-layout.json"), serviceContext, servletContext);
        this._addModelResourcePermissions(CommerceChannel.class.getName(), String.valueOf(channel.getId()), StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".model-resource-permissions.json"), serviceContext, servletContext);
        this._commerceAccountRoleHelper.checkCommerceAccountRoles(serviceContext);
        this._commerceCurrencyLocalService.importDefaultValues(true, serviceContext);
        this._cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        return channel;
    }

    private void _addOrUpdateCommercePriceEntries(CPDefinition cpDefinition, CPInstance cpInstance, ServiceContext serviceContext) throws Exception {
        this._addOrUpdateCommercePriceEntry(cpDefinition, cpInstance, serviceContext, "price-list");
        this._addOrUpdateCommercePriceEntry(cpDefinition, cpInstance, serviceContext, "promotion");
    }

    private void _addOrUpdateCommercePriceEntry(CPDefinition cpDefinition, CPInstance cpInstance, ServiceContext serviceContext, String type) throws Exception {
        CommercePriceList commercePriceList = this._commercePriceListLocalService.getCatalogBaseCommercePriceListByType(cpInstance.getGroupId(), type);
        CommercePriceEntry commercePriceEntry = this._commercePriceEntryLocalService.fetchCommercePriceEntry(commercePriceList.getCommercePriceListId(), cpInstance.getCPInstanceUuid());
        BigDecimal price = cpInstance.getPrice();
        if ("promotion".equals(commercePriceList.getType())) {
            price = cpInstance.getPromoPrice();
        }
        serviceContext.setWorkflowAction(1);
        if (commercePriceEntry == null) {
            this._commercePriceEntryLocalService.addCommercePriceEntry(null, cpDefinition.getCProductId(), cpInstance.getCPInstanceUuid(), commercePriceList.getCommercePriceListId(), price, BigDecimal.ZERO, serviceContext);
        } else {
            this._commercePriceEntryLocalService.updateCommercePriceEntry(commercePriceEntry.getCommercePriceEntryId(), price, BigDecimal.ZERO, serviceContext);
        }
    }

    private void _addOrUpdateCPOptionCategories(ServiceContext serviceContext, ServletContext servletContext) throws Exception {
        String resourcePath = "/site-initializer/commerce-option-categories.json";
        String json = SiteInitializerUtil.read(resourcePath, servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        this._cpOptionCategoriesImporter.importCPOptionCategories(jsonArray, serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _updateCPInstanceProperties(CPDefinition cpDefinition, JSONObject cpInstancePropertiesJSONObject, ServiceContext serviceContext) throws Exception {
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpDefinition.getCPDefinitionId(), cpInstancePropertiesJSONObject.getString("cpInstanceSku"));
        if (cpInstance == null) {
            return;
        }
        String propertyType = cpInstancePropertiesJSONObject.getString("propertyType");
        if (StringUtil.equals((String)propertyType, (String)"CREATE_SUBSCRIPTION")) {
            JSONObject subscriptionTypeSettingsJSONObject = cpInstancePropertiesJSONObject.getJSONObject("subscriptionTypeSettings");
            this._cpInstanceLocalService.updateSubscriptionInfo(cpInstance.getCPInstanceId(), cpInstancePropertiesJSONObject.getBoolean("overrideSubscriptionInfo"), cpInstancePropertiesJSONObject.getBoolean("subscriptionEnabled"), cpInstancePropertiesJSONObject.getInt("subscriptionLength"), cpInstancePropertiesJSONObject.getString("subscriptionType"), UnicodePropertiesBuilder.create((Map)JSONUtil.toStringMap((JSONObject)subscriptionTypeSettingsJSONObject), (boolean)true).build(), cpInstancePropertiesJSONObject.getLong("maxSubscriptionCycles"), cpInstancePropertiesJSONObject.getBoolean("deliverySubscriptionEnabled"), cpInstancePropertiesJSONObject.getInt("deliverySubscriptionLength"), cpInstancePropertiesJSONObject.getString("deliverySubscriptionType"), new UnicodeProperties(), cpInstancePropertiesJSONObject.getLong("deliveryMaxSubscriptionCycles"));
        } else if (StringUtil.equals((String)propertyType, (String)"UPDATE_PRICE")) {
            cpInstance.setPrice(BigDecimal.valueOf(cpInstancePropertiesJSONObject.getLong("skuPrice")));
            cpInstance.setPromoPrice(BigDecimal.valueOf(cpInstancePropertiesJSONObject.getLong("skuPromoPrice")));
            this._cpInstanceLocalService.updateCPInstance(cpInstance);
        }
        this._addOrUpdateCommercePriceEntries(cpDefinition, cpInstance, serviceContext);
    }
}

