/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.demo.data.creator.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.site.demo.data.creator.SiteDemoDataCreator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SiteDemoDataCreator.class})
public class SiteDemoDataCreatorImpl
implements SiteDemoDataCreator {
    private static final Log _log = LogFactoryUtil.getLog(SiteDemoDataCreatorImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private FriendlyURLNormalizer _friendlyURLNormalizer;
    private final List<Long> _groupIds = new CopyOnWriteArrayList<Long>();
    @Reference
    private GroupLocalService _groupLocalService;

    public Group create(long companyId) throws PortalException {
        return this.create(companyId, StringUtil.randomString());
    }

    public Group create(long companyId, String name) throws PortalException {
        Company company = this._companyLocalService.fetchCompany(companyId);
        User user = company.getDefaultUser();
        HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)name).build();
        HashMap descriptionMap = new HashMap();
        int type = 1;
        String friendlyURL = "/" + this._friendlyURLNormalizer.normalize(name);
        boolean site = true;
        boolean active = true;
        boolean manualMembership = true;
        int membershipRestriction = 0;
        Group group = this._groupLocalService.addGroup(user.getUserId(), 0L, null, 0L, 0L, (Map)nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, site, active, null);
        this._groupIds.add(group.getGroupId());
        return group;
    }

    public void delete() throws PortalException {
        for (long groupId : this._groupIds) {
            block3: {
                try {
                    this._groupLocalService.deleteGroup(groupId);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)portalException);
                }
            }
            this._groupIds.remove(groupId);
        }
    }
}

