/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.browser.web.internal.servlet.taglib.clay;

import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.site.browser.web.internal.display.context.SiteBrowserDisplayContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class SiteVerticalCard
implements VerticalCard {
    private final Group _group;
    private final HttpServletRequest _httpServletRequest;
    private final SiteBrowserDisplayContext _siteBrowserDisplayContext;
    private final ThemeDisplay _themeDisplay;

    public SiteVerticalCard(Group group, RenderRequest renderRequest, SiteBrowserDisplayContext siteBrowserDisplayContext) {
        this._group = group;
        this._siteBrowserDisplayContext = siteBrowserDisplayContext;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public Map<String, String> getData() {
        if (!this._siteBrowserDisplayContext.isShowLink(this._group)) {
            return null;
        }
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("entityid", String.valueOf(this._group.getGroupId()));
            data.put("entityname", this._group.getDescriptiveName(this._themeDisplay.getLocale()));
            data.put("grouptarget", this._siteBrowserDisplayContext.getTarget());
            data.put("grouptype", LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)this._group.getTypeLabel()));
            data.put("url", this._group.getDisplayURL(this._themeDisplay));
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getElementClasses() {
        if (this._siteBrowserDisplayContext.isShowLink(this._group)) {
            return "card-interactive card-interactive-secondary selector-button";
        }
        return null;
    }

    public String getIcon() {
        return "sites";
    }

    public String getImageSrc() {
        return this._group.getLogoURL(this._themeDisplay, false);
    }

    public String getSubtitle() {
        if (this._group.isCompany()) {
            return "-";
        }
        List childSites = this._group.getChildren(true);
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"x-child-sites", (Object)childSites.size());
    }

    public String getTitle() {
        try {
            return HtmlUtil.escape((String)this._group.getDescriptiveName(this._themeDisplay.getLocale()));
        }
        catch (Exception exception) {
            return HtmlUtil.escape((String)this._group.getName(this._themeDisplay.getLocale()));
        }
    }

    public boolean isSelectable() {
        return false;
    }
}

