/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.browser.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.GroupSearch;
import com.liferay.portlet.usersadmin.search.GroupSearchTerms;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteBrowserDisplayContext {
    private static final long[] _CLASS_NAME_IDS = new long[]{PortalUtil.getClassNameId(Group.class), PortalUtil.getClassNameId(Organization.class)};
    private static final Log _log = LogFactoryUtil.getLog(SiteBrowserDisplayContext.class);
    private String _displayStyle;
    private String _eventName;
    private String _filter;
    private Long _groupId;
    private LinkedHashMap<String, Object> _groupParams;
    private GroupSearch _groupSearch;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private Boolean _manualMembership;
    private String _orderByCol;
    private String _orderByType;
    private Boolean _privateLayout;
    private String _puid;
    private final User _selUser;
    private String _target;
    private String _type;
    private String[] _types;

    public SiteBrowserDisplayContext(HttpServletRequest httpServletRequest, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        this._httpServletRequest = httpServletRequest;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._selUser = PortalUtil.getSelectedUser((HttpServletRequest)this._httpServletRequest);
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._liferayPortletResponse.getNamespace() + "selectSite"));
        return this._eventName;
    }

    public GroupSearch getGroupSearch() throws Exception {
        String type;
        if (this._groupSearch != null) {
            return this._groupSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        GroupSearch groupSearch = new GroupSearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
        GroupSearchTerms groupSearchTerms = (GroupSearchTerms)groupSearch.getSearchTerms();
        ArrayList<Group> results = new ArrayList<Group>();
        int additionalSites = 0;
        int total = 0;
        boolean includeCompany = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"includeCompany");
        boolean includeUserPersonalSite = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"includeUserPersonalSite");
        long[] classNameIds = _CLASS_NAME_IDS;
        if (includeCompany) {
            classNameIds = ArrayUtil.append((long[])classNameIds, (long)PortalUtil.getClassNameId(Company.class));
        }
        if (includeUserPersonalSite) {
            if (groupSearch.getStart() == 0) {
                Group userPersonalSite = GroupLocalServiceUtil.getGroup((long)company.getCompanyId(), (String)"User Personal Site");
                results.add(userPersonalSite);
            }
            ++additionalSites;
        }
        if ((type = this.getType()).equals("layoutScopes")) {
            total = GroupLocalServiceUtil.getGroupsCount((long)themeDisplay.getCompanyId(), (String)Layout.class.getName(), (long)this._getGroupId());
        } else if (!type.equals("parent-sites")) {
            total = GroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])classNameIds, (String)groupSearchTerms.getKeywords(), this._getGroupParams());
        }
        groupSearch.setTotal(total += additionalSites);
        int start = groupSearch.getStart();
        if (groupSearch.getStart() > additionalSites) {
            start = groupSearch.getStart() - additionalSites;
        }
        List<Group> groups = null;
        if (type.equals("layoutScopes")) {
            groups = GroupLocalServiceUtil.getGroups((long)company.getCompanyId(), (String)Layout.class.getName(), (long)this._getGroupId(), (int)start, (int)(groupSearch.getResultEnd() - additionalSites));
            groups = this._filterLayoutGroups(groups, this._isPrivateLayout());
        } else if (type.equals("parent-sites")) {
            Group group = GroupLocalServiceUtil.getGroup((long)this._getGroupId());
            groups = group.getAncestors();
            String filter = this._getFilter();
            if (Validator.isNotNull((String)filter)) {
                groups = this._filterGroups(groups, filter);
            }
            total = groups.size();
            groupSearch.setTotal(total += additionalSites);
        } else {
            groups = GroupLocalServiceUtil.search((long)company.getCompanyId(), (long[])classNameIds, (String)groupSearchTerms.getKeywords(), this._getGroupParams(), (int)-1, (int)-1, (OrderByComparator)groupSearch.getOrderByComparator());
            groups = this._filterGroups(groups, themeDisplay.getPermissionChecker());
            total = groups.size();
            groupSearch.setTotal(total += additionalSites);
            groups = groups.subList(start, groupSearch.getResultEnd() - additionalSites);
        }
        results.addAll(groups);
        groupSearch.setResults(results);
        this._groupSearch = groupSearch;
        return this._groupSearch;
    }

    public List<NavigationItem> getNavigationItems() {
        final String[] types = this._getTypes();
        if (types.length == 1) {
            return new NavigationItemList(){
                {
                    this.add(navigationItem -> {
                        navigationItem.setActive(true);
                        navigationItem.setHref((Object)SiteBrowserDisplayContext.this._liferayPortletResponse.createRenderURL());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteBrowserDisplayContext.this._httpServletRequest, (String)"sites"));
                    });
                }
            };
        }
        if (types.length > 1) {
            return new NavigationItemList(){
                {
                    for (String curType : types) {
                        this.add(navigationItem -> {
                            navigationItem.setActive(curType.equals(SiteBrowserDisplayContext.this.getType()));
                            navigationItem.setHref(SiteBrowserDisplayContext.this.getPortletURL(), new Object[]{"type", curType});
                            navigationItem.setLabel(curType);
                        });
                    }
                }
            };
        }
        return Collections.emptyList();
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        User selUser;
        PortletURL portletURL;
        block3: {
            portletURL = this._liferayPortletResponse.createRenderURL();
            selUser = null;
            try {
                selUser = PortalUtil.getSelectedUser((HttpServletRequest)this._httpServletRequest);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        if (selUser != null) {
            portletURL.setParameter("p_u_i_d", String.valueOf(selUser.getUserId()));
        }
        boolean filterManageableGroups = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"filterManageableGroups", (boolean)true);
        boolean includeCompany = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"includeCompany");
        boolean includeCurrentGroup = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"includeCurrentGroup", (boolean)true);
        boolean includeUserPersonalSite = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"includeUserPersonalSite");
        String eventName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"eventName", (String)(this._liferayPortletResponse.getNamespace() + "selectSite"));
        String target = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"target");
        portletURL.setParameter("groupId", String.valueOf(this._getGroupId()));
        portletURL.setParameter("type", this.getType());
        portletURL.setParameter("types", this._getTypes());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("filter", this._getFilter());
        portletURL.setParameter("filterManageableGroups", String.valueOf(filterManageableGroups));
        portletURL.setParameter("includeCompany", String.valueOf(includeCompany));
        portletURL.setParameter("includeCurrentGroup", String.valueOf(includeCurrentGroup));
        portletURL.setParameter("includeUserPersonalSite", String.valueOf(includeUserPersonalSite));
        portletURL.setParameter("manualMembership", String.valueOf(this._isManualMembership()));
        portletURL.setParameter("eventName", eventName);
        portletURL.setParameter("orderByCol", this._getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        portletURL.setParameter("target", target);
        return portletURL;
    }

    public User getSelUser() {
        return this._selUser;
    }

    public String getTarget() {
        if (this._target != null) {
            return this._target;
        }
        this._target = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"target");
        return this._target;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        this._type = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"type");
        if (Validator.isNull((String)this._type)) {
            String[] types = this._getTypes();
            this._type = types[0];
        }
        return this._type;
    }

    public boolean isShowLink(Group group) {
        try {
            long userId = 0L;
            if (this._selUser != null) {
                userId = this._selUser.getUserId();
            }
            if (Validator.isNull((String)this._getPuid()) || SiteMembershipPolicyUtil.isMembershipAllowed((long)userId, (long)group.getGroupId())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private List<Group> _filterGroups(List<Group> groups, PermissionChecker permissionChecker) throws PortalException {
        boolean filterManageableGroups = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"filterManageableGroups", (boolean)true);
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!permissionChecker.isGroupAdmin(group.getGroupId()) && (filterManageableGroups || !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"ASSIGN_MEMBERS"))) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private List<Group> _filterGroups(List<Group> groups, String filter) {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!filter.equals("contentSharingWithChildrenEnabled") || !SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private List<Group> _filterLayoutGroups(List<Group> groups, Boolean privateLayout) throws Exception {
        if (privateLayout == null) {
            return groups;
        }
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            Layout layout;
            if (!group.isLayout() || (layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK())).isPrivateLayout() != privateLayout.booleanValue()) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private String _getFilter() {
        if (this._filter != null) {
            return this._filter;
        }
        this._filter = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"filter");
        return this._filter;
    }

    private long _getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId");
        return this._groupId;
    }

    private LinkedHashMap<String, Object> _getGroupParams() throws PortalException {
        if (this._groupParams != null) {
            return this._groupParams;
        }
        long groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId");
        boolean includeCurrentGroup = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"includeCurrentGroup", (boolean)true);
        String type = this.getType();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        boolean filterManageableGroups = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"filterManageableGroups", (boolean)true);
        if (permissionChecker.isCompanyAdmin()) {
            filterManageableGroups = false;
        }
        this._groupParams = new LinkedHashMap();
        this._groupParams.put("active", Boolean.TRUE);
        if (this._isManualMembership().booleanValue()) {
            this._groupParams.put("manualMembership", Boolean.TRUE);
        }
        if (type.equals("child-sites")) {
            Group parentGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            this._groupParams.put("groupsTree", ListUtil.toList((Object)parentGroup));
        } else if (filterManageableGroups) {
            User user = themeDisplay.getUser();
            this._groupParams.put("usersGroups", user.getUserId());
        }
        this._groupParams.put("site", Boolean.TRUE);
        if (!includeCurrentGroup && groupId > 0L) {
            ArrayList<Long> excludedGroupIds = new ArrayList<Long>();
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isStagingGroup()) {
                excludedGroupIds.add(group.getLiveGroupId());
            } else {
                excludedGroupIds.add(groupId);
            }
            this._groupParams.put("excludedGroupIds", excludedGroupIds);
        }
        return this._groupParams;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    private String _getPuid() {
        if (this._puid != null) {
            return this._puid;
        }
        this._puid = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"p_u_i_d");
        return this._puid;
    }

    private String[] _getTypes() {
        if (this._types != null) {
            return this._types;
        }
        this._types = ParamUtil.getParameterValues((HttpServletRequest)this._httpServletRequest, (String)"types");
        if (this._types.length == 0) {
            this._types = new String[]{"sites-that-i-administer"};
        }
        return this._types;
    }

    private Boolean _isManualMembership() {
        if (this._manualMembership != null) {
            return this._manualMembership;
        }
        this._manualMembership = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"manualMembership");
        return this._manualMembership;
    }

    private Boolean _isPrivateLayout() {
        if (this._privateLayout != null) {
            return this._privateLayout;
        }
        this._privateLayout = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"privateLayout");
        return this._privateLayout;
    }
}

