/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.browser.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.GroupSearch;
import com.liferay.portlet.usersadmin.search.GroupSearchTerms;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteBrowserDisplayContext {
    private static final long[] _CLASS_NAME_IDS = new long[]{PortalUtil.getClassNameId(Group.class), PortalUtil.getClassNameId(Organization.class)};
    private static final Log _log = LogFactoryUtil.getLog(SiteBrowserDisplayContext.class);
    private String _displayStyle;
    private String _filter;
    private Long _groupId;
    private LinkedHashMap<String, Object> _groupParams;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private Boolean _manualMembership;
    private String _orderByCol;
    private String _orderByType;
    private Boolean _privateLayout;
    private final HttpServletRequest _request;
    private String _type;
    private String[] _types;

    public SiteBrowserDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = portalPreferences.getValue("com_liferay_site_browser_web_portlet_SiteBrowserPortlet", "display-style", "list");
        return this._displayStyle;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SiteBrowserDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteBrowserDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SiteBrowserDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteBrowserDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public GroupSearch getGroupSearch() throws Exception {
        String type;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        GroupSearch groupSearch = new GroupSearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
        GroupSearchTerms groupSearchTerms = (GroupSearchTerms)groupSearch.getSearchTerms();
        ArrayList<Group> results = new ArrayList<Group>();
        int additionalSites = 0;
        int total = 0;
        boolean includeCompany = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCompany");
        boolean includeUserPersonalSite = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeUserPersonalSite");
        long[] classNameIds = _CLASS_NAME_IDS;
        if (includeCompany) {
            classNameIds = ArrayUtil.append((long[])classNameIds, (long)PortalUtil.getClassNameId(Company.class));
        }
        if (includeUserPersonalSite) {
            if (groupSearch.getStart() == 0) {
                Group userPersonalSite = GroupLocalServiceUtil.getGroup((long)company.getCompanyId(), (String)"User Personal Site");
                results.add(userPersonalSite);
            }
            ++additionalSites;
        }
        if ((type = this.getType()).equals("layoutScopes")) {
            total = GroupLocalServiceUtil.getGroupsCount((long)themeDisplay.getCompanyId(), (String)Layout.class.getName(), (long)this._getGroupId());
        } else if (!type.equals("parent-sites")) {
            total = GroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])classNameIds, (String)groupSearchTerms.getKeywords(), this._getGroupParams());
        }
        groupSearch.setTotal(total += additionalSites);
        int start = groupSearch.getStart();
        if (groupSearch.getStart() > additionalSites) {
            start = groupSearch.getStart() - additionalSites;
        }
        List<Group> groups = null;
        if (type.equals("layoutScopes")) {
            groups = GroupLocalServiceUtil.getGroups((long)company.getCompanyId(), (String)Layout.class.getName(), (long)this._getGroupId(), (int)start, (int)(groupSearch.getResultEnd() - additionalSites));
            groups = this._filterLayoutGroups(groups, this._isPrivateLayout());
        } else if (type.equals("parent-sites")) {
            Group group = GroupLocalServiceUtil.getGroup((long)this._getGroupId());
            groups = group.getAncestors();
            String filter = this._getFilter();
            if (Validator.isNotNull((String)filter)) {
                groups = this._filterGroups(groups, filter);
            }
            total = groups.size();
            groupSearch.setTotal(total += additionalSites);
        } else {
            groups = GroupLocalServiceUtil.search((long)company.getCompanyId(), (long[])classNameIds, (String)groupSearchTerms.getKeywords(), this._getGroupParams(), (int)-1, (int)-1, (OrderByComparator)groupSearch.getOrderByComparator());
            groups = this._filterGroups(groups, themeDisplay.getPermissionChecker());
            total = groups.size();
            groupSearch.setTotal(total += additionalSites);
            groups = groups.subList(start, groupSearch.getResultEnd() - additionalSites);
        }
        results.addAll(groups);
        groupSearch.setResults(results);
        return groupSearch;
    }

    public List<NavigationItem> getNavigationItems() {
        final String[] types = this._getTypes();
        if (types.length == 1) {
            return new NavigationItemList(){
                {
                    this.add(navigationItem -> {
                        navigationItem.setActive(true);
                        navigationItem.setHref((Object)SiteBrowserDisplayContext.this._liferayPortletResponse.createRenderURL());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteBrowserDisplayContext.this._request, (String)"sites"));
                    });
                }
            };
        }
        if (types.length > 1) {
            return new NavigationItemList(){
                {
                    for (String curType : types) {
                        this.add(SafeConsumer.ignore(navigationItem -> {
                            navigationItem.setActive(curType.equals(SiteBrowserDisplayContext.this.getType()));
                            navigationItem.setHref(SiteBrowserDisplayContext.this.getPortletURL(), new Object[]{"type", curType});
                            navigationItem.setLabel(curType);
                        }));
                    }
                }
            };
        }
        return Collections.emptyList();
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        User selUser;
        PortletURL portletURL;
        block3: {
            portletURL = this._liferayPortletResponse.createRenderURL();
            selUser = null;
            try {
                selUser = PortalUtil.getSelectedUser((HttpServletRequest)this._request);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        if (selUser != null) {
            portletURL.setParameter("p_u_i_d", String.valueOf(selUser.getUserId()));
        }
        boolean includeCompany = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCompany");
        boolean includeCurrentGroup = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCurrentGroup", (boolean)true);
        boolean includeUserPersonalSite = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeUserPersonalSite");
        String eventName = ParamUtil.getString((HttpServletRequest)this._request, (String)"eventName", (String)(this._liferayPortletResponse.getNamespace() + "selectSite"));
        String target = ParamUtil.getString((HttpServletRequest)this._request, (String)"target");
        portletURL.setParameter("groupId", String.valueOf(this._getGroupId()));
        portletURL.setParameter("type", this.getType());
        portletURL.setParameter("types", this._getTypes());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("filter", this._getFilter());
        portletURL.setParameter("includeCompany", String.valueOf(includeCompany));
        portletURL.setParameter("includeCurrentGroup", String.valueOf(includeCurrentGroup));
        portletURL.setParameter("includeUserPersonalSite", String.valueOf(includeUserPersonalSite));
        portletURL.setParameter("manualMembership", String.valueOf(this._isManualMembership()));
        portletURL.setParameter("eventName", eventName);
        portletURL.setParameter("orderByCol", this._getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        portletURL.setParameter("target", target);
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() throws Exception {
        GroupSearch groupSearch = this.getGroupSearch();
        return groupSearch.getTotal();
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        this._type = ParamUtil.getString((HttpServletRequest)this._request, (String)"type");
        String[] types = this._getTypes();
        if (Validator.isNull((String)this._type)) {
            this._type = types[0];
        }
        return this._type;
    }

    public List<ViewTypeItem> getViewTypeItems() {
        PortletURL portletURL = this._liferayPortletResponse.createActionURL();
        portletURL.setParameter("javax.portlet.action", "changeDisplayStyle");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._request));
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    private List<Group> _filterGroups(List<Group> groups, PermissionChecker permissionChecker) throws PortalException {
        boolean filterManageableGroups = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"filterManageableGroups", (boolean)true);
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!permissionChecker.isGroupAdmin(group.getGroupId()) && (filterManageableGroups || !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"ASSIGN_MEMBERS"))) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private List<Group> _filterGroups(List<Group> groups, String filter) {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!filter.equals("contentSharingWithChildrenEnabled") || !SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private List<Group> _filterLayoutGroups(List<Group> groups, Boolean privateLayout) throws Exception {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        if (privateLayout == null) {
            return groups;
        }
        for (Group group : groups) {
            Layout layout;
            if (!group.isLayout() || (layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK())).isPrivateLayout() != privateLayout.booleanValue()) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private String _getFilter() {
        if (this._filter != null) {
            return this._filter;
        }
        this._filter = ParamUtil.getString((HttpServletRequest)this._request, (String)"filter");
        return this._filter;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)SiteBrowserDisplayContext.this.getPortletURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteBrowserDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private long _getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId");
        return this._groupId;
    }

    private LinkedHashMap<String, Object> _getGroupParams() throws PortalException {
        if (this._groupParams != null) {
            return this._groupParams;
        }
        long groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId");
        boolean includeCurrentGroup = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCurrentGroup", (boolean)true);
        String type = this.getType();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        User user = themeDisplay.getUser();
        boolean filterManageableGroups = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"filterManageableGroups", (boolean)true);
        if (permissionChecker.isCompanyAdmin()) {
            filterManageableGroups = false;
        }
        this._groupParams = new LinkedHashMap();
        this._groupParams.put("active", Boolean.TRUE);
        if (this._isManualMembership().booleanValue()) {
            this._groupParams.put("manualMembership", Boolean.TRUE);
        }
        if (type.equals("child-sites")) {
            Group parentGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            ArrayList<Group> parentGroups = new ArrayList<Group>();
            parentGroups.add(parentGroup);
            this._groupParams.put("groupsTree", parentGroups);
        } else if (filterManageableGroups) {
            this._groupParams.put("usersGroups", user.getUserId());
        }
        this._groupParams.put("site", Boolean.TRUE);
        if (!includeCurrentGroup && groupId > 0L) {
            ArrayList<Long> excludedGroupIds = new ArrayList<Long>();
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isStagingGroup()) {
                excludedGroupIds.add(group.getLiveGroupId());
            } else {
                excludedGroupIds.add(groupId);
            }
            this._groupParams.put("excludedGroupIds", excludedGroupIds);
        }
        return this._groupParams;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SiteBrowserDisplayContext.this._getOrderByCol(), "name"));
                    dropdownItem.setHref(SiteBrowserDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteBrowserDisplayContext.this._request, (String)"name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(SiteBrowserDisplayContext.this._getOrderByCol(), "type"));
                    dropdownItem.setHref(SiteBrowserDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "type"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteBrowserDisplayContext.this._request, (String)"type"));
                });
            }
        };
    }

    private String[] _getTypes() {
        if (this._types != null) {
            return this._types;
        }
        this._types = ParamUtil.getParameterValues((HttpServletRequest)this._request, (String)"types");
        if (this._types.length == 0) {
            this._types = new String[]{"sites-that-i-administer"};
        }
        return this._types;
    }

    private Boolean _isManualMembership() {
        if (this._manualMembership != null) {
            return this._manualMembership;
        }
        this._manualMembership = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"manualMembership");
        return this._manualMembership;
    }

    private Boolean _isPrivateLayout() {
        if (this._privateLayout != null) {
            return this._privateLayout;
        }
        this._privateLayout = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"privateLayout");
        return this._privateLayout;
    }
}

