/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.servlet.taglib.util;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.site.admin.web.internal.display.context.SiteAdminDisplayContext;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteActionDropdownItemsProvider {
    private final Group _group;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _redirect;
    private final SiteAdminDisplayContext _siteAdminDisplayContext;
    private final ThemeDisplay _themeDisplay;

    public SiteActionDropdownItemsProvider(Group group, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, SiteAdminDisplayContext siteAdminDisplayContext) {
        this._group = group;
        this._liferayPortletResponse = liferayPortletResponse;
        this._siteAdminDisplayContext = siteAdminDisplayContext;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                boolean hasUpdatePermission = GroupPermissionUtil.contains((PermissionChecker)SiteActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), (Group)SiteActionDropdownItemsProvider.this._group, (String)"UPDATE");
                if (hasUpdatePermission) {
                    int count = GroupLocalServiceUtil.getGroupsCount((long)SiteActionDropdownItemsProvider.this._themeDisplay.getCompanyId(), (long)SiteActionDropdownItemsProvider.this._group.getGroupId(), (boolean)true);
                    if (count > 0) {
                        this.add(SiteActionDropdownItemsProvider.this._getViewChildSitesActionUnsafeConsumer());
                    }
                    if (SiteActionDropdownItemsProvider.this._siteAdminDisplayContext.hasAddChildSitePermission(SiteActionDropdownItemsProvider.this._group)) {
                        this.add(SiteActionDropdownItemsProvider.this._getAddChildSiteActionUnsafeConsumer());
                    }
                    this.add(SiteActionDropdownItemsProvider.this._getViewSiteSettingsActionUnsafeConsumer());
                }
                if (SiteActionDropdownItemsProvider.this._group.isActive() && SiteActionDropdownItemsProvider.this._group.getPublicLayoutsPageCount() > 0) {
                    this.add(SiteActionDropdownItemsProvider.this._getViewSitePublicPagesActionUnsafeConsumer());
                }
                if (SiteActionDropdownItemsProvider.this._group.isActive() && SiteActionDropdownItemsProvider.this._group.getPrivateLayoutsPageCount() > 0) {
                    this.add(SiteActionDropdownItemsProvider.this._getViewSitePrivatePagesActionUnsafeConsumer());
                }
                if (SiteActionDropdownItemsProvider.this._hasEditAssignmentsPermission()) {
                    this.add(SiteActionDropdownItemsProvider.this._getLeaveSiteActionUnsafeConsumer());
                }
                if (hasUpdatePermission) {
                    if (SiteActionDropdownItemsProvider.this._group.isActive() && !SiteActionDropdownItemsProvider.this._group.isCompany() && !SiteActionDropdownItemsProvider.this._group.isGuest()) {
                        this.add(SiteActionDropdownItemsProvider.this._getDeactivateSiteActionUnsafeConsumer());
                    } else if (!SiteActionDropdownItemsProvider.this._group.isActive() && !SiteActionDropdownItemsProvider.this._group.isCompany()) {
                        this.add(SiteActionDropdownItemsProvider.this._getActivateSiteActionUnsafeConsumer());
                    }
                }
                if (SiteActionDropdownItemsProvider.this._hasDeleteGroupPermission()) {
                    this.add(SiteActionDropdownItemsProvider.this._getDeleteSiteActionUnsafeConsumer());
                }
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getActivateSiteActionUnsafeConsumer() {
        PortletURL activateSiteURL = this._liferayPortletResponse.createActionURL();
        activateSiteURL.setParameter("javax.portlet.action", "activate");
        activateSiteURL.setParameter("redirect", this._getRedirect());
        activateSiteURL.setParameter("groupId", String.valueOf(this._group.getGroupId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "activateSite");
            dropdownItem.putData("activateSiteURL", activateSiteURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"activate"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getAddChildSiteActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/site/select_site_initializer", "redirect", this._themeDisplay.getURLCurrent(), "parentGroupId", String.valueOf(this._group.getGroupId())});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"add-child-site"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeactivateSiteActionUnsafeConsumer() {
        PortletURL deactivateSiteURL = this._liferayPortletResponse.createActionURL();
        deactivateSiteURL.setParameter("javax.portlet.action", "deactivate");
        deactivateSiteURL.setParameter("redirect", this._getRedirect());
        deactivateSiteURL.setParameter("groupId", String.valueOf(this._group.getGroupId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deactivateSite");
            dropdownItem.putData("deactivateSiteURL", deactivateSiteURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"deactivate"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteSiteActionUnsafeConsumer() {
        PortletURL deleteSiteURL = this._liferayPortletResponse.createActionURL();
        deleteSiteURL.setParameter("javax.portlet.action", "deleteGroups");
        deleteSiteURL.setParameter("redirect", this._getRedirect());
        deleteSiteURL.setParameter("groupId", String.valueOf(this._group.getGroupId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteSite");
            dropdownItem.putData("deleteSiteURL", deleteSiteURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getLeaveSiteActionUnsafeConsumer() {
        PortletURL leaveSiteURL = this._liferayPortletResponse.createActionURL();
        leaveSiteURL.setParameter("javax.portlet.action", "editGroupAssignments");
        leaveSiteURL.setParameter("redirect", this._getRedirect());
        leaveSiteURL.setParameter("groupId", String.valueOf(this._group.getGroupId()));
        leaveSiteURL.setParameter("removeUserIds", String.valueOf(this._themeDisplay.getUserId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "leaveSite");
            dropdownItem.putData("leaveSiteURL", leaveSiteURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"leave"));
        };
    }

    private String _getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
        return this._redirect;
    }

    private UnsafeConsumer<DropdownItem, Exception> _getViewChildSitesActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"backURL", this._getRedirect(), "groupId", String.valueOf(this._group.getGroupId())});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"view-child-sites"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getViewSitePrivatePagesActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref((Object)this._group.getDisplayURL(this._themeDisplay, true));
            dropdownItem.setTarget("_blank");
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"go-to-private-pages"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getViewSitePublicPagesActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref((Object)this._group.getDisplayURL(this._themeDisplay, false));
            dropdownItem.setTarget("_blank");
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"go-to-public-pages"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getViewSiteSettingsActionUnsafeConsumer() {
        PortletURL viewSiteSettingsURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)this._httpServletRequest, (Group)this._group, (String)"com_liferay_site_admin_web_portlet_SiteSettingsPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        return dropdownItem -> {
            dropdownItem.setHref((Object)viewSiteSettingsURL);
            dropdownItem.setTarget("_blank");
            dropdownItem.setLabel(LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"go-to-x", (Object)"site-settings"));
        };
    }

    private boolean _hasDeleteGroupPermission() throws PortalException {
        if (this._group.isCompany()) {
            return false;
        }
        if (!GroupPermissionUtil.contains((PermissionChecker)this._themeDisplay.getPermissionChecker(), (Group)this._group, (String)"DELETE")) {
            return false;
        }
        return !PortalUtil.isSystemGroup((String)this._group.getGroupKey());
    }

    private boolean _hasEditAssignmentsPermission() throws Exception {
        if (this._group.isCompany()) {
            return false;
        }
        List organizationNames = SitesUtil.getOrganizationNames((Group)this._group, (User)this._themeDisplay.getUser());
        if (!organizationNames.isEmpty()) {
            return false;
        }
        List userGroupNames = SitesUtil.getUserGroupNames((Group)this._group, (User)this._themeDisplay.getUser());
        if (!userGroupNames.isEmpty()) {
            return false;
        }
        if (this._group.getType() != 1 && this._group.getType() != 2) {
            return false;
        }
        if (GroupLocalServiceUtil.hasUserGroup((long)this._themeDisplay.getUserId(), (long)this._group.getGroupId())) {
            return false;
        }
        return !SiteMembershipPolicyUtil.isMembershipRequired((long)this._themeDisplay.getUserId(), (long)this._group.getGroupId());
    }
}

