/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.servlet.taglib.clay;

import com.liferay.frontend.taglib.clay.servlet.taglib.soy.BaseBaseClayCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.site.admin.web.internal.display.context.SiteAdminDisplayContext;
import com.liferay.site.admin.web.internal.servlet.taglib.util.SiteActionDropdownItemsProvider;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteVerticalCard
extends BaseBaseClayCard
implements VerticalCard {
    private final Group _group;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final SiteAdminDisplayContext _siteAdminDisplayContext;
    private final ThemeDisplay _themeDisplay;

    public SiteVerticalCard(BaseModel<?> baseModel, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, RowChecker rowChecker, SiteAdminDisplayContext siteAdminDisplayContext) {
        super(baseModel, rowChecker);
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._siteAdminDisplayContext = siteAdminDisplayContext;
        this._group = (Group)baseModel;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        this._themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        SiteActionDropdownItemsProvider siteActionDropdownItemsProvider = new SiteActionDropdownItemsProvider(this._group, this._liferayPortletRequest, this._liferayPortletResponse, this._siteAdminDisplayContext);
        try {
            return siteActionDropdownItemsProvider.getActionDropdownItems();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDefaultEventHandler() {
        return "SITE_DROPDOWN_DEFAULT_EVENT_HANDLER";
    }

    public String getHref() {
        if (this._group.isCompany()) {
            return null;
        }
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
        portletURL.setParameter("groupId", String.valueOf(this._group.getGroupId()));
        return portletURL.toString();
    }

    public String getIcon() {
        return "sites";
    }

    public String getImageSrc() {
        return this._group.getLogoURL(this._themeDisplay, false);
    }

    public String getStickerIcon() {
        if (!this._group.isActive()) {
            return "hidden";
        }
        return null;
    }

    public String getStickerStyle() {
        return "light";
    }

    public String getSubtitle() {
        if (this._group.isCompany()) {
            return "-";
        }
        List childSites = this._group.getChildren(true);
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"x-child-sites", (Object)childSites.size());
    }

    public String getTitle() {
        try {
            return HtmlUtil.escape((String)this._group.getDescriptiveName(this._themeDisplay.getLocale()));
        }
        catch (Exception exception) {
            return this._group.getName(this._themeDisplay.getLocale());
        }
    }
}

