/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.asset.model;

import com.liferay.asset.kernel.model.BaseAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteAssetRenderer
extends BaseAssetRenderer<Group> {
    private static final Log _log = LogFactoryUtil.getLog(SiteAssetRenderer.class);
    private final Group _siteGroup;

    public SiteAssetRenderer(Group group) {
        if (!group.isSite() && !group.isStagingGroup()) {
            throw new IllegalArgumentException("Only site groups are supported");
        }
        this._siteGroup = group;
    }

    public Group getAssetObject() {
        return this._siteGroup;
    }

    public String getClassName() {
        return Group.class.getName();
    }

    public long getClassPK() {
        return this._siteGroup.getPrimaryKey();
    }

    public long getGroupId() {
        return this._siteGroup.getGroupId();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        try {
            return this._siteGroup.getDescriptiveName(PortalUtil.getLocale((PortletRequest)portletRequest));
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get summary for group " + this._siteGroup.getGroupId()), (Throwable)pe);
            return null;
        }
    }

    public String getTitle(Locale locale) {
        try {
            return this._siteGroup.getDescriptiveName(locale);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get descriptive name for group " + this._siteGroup.getGroupId()), (Throwable)pe);
            return null;
        }
    }

    public long getUserId() {
        return this._siteGroup.getCreatorUserId();
    }

    public String getUserName() {
        return null;
    }

    public String getUuid() {
        return this._siteGroup.getUuid();
    }

    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) throws Exception {
        return false;
    }
}

