/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.handler;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.DuplicateGroupException;
import com.liferay.portal.kernel.exception.GroupInheritContentException;
import com.liferay.portal.kernel.exception.GroupKeyException;
import com.liferay.portal.kernel.exception.GroupParentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.SiteConstants;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={GroupExceptionRequestHandler.class})
public class GroupExceptionRequestHandler {
    public void handlePortalException(ActionRequest actionRequest, ActionResponse actionResponse, PortalException pe) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        String errorMessage = null;
        if (pe instanceof DuplicateGroupException) {
            errorMessage = LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"please-enter-a-unique-name");
        } else if (pe instanceof GroupInheritContentException) {
            errorMessage = LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"this-site-cannot-inherit-content-from-its-parent-site");
        } else if (pe instanceof GroupKeyException) {
            errorMessage = this._handleGroupKeyException(actionRequest);
        } else if (pe instanceof GroupParentException.MustNotBeOwnParent) {
            errorMessage = LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"this-site-cannot-inherit-content-from-its-parent-site");
        }
        if (Validator.isNull((String)errorMessage)) {
            errorMessage = LanguageUtil.get((HttpServletRequest)themeDisplay.getRequest(), (String)"an-unexpected-error-occurred");
        }
        jsonObject.put("error", errorMessage);
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    private String _handleGroupKeyException(ActionRequest actionRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        StringBundler sb = new StringBundler(5);
        sb.append(LanguageUtil.format((HttpServletRequest)themeDisplay.getRequest(), (String)"the-x-cannot-be-x-or-a-reserved-word-such-as-x", (Object[])new String[]{"site-name", SiteConstants.getNameGeneralRestrictions((Locale)themeDisplay.getLocale()), "null"}));
        sb.append(" ");
        sb.append(LanguageUtil.format((HttpServletRequest)themeDisplay.getRequest(), (String)"the-x-cannot-contain-the-following-invalid-characters-x", (Object[])new String[]{"site-name", "*"}));
        sb.append(" ");
        int groupKeyMaxLength = ModelHintsUtil.getMaxLength((String)Group.class.getName(), (String)"groupKey");
        sb.append(LanguageUtil.format((HttpServletRequest)themeDisplay.getRequest(), (String)"the-x-cannot-contain-more-than-x-characters", (Object[])new String[]{"site-name", String.valueOf(groupKeyMaxLength)}));
        return sb.toString();
    }
}

