/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shielded.container.internal.session;

import com.liferay.shielded.container.internal.ShieldedContainerClassLoader;
import com.liferay.shielded.container.internal.session.SerializationUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;

public class ShieldedContainerHttpSessionActivationListener
implements HttpSessionActivationListener,
Serializable {
    public static final String NAME = ShieldedContainerHttpSessionActivationListener.class.getName();
    private static final String _SCRUBBED_NAMES_NAME = ShieldedContainerHttpSessionActivationListener.class.getName() + "._SCRUBBED_NAMES_NAME";
    private static final Set<Class<?>> _safeClasses = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class));

    public void sessionDidActivate(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        List scrubbedNames = (List)httpSession.getAttribute(_SCRUBBED_NAMES_NAME);
        if (scrubbedNames == null) {
            return;
        }
        httpSession.removeAttribute(_SCRUBBED_NAMES_NAME);
        ServletContext servletContext = httpSession.getServletContext();
        ClassLoader classLoader = (ClassLoader)servletContext.getAttribute(ShieldedContainerClassLoader.NAME);
        Throwable runtimeException = null;
        for (String scrubbedName : scrubbedNames) {
            try {
                httpSession.setAttribute(scrubbedName, SerializationUtil.deserialize((byte[])httpSession.getAttribute(scrubbedName), classLoader));
            }
            catch (Exception exception) {
                if (runtimeException == null) {
                    runtimeException = new RuntimeException("Unable to recover scrubbed value", exception);
                    continue;
                }
                runtimeException.addSuppressed(exception);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    public void sessionWillPassivate(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        Enumeration enumeration = httpSession.getAttributeNames();
        ArrayList<String> scrubbedNames = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            Object value;
            String name = (String)enumeration.nextElement();
            if (name.equals(NAME) || !((value = httpSession.getAttribute(name)) instanceof Serializable) || _safeClasses.contains(value.getClass())) continue;
            try {
                httpSession.setAttribute(name, (Object)SerializationUtil.serialize((Serializable)value));
                scrubbedNames.add(name);
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to scrub value", ioException);
            }
        }
        if (!scrubbedNames.isEmpty()) {
            httpSession.setAttribute(_SCRUBBED_NAMES_NAME, scrubbedNames);
        }
    }
}

