/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shielded.container.internal.proxy;

import com.liferay.shielded.container.internal.proxy.EventListenerInvocationHandler;
import com.liferay.shielded.container.internal.proxy.FilterWrapper;
import com.liferay.shielded.container.internal.proxy.HttpSessionListenerInvocationHandlerWrapper;
import com.liferay.shielded.container.internal.proxy.LazyInstanceSupplier;
import com.liferay.shielded.container.internal.proxy.ProxyFactory;
import com.liferay.shielded.container.internal.proxy.ServletWrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedHashSet;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpSessionListener;

public class ServletContextDelegate {
    private static final String _APACHE_NAMESPACE = "org.apache.";
    private static final String _LIFERAY_NAMESPACE = "com.liferay.";
    private final ClassLoader _classLoader;
    private ServletContext _proxiedServletContext;
    private final ProxyFactory _proxyFactory;
    private final ServletContext _servletContext;

    public static ServletContext create(ClassLoader classLoader, ServletContext servletContext) {
        ProxyFactory proxyFactory = new ProxyFactory(classLoader);
        ServletContextDelegate servletContextDelegate = new ServletContextDelegate(classLoader, proxyFactory, servletContext);
        servletContextDelegate._proxiedServletContext = servletContext = proxyFactory.createASMWrapper(classLoader, ServletContext.class, servletContextDelegate, servletContext);
        return servletContext;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        try {
            return this._servletContext.addFilter(filterName, (Filter)new FilterWrapper(this._proxyFactory, new LazyInstanceSupplier<Filter>(filterClass), this._proxiedServletContext));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this._servletContext.addFilter(filterName, (Filter)new FilterWrapper(this._proxyFactory, () -> filter, this._proxiedServletContext));
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String filterClassName) {
        try {
            return this.addFilter(filterName, this._classLoader.loadClass(filterClassName));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        try {
            Constructor<? extends EventListener> constructor = listenerClass.getConstructor(new Class[0]);
            this.addListener(constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public void addListener(String listenerClassName) {
        try {
            this.addListener((EventListener)((Object)this._classLoader.loadClass(listenerClassName)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        LinkedHashSet interfaceClasses = new LinkedHashSet();
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                interfaceClasses.add(interfaceClass);
            }
        }
        InvocationHandler invocationHandler = new EventListenerInvocationHandler(this._proxiedServletContext, this._classLoader, t);
        if (interfaceClasses.contains(HttpSessionListener.class)) {
            invocationHandler = new HttpSessionListenerInvocationHandlerWrapper(invocationHandler, this._proxyFactory, this._classLoader);
        }
        this._servletContext.addListener((EventListener)this._proxyFactory.newProxyInstance(this._classLoader, interfaceClasses.toArray(new Class[0]), invocationHandler));
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        try {
            return this._servletContext.addServlet(servletName, (Servlet)new ServletWrapper(this._proxyFactory, new LazyInstanceSupplier<Servlet>(servletClass), this._proxiedServletContext));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this._servletContext.addServlet(servletName, (Servlet)new ServletWrapper(this._proxyFactory, () -> servlet, this._proxiedServletContext));
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String servletClassName) {
        try {
            return this.addServlet(servletName, this._classLoader.loadClass(servletClassName));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public Object getAttribute(String name) {
        return this._servletContext.getAttribute(this._encodeName(name));
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enumeration = this._servletContext.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            names.add(this._decodeName((String)enumeration.nextElement()));
        }
        return Collections.enumeration(names);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getContextPath() {
        String contextPath = this._servletContext.getContextPath();
        if (contextPath.equals("/")) {
            return "";
        }
        return contextPath;
    }

    public String getInitParameter(String name) {
        return this._servletContext.getInitParameter(this._encodeName(name));
    }

    public Enumeration<String> getInitParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enumeration = this._servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            names.add(this._decodeName((String)enumeration.nextElement()));
        }
        return Collections.enumeration(names);
    }

    public void removeAttribute(String name) {
        this._servletContext.removeAttribute(this._encodeName(name));
    }

    public void setAttribute(String name, Object object) {
        this._servletContext.setAttribute(this._encodeName(name), object);
    }

    public boolean setInitParameter(String name, String value) {
        return this._servletContext.setInitParameter(this._encodeName(name), value);
    }

    private ServletContextDelegate(ClassLoader classLoader, ProxyFactory proxyFactory, ServletContext servletContext) {
        this._classLoader = classLoader;
        this._proxyFactory = proxyFactory;
        this._servletContext = servletContext;
    }

    private String _decodeName(String name) {
        if (name.startsWith(_LIFERAY_NAMESPACE)) {
            return name.substring(_LIFERAY_NAMESPACE.length());
        }
        return name;
    }

    private String _encodeName(String name) {
        if (name.startsWith(_APACHE_NAMESPACE)) {
            return _LIFERAY_NAMESPACE.concat(name);
        }
        return name;
    }
}

