/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shielded.container.internal.proxy;

import com.liferay.shielded.container.internal.proxy.HttpSessionDelegate;
import com.liferay.shielded.container.internal.proxy.ProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class HttpSessionListenerInvocationHandlerWrapper
implements InvocationHandler {
    private static final Method _sessionDestroyedMethod;
    private final ClassLoader _classLoader;
    private final InvocationHandler _invocationHandler;
    private final ProxyFactory _proxyFactory;

    public HttpSessionListenerInvocationHandlerWrapper(InvocationHandler invocationHandler, ProxyFactory proxyFactory, ClassLoader classLoader) {
        this._invocationHandler = invocationHandler;
        this._proxyFactory = proxyFactory;
        this._classLoader = classLoader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (_sessionDestroyedMethod.equals(method)) {
            HttpSessionEvent httpSessionEvent = (HttpSessionEvent)args[0];
            HttpSession httpSession = httpSessionEvent.getSession();
            args[0] = new HttpSessionEvent(this._proxyFactory.createASMWrapper(this._classLoader, HttpSession.class, new HttpSessionDelegate(httpSession), httpSession));
        }
        return this._invocationHandler.invoke(proxy, method, args);
    }

    static {
        try {
            _sessionDestroyedMethod = HttpSessionListener.class.getMethod("sessionDestroyed", HttpSessionEvent.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
    }
}

