/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shielded.container.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class ShieldedContainerClassLoader
extends URLClassLoader {
    public static final String NAME = ShieldedContainerClassLoader.class.getName();
    private final ClassLoader _fallbackClassLoader;

    public ShieldedContainerClassLoader(URL[] urls, ClassLoader fallbackClassLoader) {
        super(urls, (ClassLoader)null);
        this._fallbackClassLoader = fallbackClassLoader;
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url == null) {
            url = this._fallbackClassLoader.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> enumeration = super.findResources(name);
        while (enumeration.hasMoreElements()) {
            urls.add(enumeration.nextElement());
        }
        enumeration = this._fallbackClassLoader.getResources(name);
        while (enumeration.hasMoreElements()) {
            urls.add(enumeration.nextElement());
        }
        return Collections.enumeration(urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this._fallbackClassLoader.loadClass(name);
        }
    }
}

