/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shielded.container.internal.proxy;

import com.liferay.shielded.container.internal.proxy.ProxyFactory;
import com.liferay.shielded.container.internal.proxy.ServletConfigDelegate;
import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletWrapper
implements Servlet {
    private final ClassLoader _classLoader;
    private final ProxyFactory _proxyFactory;
    private ServletConfig _servletConfig;
    private final ServletContext _servletContext;
    private final Supplier<? extends Servlet> _servletSupplier;

    public ServletWrapper(ProxyFactory proxyFactory, Supplier<? extends Servlet> servletSupplier, ServletContext servletContext) {
        this._proxyFactory = proxyFactory;
        this._servletSupplier = servletSupplier;
        this._servletContext = servletContext;
        this._classLoader = servletContext.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._classLoader);
        try {
            Servlet servlet = this._servletSupplier.get();
            servlet.destroy();
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public ServletConfig getServletConfig() {
        Servlet servlet = this._servletSupplier.get();
        return servlet.getServletConfig();
    }

    public String getServletInfo() {
        Servlet servlet = this._servletSupplier.get();
        return servlet.getServletInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig servletConfig) throws ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._classLoader);
        try {
            this._servletConfig = this._proxyFactory.createASMWrapper(this._servletContext.getClassLoader(), ServletConfig.class, new ServletConfigDelegate(this._servletContext), servletConfig);
            Servlet servlet = this._servletSupplier.get();
            servlet.init(this._servletConfig);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this._classLoader);
        try {
            Servlet servlet = this._servletSupplier.get();
            servlet.service(servletRequest, servletResponse);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }
}

