/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shielded.container.internal;

import com.liferay.shielded.container.Ordered;
import com.liferay.shielded.container.ShieldedContainerInitializer;
import com.liferay.shielded.container.internal.ShieldedContainerClassLoader;
import com.liferay.shielded.container.internal.proxy.ServletContextDelegate;
import com.liferay.shielded.container.internal.session.ShieldedContainerHttpSessionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class ShieldedContainerServletContainerInitializer
implements ServletContainerInitializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        ClassLoader shieldedContainerClassLoader = this._buildShieldContainerClassLoader(servletContext);
        servletContext = ServletContextDelegate.create(shieldedContainerClassLoader, servletContext);
        servletContext.addListener((EventListener)((Object)new ShieldedContainerHttpSessionListener(servletContext)));
        ServiceLoader<ShieldedContainerInitializer> serviceLoader = ServiceLoader.load(ShieldedContainerInitializer.class, shieldedContainerClassLoader);
        ArrayList shieldedContainerInitializers = new ArrayList();
        serviceLoader.forEach(shieldedContainerInitializers::add);
        shieldedContainerInitializers.sort((sci1, sci2) -> this._getOrder(sci1) - this._getOrder(sci2));
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(shieldedContainerClassLoader);
        try {
            for (ShieldedContainerInitializer shieldedContainerInitializer : shieldedContainerInitializers) {
                shieldedContainerInitializer.initialize(servletContext);
            }
        }
        finally {
            currentThread.setContextClassLoader(classLoader);
        }
    }

    private ClassLoader _buildShieldContainerClassLoader(ServletContext servletContext) throws ServletException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File shieldedContainerLib = new File(servletContext.getRealPath("/WEB-INF/shielded-container-lib"));
        try {
            for (File jarFile : shieldedContainerLib.listFiles((dir, name) -> {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(".jar");
            })) {
                URI uri = jarFile.toURI();
                urls.add(uri.toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServletException("Unable to convert shielded container lib jar to URL", (Throwable)malformedURLException);
        }
        urls.sort(Comparator.comparing(URL::getPath));
        ShieldedContainerClassLoader classLoader = new ShieldedContainerClassLoader(urls.toArray(new URL[0]), servletContext.getClassLoader());
        servletContext.setAttribute(ShieldedContainerClassLoader.NAME, (Object)classLoader);
        return classLoader;
    }

    private int _getOrder(Object object) {
        Class<?> clazz = object.getClass();
        Ordered ordered = clazz.getAnnotation(Ordered.class);
        if (ordered == null) {
            return 0;
        }
        return ordered.value();
    }
}

