Liferay.Loader.define('sharing-web$lodash-es@4.17.15/multiply', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import createMathOperation from './_createMathOperation.js';

  /**
   * Multiply two numbers.
   *
   * @static
   * @memberOf _
   * @since 4.7.0
   * @category Math
   * @param {number} multiplier The first number in a multiplication.
   * @param {number} multiplicand The second number in a multiplication.
   * @returns {number} Returns the product.
   * @example
   *
   * _.multiply(6, 4);
   * // => 24
   */
  var multiply = createMathOperation(function (multiplier, multiplicand) {
    return multiplier * multiplicand;
  }, 1);

  export default multiply;
});
//# sourceMappingURL=multiply.js.map