Liferay.Loader.define('sharing-web$lodash-es@4.17.15/_baseGet', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import castPath from './_castPath.js';
  import toKey from './_toKey.js';

  /**
   * The base implementation of `_.get` without support for default values.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Array|string} path The path of the property to get.
   * @returns {*} Returns the resolved value.
   */
  function baseGet(object, path) {
    path = castPath(path, object);

    var index = 0,
        length = path.length;

    while (object != null && index < length) {
      object = object[toKey(path[index++])];
    }
    return index && index == length ? object : undefined;
  }

  export default baseGet;
});
//# sourceMappingURL=_baseGet.js.map