Liferay.Loader.define('sharing-web$lodash-es@4.17.15/_baseCreate', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import isObject from './isObject.js';

  /** Built-in value references. */
  var objectCreate = Object.create;

  /**
   * The base implementation of `_.create` without support for assigning
   * properties to the created object.
   *
   * @private
   * @param {Object} proto The object to inherit from.
   * @returns {Object} Returns the new object.
   */
  var baseCreate = function () {
    function object() {}
    return function (proto) {
      if (!isObject(proto)) {
        return {};
      }
      if (objectCreate) {
        return objectCreate(proto);
      }
      object.prototype = proto;
      var result = new object();
      object.prototype = undefined;
      return result;
    };
  }();

  export default baseCreate;
});
//# sourceMappingURL=_baseCreate.js.map