Liferay.Loader.define('sharing-web$dom-helpers@5.2.0/esm/addEventListener', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  /* eslint-disable no-return-assign */
  import canUseDOM from './canUseDOM';
  export var optionsSupported = false;
  export var onceSupported = false;

  try {
    var options = {
      get passive() {
        return optionsSupported = true;
      },

      get once() {
        // eslint-disable-next-line no-multi-assign
        return onceSupported = optionsSupported = true;
      }

    };

    if (canUseDOM) {
      window.addEventListener('test', options, options);
      window.removeEventListener('test', options, true);
    }
  } catch (e) {}
  /* */


  /**
   * An `addEventListener` ponyfill, supports the `once` option
   */
  function addEventListener(node, eventName, handler, options) {
    if (options && typeof options !== 'boolean' && !onceSupported) {
      var once = options.once,
          capture = options.capture;
      var wrappedHandler = handler;

      if (!onceSupported && once) {
        wrappedHandler = handler.__once || function onceHandler(event) {
          this.removeEventListener(eventName, onceHandler, capture);
          handler.call(this, event);
        };

        handler.__once = wrappedHandler;
      }

      node.addEventListener(eventName, wrappedHandler, optionsSupported ? options : capture);
    }

    node.addEventListener(eventName, handler, options);
  }

  export default addEventListener;
});
//# sourceMappingURL=addEventListener.js.map